/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.handler;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoAuthenticationHandler {
    private final Logger LOGGER = LoggerFactory.getLogger(MoAuthenticationHandler.class);
    private DefaultAuthenticator authenticator;

    public boolean authenticateUser(HttpServletRequest req, HttpServletResponse resp, ApplicationUser user) {
        try {
            Authenticator originalAuthenticator = SecurityConfigFactory.getInstance().getAuthenticator();
            if (originalAuthenticator instanceof DefaultAuthenticator) {
                this.authenticator = (DefaultAuthenticator)originalAuthenticator;
            } else {
                this.authenticator = null;
                this.LOGGER.error("Wrong authenticator type. Waiting default instead of " + originalAuthenticator.getClass().getCanonicalName());
            }
            if (this.authenticator == null) {
                return false;
            }
            Class<DefaultAuthenticator> defaultAuthenticatorClass = DefaultAuthenticator.class;
            Class[] parameterTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Principal.class};
            Object[] parameters = new Object[]{req, resp, user};
            Method authoriseUserAndEstablishSessionMethod = defaultAuthenticatorClass.getDeclaredMethod("authoriseUserAndEstablishSession", parameterTypes);
            authoriseUserAndEstablishSessionMethod.setAccessible(true);
            Object invokeResult = authoriseUserAndEstablishSessionMethod.invoke((Object)this.authenticator, parameters);
            if (invokeResult instanceof Boolean) {
                return (Boolean)invokeResult;
            }
            this.LOGGER.error("Return type mismatch. Waiting bool instead of {}", (Object)invokeResult.getClass().getCanonicalName());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.LOGGER.error("Unexpected error while authentication [" + user.getUsername() + "]. Try to authenticate in other way. Details:", (Object)e.getMessage());
            return false;
        }
        return false;
    }
}

