/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.handler;

import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.dto.APIAuditRecord;
import com.miniorange.rest.auth.commons.dto.ApiKey;
import com.miniorange.rest.auth.commons.exceptions.MoPluginException;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.util.MoHashUtils;
import com.miniorange.rest.auth.commons.util.MoPluginConstants;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiKeyAuthenticationHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(ApiKeyAuthenticationHandler.class);
    private MoRESTAuthSettings settings;
    private UserManager userManager;
    private MoRESTPluginHandler restPluginHandler;
    private TransactionTemplate transactionTemplate;

    public ApiKeyAuthenticationHandler(MoRESTAuthSettings settings, UserManager userManager, MoRESTPluginHandler restPluginHandler, TransactionTemplate transactionTemplate) {
        this.settings = settings;
        this.userManager = userManager;
        this.restPluginHandler = restPluginHandler;
        this.transactionTemplate = transactionTemplate;
    }

    public APIAuditRecord performApiKeyAuthentication(final String authorizationToken, final APIAuditRecord apiAudit) throws MoPluginException {
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                boolean isApiKeyConfigured;
                LOGGER.debug("performing api key authentication");
                String[] keyParts = authorizationToken.split(":");
                String username = keyParts[0];
                LOGGER.debug("username is: " + username);
                if (ApiKeyAuthenticationHandler.this.userManager.resolve(username) == null) {
                    LOGGER.error("No user found");
                    if (StringUtils.isNumeric(username)) {
                        apiAudit.setStatus(MoPluginException.PluginErrorCode.PASSING_FOR_PAT.name());
                        LOGGER.debug(MoPluginException.PluginErrorCode.PASSING_FOR_PAT.getMessage());
                        return apiAudit;
                    }
                    apiAudit.setStatus(MoPluginException.PluginErrorCode.USER_DOES_NOT_EXIST.name());
                    apiAudit.setFailureReason(MoPluginException.PluginErrorCode.USER_DOES_NOT_EXIST.getMessage());
                    return apiAudit;
                }
                apiAudit.setUsername(username);
                boolean bl = isApiKeyConfigured = ApiKeyAuthenticationHandler.this.restPluginHandler.getApiKeysAfterMigration(username).size() > 0 || ApiKeyAuthenticationHandler.this.settings.getApiKeys(MoPluginConstants.ApiConstants.UNIVERSAL_API_KEYS.getKey()).size() > 0;
                if (!isApiKeyConfigured) {
                    LOGGER.debug("NO API Key Configured");
                    apiAudit.setStatus(MoPluginException.PluginErrorCode.NO_API_KEY_CONFIGURED.name());
                    apiAudit.setFailureReason(MoPluginException.PluginErrorCode.NO_API_KEY_CONFIGURED.getMessage());
                    return apiAudit;
                }
                String apiKey = keyParts[1];
                if (!ApiKeyAuthenticationHandler.this.validateApiKey(username, apiKey) && !ApiKeyAuthenticationHandler.this.validateApiKeyForUniversal(MoPluginConstants.ApiConstants.UNIVERSAL_API_KEYS.getKey(), apiKey)) {
                    LOGGER.error("Invalid API Key provided = " + apiKey);
                    apiAudit.setStatus(MoPluginException.PluginErrorCode.INVALID_API_KEY.name());
                    apiAudit.setFailureReason(MoPluginException.PluginErrorCode.INVALID_API_KEY.getMessage());
                    return apiAudit;
                }
                if (ApiKeyAuthenticationHandler.this.validateApiKeyForUniversal(MoPluginConstants.ApiConstants.UNIVERSAL_API_KEYS.getKey(), apiKey)) {
                    return ApiKeyAuthenticationHandler.this.validatedUniversalKeyConstraints(MoPluginConstants.ApiConstants.UNIVERSAL_API_KEYS.getKey(), apiKey, apiAudit);
                }
                byte[] salt = ApiKeyAuthenticationHandler.this.settings.getSalt(username);
                String hashedKey = MoHashUtils.hash(apiKey, salt);
                String encodedString = Base64.getEncoder().encodeToString(hashedKey.getBytes());
                ArrayList<List<String>> apiKeys = new ArrayList<List<String>>(ApiKeyAuthenticationHandler.this.restPluginHandler.getApiKeysAfterMigration(username).values());
                for (List list : apiKeys) {
                    Boolean updateApiKey;
                    if (!list.contains(encodedString)) continue;
                    apiAudit.setApiKeyName((String)list.get(1));
                    String apiExpiryDate = (String)list.get(3);
                    if (!apiExpiryDate.equals("")) {
                        Calendar cal = Calendar.getInstance();
                        SimpleDateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
                        try {
                            Date date = formatter.parse(apiExpiryDate);
                            if (cal.getTime().compareTo(date) >= 0) {
                                apiAudit.setStatus(MoPluginException.PluginErrorCode.Token_Expired.name());
                                LOGGER.error("Received token has expired");
                                apiAudit.setFailureReason(MoPluginException.PluginErrorCode.Token_Expired.getMessage());
                                return apiAudit;
                            }
                        }
                        catch (ParseException e) {
                            LOGGER.error("An exception has occurred" + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                    if (ApiKeyAuthenticationHandler.this.settings.getEnableRateLimiting()) {
                        List<String> rateLimitStatus = ApiKeyAuthenticationHandler.this.checkRateLimitStatus((String)list.get(6), (String)list.get(7), apiAudit);
                        switch (rateLimitStatus.get(0)) {
                            case "Error": {
                                updateApiKey = ApiKeyAuthenticationHandler.this.restPluginHandler.updateApiKey((String)list.get(0), null, null);
                                LOGGER.debug("Update Last Accessed Time for Key : " + updateApiKey);
                                apiAudit.setStatus(MoPluginException.PluginErrorCode.RATE_LIMIT_EXCEEDED.name());
                                apiAudit.setFailureReason(MoPluginException.PluginErrorCode.RATE_LIMIT_EXCEEDED.getMessage());
                                return apiAudit;
                            }
                            case "Exception": {
                                LOGGER.debug("Unknown Exception Occurred " + rateLimitStatus.get(1));
                                apiAudit.setStatus(MoPluginException.PluginErrorCode.UNKNOWN.name());
                                apiAudit.setFailureReason(MoPluginException.PluginErrorCode.UNKNOWN.getMessage());
                                return apiAudit;
                            }
                        }
                        updateApiKey = ApiKeyAuthenticationHandler.this.restPluginHandler.updateApiKey((String)list.get(0), rateLimitStatus.get(0), rateLimitStatus.get(1));
                        LOGGER.debug("Update Last Accessed Time for Key : " + updateApiKey);
                        break;
                    }
                    updateApiKey = ApiKeyAuthenticationHandler.this.restPluginHandler.updateApiKey((String)list.get(0), null, null);
                    LOGGER.debug("Update Last Accessed Time for Key : " + updateApiKey);
                    break;
                }
                apiAudit.setStatus(MoPluginConstants.Status.SUCCESS.name());
                return apiAudit;
            }
        });
        return apiAudit;
    }

    private boolean validateApiKey(String username, String apiKey) {
        LOGGER.debug("Validating API Key of user: " + username);
        byte[] salt = this.settings.getSalt(username);
        String hashedKey = MoHashUtils.hash(apiKey, salt);
        ArrayList<List<String>> apiKeys = new ArrayList<List<String>>(this.restPluginHandler.getApiKeysAfterMigration(username).values());
        String encodedString = Base64.getEncoder().encodeToString(hashedKey.getBytes());
        for (List list : apiKeys) {
            if (!list.contains(encodedString)) continue;
            LOGGER.debug("Valid api key");
            return list.contains(encodedString);
        }
        return false;
    }

    private boolean validateApiKeyForUniversal(String username, String apiKey) {
        LOGGER.debug("inside validate universal api key ");
        byte[] salt = this.settings.getSalt(username);
        String hashedKey = MoHashUtils.hash(apiKey, salt);
        ArrayList<String> apiKeys = new ArrayList<String>(this.settings.getApiKeys(username).values());
        LOGGER.debug("Iterating through the api keys configured for the user:-" + username);
        Map<String, String> apiKeysForUser = this.settings.getApiKeys(username);
        for (String string : apiKeysForUser.keySet()) {
        }
        return apiKeys.contains(hashedKey);
    }

    private APIAuditRecord validatedUniversalKeyConstraints(String username, String apiKey, APIAuditRecord apiAudit) {
        LOGGER.debug("inside validate universal api key ");
        byte[] salt = this.settings.getSalt(username);
        String hashedKey = MoHashUtils.hash(apiKey, salt);
        ArrayList<String> apiKeys = new ArrayList<String>(this.settings.getApiKeys(username).values());
        if (apiKeys.contains(hashedKey)) {
            HashMap<String, String> apiKeysData = new HashMap<String, String>(this.settings.getApiKeys(username));
            for (Map.Entry entry : apiKeysData.entrySet()) {
                boolean updateUniKey;
                if (!((String)entry.getValue()).equals(hashedKey)) continue;
                ApiKey key = this.settings.getApiKey((String)entry.getKey());
                Calendar cal = Calendar.getInstance();
                if (key.getExpiryDate() != null && cal.getTime().compareTo(key.getExpiryDate()) >= 0) {
                    LOGGER.error("Received token has been expired");
                    apiAudit.setStatus(MoPluginException.PluginErrorCode.Token_Expired.name());
                    apiAudit.setFailureReason(MoPluginException.PluginErrorCode.Token_Expired.getMessage());
                    return apiAudit;
                }
                if (this.settings.getEnableRateLimiting()) {
                    List<String> rateLimitStatus = this.checkRateLimitStatus(key.getWindowStart(), key.getWindowSize(), apiAudit);
                    switch (rateLimitStatus.get(0)) {
                        case "Error": {
                            updateUniKey = this.restPluginHandler.updateUniKey(key.getId(), null, null);
                            LOGGER.debug("Update Last Accessed Time for Universal Key : " + updateUniKey);
                            apiAudit.setStatus(MoPluginException.PluginErrorCode.RATE_LIMIT_EXCEEDED.name());
                            apiAudit.setFailureReason(MoPluginException.PluginErrorCode.RATE_LIMIT_EXCEEDED.getMessage());
                            return apiAudit;
                        }
                        case "Exception": {
                            LOGGER.debug("Unknown Exception Occurred " + rateLimitStatus.get(1));
                            apiAudit.setStatus(MoPluginException.PluginErrorCode.UNKNOWN.name());
                            apiAudit.setFailureReason(MoPluginException.PluginErrorCode.UNKNOWN.getMessage());
                            return apiAudit;
                        }
                    }
                    updateUniKey = this.restPluginHandler.updateUniKey(key.getId(), rateLimitStatus.get(0), rateLimitStatus.get(1));
                    LOGGER.debug("Update Last Accessed Time for Universal Key : " + updateUniKey);
                    continue;
                }
                updateUniKey = this.restPluginHandler.updateUniKey(key.getId(), null, null);
                LOGGER.debug("Update Last Accessed Time for Universal Key : " + updateUniKey);
            }
        }
        apiAudit.setStatus(MoPluginConstants.Status.SUCCESS.name());
        return apiAudit;
    }

    public List<String> checkRateLimitStatus(final String windowStart, String windowSize, APIAuditRecord apiAudit) {
        LOGGER.debug("Checking Rate Limiting");
        if (windowStart != null || windowSize != null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
                Date start = format.parse(String.valueOf(windowStart));
                Date current = new Date();
                long diff = current.getTime() - start.getTime();
                long diffSeconds = diff / 1000L;
                long maxdiff = Integer.valueOf(this.settings.getRateLimitingIntervalInSeconds()).intValue();
                if (diffSeconds < maxdiff) {
                    if (Integer.valueOf(windowSize) < Integer.valueOf(this.settings.getNumberOfRequest())) {
                        final Integer updatedWindowSize = Integer.valueOf(windowSize) + 1;
                        this.addRateLimitingHeaders(apiAudit, String.valueOf(Integer.valueOf(this.settings.getNumberOfRequest()) - updatedWindowSize), String.valueOf(maxdiff - diffSeconds));
                        return new ArrayList<String>(){
                            {
                                this.add(windowStart);
                                this.add(String.valueOf(updatedWindowSize));
                            }
                        };
                    }
                    LOGGER.debug("Error - 429 - Too Many Requests");
                    this.addRateLimitingHeaders(apiAudit, "0", String.valueOf(maxdiff - diffSeconds));
                    return new ArrayList<String>(){
                        {
                            this.add("Error");
                            this.add("429");
                        }
                    };
                }
                this.addRateLimitingHeaders(apiAudit, String.valueOf(Integer.valueOf(this.settings.getNumberOfRequest()) - 1), String.valueOf(maxdiff - 1L));
                return new ArrayList<String>(){
                    {
                        this.add(String.valueOf(new Date()));
                        this.add("1");
                    }
                };
            }
            catch (Exception e) {
                return new ArrayList<String>(){
                    {
                        this.add("Exception");
                        this.add(String.valueOf(e));
                    }
                };
            }
        }
        this.addRateLimitingHeaders(apiAudit, String.valueOf(Integer.valueOf(this.settings.getNumberOfRequest()) - 1), String.valueOf(Integer.valueOf(this.settings.getRateLimitingIntervalInSeconds()) - 1));
        return new ArrayList<String>(){
            {
                this.add(String.valueOf(new Date()));
                this.add("1");
            }
        };
    }

    public void addRateLimitingHeaders(APIAuditRecord apiAudit, String rateLimitRemaining, String rateLimitReset) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-RateLimit-Limit", this.settings.getNumberOfRequest());
        headers.put("X-RateLimit-Remaining", rateLimitRemaining);
        headers.put("X-RateLimit-Reset", rateLimitReset);
        apiAudit.setRateLimitingHeaders(headers);
    }
}

