/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.exceptions;

public class MoPluginException
extends RuntimeException {
    private PluginErrorCode errorCode;
    private String message;

    public MoPluginException(PluginErrorCode errorCode) {
        this.errorCode = errorCode;
        this.message = errorCode.getMessage();
    }

    public MoPluginException(PluginErrorCode errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    public MoPluginException(PluginErrorCode errorCode, String message, Throwable t) {
        super(t);
        this.errorCode = errorCode;
        this.message = message;
    }

    public PluginErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(PluginErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static enum PluginErrorCode {
        UNKNOWN("An unknown error occurred."),
        SAVING_DETAILS("An error occurred while saving details."),
        INVALID_TOKEN("Access token is invalid"),
        INCORRECT_USERNAME("Configured Username Attribute is not found in the provider response"),
        INCORRECT_FORMAT("Authrization Token is in incorrect format"),
        NO_API_KEY_CONFIGURED("No API Key is configured for this user"),
        USER_DOES_NOT_EXIST("This user does not exist"),
        INVALID_API_KEY("Provided API key is invalid"),
        Token_Expired("Token has Expired Please Generate a new one or Contact your Administrator"),
        PASSING_FOR_PAT("Passing PAT Tokens for authentication"),
        RATE_LIMIT_EXCEEDED("Rate limit exceeded. Please try again later.");

        private String message;

        private PluginErrorCode(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

