/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.dao;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.miniorange.license.MoLicenseDetails;
import com.miniorange.rest.auth.commons.MoAuditService;
import com.miniorange.rest.auth.commons.MoAuditTrackerService;
import com.miniorange.rest.auth.commons.dto.ApiKey;
import com.miniorange.rest.auth.commons.dto.AuditLog;
import com.miniorange.rest.auth.commons.entity.MoAuditTracker;
import com.miniorange.rest.auth.commons.handler.MoOfflineLicenseHandler;
import com.miniorange.rest.auth.commons.handler.UtilDecisionHandler;
import com.miniorange.rest.auth.commons.util.MoHashUtils;
import com.miniorange.rest.auth.commons.util.MoPluginConstants;
import com.miniorange.rest.auth.commons.util.PlatformUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoRESTAuthSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoRESTAuthSettings.class);
    private PluginSettingsFactory pluginSettingsFactory;
    private PluginSettings pluginSettings;
    private PluginLicenseManager pluginLicenseManager;
    private MoOfflineLicenseHandler moOfflineLicenseHandler;
    private LicenseHandler licenseHandler;
    private CrowdService crowdService;
    private MoAuditService auditService;
    private MoAuditTrackerService moAuditTrackerService;
    private final I18nResolver i18nResolver;

    public MoRESTAuthSettings(PluginSettingsFactory pluginSettingsFactory, PluginLicenseManager pluginLicenseManager, MoOfflineLicenseHandler moOfflineLicenseHandler, LicenseHandler licenseHandler, CrowdService crowdService, MoAuditService auditService, I18nResolver i18nResolver, MoAuditTrackerService moAuditTrackerService) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.pluginLicenseManager = pluginLicenseManager;
        this.moOfflineLicenseHandler = moOfflineLicenseHandler;
        this.licenseHandler = licenseHandler;
        this.crowdService = crowdService;
        this.auditService = auditService;
        this.i18nResolver = i18nResolver;
        this.moAuditTrackerService = moAuditTrackerService;
    }

    public boolean isDatacenter() {
        Collection allProductLicenses = this.licenseHandler.getAllProductLicenses();
        LOGGER.debug("\n\nis Datacenter :- ");
        Iterator iterator = allProductLicenses.iterator();
        if (iterator.hasNext()) {
            MultiProductLicenseDetails productLicenseDetails = (MultiProductLicenseDetails)iterator.next();
            LOGGER.debug("\nprod" + productLicenseDetails.toString() + "\n\n");
            return productLicenseDetails.isDataCenter();
        }
        return true;
    }

    public int getMaxUsers() {
        if (this.isOfflineLicenseValid().booleanValue()) {
            return 1;
        }
        int t = 0;
        try {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                t = (Integer)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getEdition().get();
            }
        }
        catch (Exception e) {
            return -1;
        }
        return t;
    }

    public boolean isLicenseDefined() {
        try {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                return true;
            }
            if (!this.isDatacenter()) {
                if (this.moOfflineLicenseHandler.offlineLicenseDetails() != null) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean isOfflineLicenseExpired() {
        MoLicenseDetails moLicenseDetails = this.moOfflineLicenseHandler.offlineLicenseDetails();
        String licenseExpiryDate = moLicenseDetails.getExpiryDate();
        if (this.moOfflineLicenseHandler.getDaysLeftToExpire(licenseExpiryDate) < 0) {
            LOGGER.error("License has expired");
            return true;
        }
        return false;
    }

    public Boolean isLicenseValid() {
        LOGGER.debug(" in license validation ");
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            if (!((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid() || ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined()) {
                LOGGER.error("Invalid License");
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (!this.isDatacenter()) {
            if (this.isOfflineLicenseValid().booleanValue()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        LOGGER.debug("License is not defined");
        return Boolean.FALSE;
    }

    public Boolean isOfflineLicenseValid() {
        MoLicenseDetails moLicenseDetails = this.moOfflineLicenseHandler.offlineLicenseDetails();
        if (moLicenseDetails == null) {
            this.moOfflineLicenseHandler.setIsValidLicenseFileConfigured(false);
            LOGGER.error("Unable to fetch License Details Object");
            return false;
        }
        String licenseExpiryDate = moLicenseDetails.getExpiryDate();
        if (this.moOfflineLicenseHandler.getDaysLeftToExpire(licenseExpiryDate) < 0) {
            LOGGER.error("License has expired");
            return false;
        }
        return true;
    }

    public String getPublicKey() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.PUBLIC_KEY.getKey()), "");
    }

    public void setPublicKey(String publicKey) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.PUBLIC_KEY.getKey(), (Object)StringUtils.trimToEmpty(StringUtils.defaultIfBlank(publicKey, "")));
    }

    public String getOAuthProvider() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.OAUTH_PROVIDER.getKey()), "");
    }

    public void setOAuthProvider(String oAuthProvider) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.OAUTH_PROVIDER.getKey(), (Object)StringUtils.defaultIfBlank(oAuthProvider, ""));
    }

    public void setPublicApiUrls(String publicApiUrl) {
        Map<Object, Object> apiUrls = new HashMap();
        if (this.getPublicApiUrls() != null) {
            apiUrls = this.getPublicApiUrls();
        }
        String ID = UUID.randomUUID().toString();
        if (!apiUrls.containsValue(publicApiUrl)) {
            apiUrls.put(ID, publicApiUrl);
        }
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.PUBLIC_APIS.getKey(), apiUrls);
    }

    public List<String> getPublicApiUrlsAsList() {
        Map<String, String> apiUrls = this.getPublicApiUrls();
        ArrayList<String> apiUrlsList = new ArrayList<String>();
        if (apiUrls != null) {
            for (Map.Entry<String, String> entry : apiUrls.entrySet()) {
                apiUrlsList.add(entry.getValue());
            }
        }
        return apiUrlsList;
    }

    public List<String> getByPassApiUrlsAsList() {
        Map<String, String> bypassUrls = this.getBypassApiUrls();
        ArrayList<String> bypassUrlsList = new ArrayList<String>();
        if (bypassUrls != null) {
            for (Map.Entry<String, String> entry : bypassUrls.entrySet()) {
                bypassUrlsList.add(entry.getValue());
            }
        }
        return bypassUrlsList;
    }

    public Map<String, String> getPublicApiUrls() {
        Map apiUrls = (Map)this.pluginSettings.get(MoPluginConstants.SettingsConstants.PUBLIC_APIS.getKey());
        return apiUrls;
    }

    public void setByPassApiUrl(String byPassApiUrl) {
        Map<Object, Object> bypassapiurls = new HashMap();
        if (this.getBypassApiUrls() != null) {
            bypassapiurls = this.getBypassApiUrls();
        }
        String id = UUID.randomUUID().toString();
        if (!bypassapiurls.containsValue(byPassApiUrl)) {
            bypassapiurls.put(id, byPassApiUrl);
        }
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.BYPASS_APIS.getKey(), bypassapiurls);
    }

    public Map<String, String> getBypassApiUrls() {
        Map bypassUrls = (Map)this.pluginSettings.get(MoPluginConstants.SettingsConstants.BYPASS_APIS.getKey());
        return bypassUrls;
    }

    public void deleteApiUrl(String apiUrl) {
        Map<String, String> apiUrls = this.getPublicApiUrls();
        String key = "";
        for (Map.Entry<String, String> entry : apiUrls.entrySet()) {
            if (!apiUrl.equals(entry.getValue())) continue;
            key = entry.getKey();
        }
        if (key.isEmpty()) {
            LOGGER.debug("no such value found");
            return;
        }
        apiUrls.remove(key);
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.PUBLIC_APIS.getKey(), apiUrls);
    }

    public void deleteByPassUrl(String bypassUrl) {
        Map<String, String> bypassUrls = this.getBypassApiUrls();
        String key = "";
        for (Map.Entry<String, String> entry : bypassUrls.entrySet()) {
            if (!bypassUrl.equals(entry.getValue())) continue;
            key = entry.getKey();
        }
        if (key.isEmpty()) {
            LOGGER.debug("no such value found");
            return;
        }
        bypassUrls.remove(key);
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.BYPASS_APIS.getKey(), bypassUrls);
    }

    public String getOfflineLicenseKey() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.MO_OFFLINE_LICENSE_KEY.getKey()), "");
    }

    public void setOfflineLicenseKey(String licenseKey) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.MO_OFFLINE_LICENSE_KEY.getKey(), (Object)StringUtils.defaultIfBlank(licenseKey, ""));
    }

    public Boolean getDisableLicenseExpiringWarning() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBoolean((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.DISABLE_LICENSE_EXPIRING_WARNING.getKey())), false);
    }

    public void setDisableLicenseExpiringWarning(Boolean disableLicenseExpiringWaring) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.DISABLE_LICENSE_EXPIRING_WARNING.getKey(), (Object)BooleanUtils.toString(disableLicenseExpiringWaring, "true", "false", "false"));
    }

    public Boolean getDisableLicenseExpiredWarning() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBoolean((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.DISABLE_LICENSE_EXPIRED_WARNING.getKey())), false);
    }

    public void setDisableLicenseExpiredWarning(Boolean disableLicenseExpiredWarning) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.DISABLE_LICENSE_EXPIRED_WARNING.getKey(), (Object)BooleanUtils.toString(disableLicenseExpiredWarning, "true", "false", "false"));
    }

    public void setKeycloakHost(String keycloakHost) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.KEYCLOAK_HOST.getKey(), (Object)StringUtils.defaultIfBlank(keycloakHost, ""));
    }

    public void setDisablePopUp(Boolean disablePopUp) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.DISABLE_POPUP.getKey(), (Object)BooleanUtils.toString(disablePopUp, "true", "false", "false"));
    }

    public Boolean getDisablePopUp() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBoolean((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.DISABLE_POPUP.getKey())), false);
    }

    public String getKeycloakHost() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.KEYCLOAK_HOST.getKey()), "");
    }

    public void setKeycloakRealm(String keycloakRealm) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.KEYCLOAK_REALM.getKey(), (Object)StringUtils.defaultIfBlank(keycloakRealm, ""));
    }

    public String getKeycloakRealm() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.KEYCLOAK_REALM.getKey()), "");
    }

    public void setSalesforceDomain(String salesforceDomain) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.SALESFORCE_DOMAIN.getKey(), (Object)StringUtils.defaultIfBlank(salesforceDomain, ""));
    }

    public String getSalesforceDomain() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.SALESFORCE_DOMAIN.getKey()), "");
    }

    public void setAwsCognitoDomainNam(String domainName) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.AWS_COGNITO_DOMAIN_NAME.getKey(), (Object)StringUtils.trimToEmpty(StringUtils.defaultIfBlank(domainName, "")));
    }

    public void setOktaDomainNam(String domainName) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.OKTA_DOMAIN_NAME.getKey(), (Object)StringUtils.trimToEmpty(StringUtils.defaultIfBlank(domainName, "")));
    }

    public void setAzureADTenantID(String azureAdTenantID) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.AZURE_TENANT_ID.getKey(), (Object)StringUtils.trimToEmpty(azureAdTenantID));
    }

    public void setAuthUrlForOAuthToken(String url) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.AUTH_URL.getKey(), (Object)StringUtils.defaultIfBlank(url, ""));
    }

    public String getAuthUrlForOAuthToken() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.AUTH_URL.getKey()), "");
    }

    public void setTokenUrlForOAuthToken(String url) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.TOKEN_URL.getKey(), (Object)StringUtils.defaultIfBlank(url, ""));
    }

    public String getTokenUrlForOAuthToken() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.TOKEN_URL.getKey()), "");
    }

    public String getAzureADTenantID() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.AZURE_TENANT_ID.getKey()), "");
    }

    public String getAwsCognitoDomainName() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.AWS_COGNITO_DOMAIN_NAME.getKey()), "");
    }

    public String getOktaDomainName() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.OKTA_DOMAIN_NAME.getKey()), "");
    }

    public void setEnableAuthentication(Boolean enableAuthentication) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.ENABLE_AUTHENTICATION.getKey(), (Object)BooleanUtils.toString(enableAuthentication, "true", "false", "true"));
    }

    public String getBaseUrl() {
        String platform = this.i18nResolver.getText("my.plugin.platform");
        PlatformUtils platformUtils = UtilDecisionHandler.getPlatFormUtils(platform);
        return platformUtils.getBaseUrl();
    }

    public Boolean getEnableAuthentication() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBooleanObject((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.ENABLE_AUTHENTICATION.getKey())), Boolean.TRUE);
    }

    public void setDisableBasicAuthentication(Boolean disableBasicAuthentication) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.DISABLE_BASIC_AUTHENTICATION.getKey(), (Object)BooleanUtils.toString(disableBasicAuthentication, "true", "false", "false"));
    }

    public Boolean getDisableBasicAuthentication() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBoolean((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.DISABLE_BASIC_AUTHENTICATION.getKey())), Boolean.FALSE);
    }

    public void setAllowPATTokens(Boolean allowPATTokens) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.ALLOW_PAT_TOKENS.getKey(), (Object)BooleanUtils.toString(allowPATTokens, "true", "false", "false"));
    }

    public Boolean getAllowPATTokens() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBoolean((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.ALLOW_PAT_TOKENS.getKey())), Boolean.FALSE);
    }

    public List<String> getAuditLogsList() {
        Object auditLogsList = this.pluginSettings.get(MoPluginConstants.SettingsConstants.AUDIT_LOGS.getKey());
        if (auditLogsList != null) {
            return (List)auditLogsList;
        }
        return new ArrayList<String>();
    }

    public List<AuditLog> getAuditLogsListAfterMigration() throws ParseException {
        ArrayList<AuditLog> auditLogs = new ArrayList<AuditLog>();
        List<MoAuditTracker> auditLogsList = this.moAuditTrackerService.all();
        try {
            for (MoAuditTracker auditLogs1 : auditLogsList) {
                AuditLog auditLog = new AuditLog();
                auditLog.setUsername(auditLogs1.getUserName());
                auditLog.setRequestType(auditLogs1.getRequestType());
                auditLog.setApiUrl(auditLogs1.getRequestUrl());
                auditLog.setStatus(auditLogs1.getStatus());
                auditLog.setIpAddress(auditLogs1.getIpAddress());
                auditLog.setDate(auditLogs1.getDateAndTime());
                auditLogs.add(auditLog);
            }
        }
        catch (Exception e) {
            LOGGER.error("An Exception occurred while fetching the Audit Logs from the db" + e.getMessage());
        }
        return auditLogs;
    }

    public List<AuditLog> getPaginatedAuditLogs(Date date, Integer offset, Integer pageLimitForAuditLogs) throws Exception {
        ArrayList<AuditLog> auditLogs = new ArrayList<AuditLog>();
        List<MoAuditTracker> auditLogsList = this.moAuditTrackerService.getPaginatedLogs(date, offset, pageLimitForAuditLogs);
        try {
            for (MoAuditTracker auditEntry : auditLogsList) {
                AuditLog auditLog = new AuditLog();
                auditLog.setUsername(auditEntry.getUserName());
                auditLog.setRequestType(auditEntry.getRequestType());
                auditLog.setApiUrl(auditEntry.getRequestUrl());
                auditLog.setStatus(auditEntry.getStatus());
                auditLog.setIpAddress(auditEntry.getIpAddress());
                auditLog.setDate(auditEntry.getDateAndTime());
                auditLogs.add(auditLog);
            }
            return auditLogs;
        }
        catch (Exception e) {
            LOGGER.error("An Exception occurred while fetching the Audit Logs" + e.getMessage());
            return auditLogs;
        }
    }

    public void setAuditLogsList(List<String> auditLogsList) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.AUDIT_LOGS.getKey(), auditLogsList);
    }

    public void setIntrospectionEndpoint(String introspectionEndpoint) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.INTROSPECTION_ENDPOINT.getKey(), (Object)StringUtils.defaultIfBlank(introspectionEndpoint, ""));
    }

    public String getIntrospectionEndpoint() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.INTROSPECTION_ENDPOINT.getKey()), "");
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.USERNAME_ATTRIBUTE.getKey(), (Object)StringUtils.defaultIfBlank(usernameAttribute, ""));
    }

    public String getUsernameAttribute() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.USERNAME_ATTRIBUTE.getKey()), "");
    }

    public void setClientCredProviderName(String clientCredProviderName) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.CLIENT_CRED_PROVIDER_NAME.getKey(), (Object)StringUtils.defaultIfBlank(clientCredProviderName, ""));
    }

    public String getClientCredProviderName() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.CLIENT_CRED_PROVIDER_NAME.getKey()), "");
    }

    public void setClientCredIntrospectionEndpoint(String clientCredIntrospectionEndpoint) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.CLIENT_CRED_INTROSPECTION_ENDPOINT.getKey(), (Object)StringUtils.defaultIfBlank(clientCredIntrospectionEndpoint, ""));
    }

    public String getClientCredIntrospectionEndpoint() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.CLIENT_CRED_INTROSPECTION_ENDPOINT.getKey()), "");
    }

    public void setClientCredRedirectUri(String clientCredRedirectUri) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.CLIENT_CRED_REDIRECT_URI.getKey(), (Object)StringUtils.defaultIfBlank(clientCredRedirectUri, ""));
    }

    public String getClientCredRedirectUri() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.CLIENT_CRED_REDIRECT_URI.getKey()), "");
    }

    public void setClientCredClientId(String clientCredClientId) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.CLIENT_CRED_CLIENT_ID.getKey(), (Object)StringUtils.defaultIfBlank(clientCredClientId, ""));
    }

    public String getClientCredClientId() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.CLIENT_CRED_CLIENT_ID.getKey()), "");
    }

    public void setClientCredClientSecret(String clientCredClientSecret) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.CLIENT_CRED_CLIENT_SECRET.getKey(), (Object)StringUtils.defaultIfBlank(clientCredClientSecret, ""));
    }

    public String getClientCredClientSecret() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.CLIENT_CRED_CLIENT_SECRET.getKey()), "");
    }

    public void setServiceAccountUsername(String serviceAccountUsername) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.CLIENT_CRED_SERVICE_ACC_USERNAME.getKey(), (Object)StringUtils.defaultIfBlank(serviceAccountUsername, ""));
    }

    public String getServiceAccountUsername() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.CLIENT_CRED_SERVICE_ACC_USERNAME.getKey()), "");
    }

    public void setClientCredScope(String scope) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.CLIENT_CRED_SCOPE.getKey(), (Object)StringUtils.defaultIfBlank(scope, ""));
    }

    public String getClientCredScope() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.CLIENT_CRED_SCOPE.getKey()), "");
    }

    public void setJwtProviderName(String providerName) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.JWT_PROVIDER_NAME.getKey(), (Object)StringUtils.defaultIfBlank(providerName, ""));
    }

    public String getJwtProviderName() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.JWT_PROVIDER_NAME.getKey()), "");
    }

    public void setJwtIntrospectionEndpoint(String introspectionEndpoint) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.JWT_INTROSPECTION_ENDPOINT.getKey(), (Object)StringUtils.defaultIfBlank(introspectionEndpoint, ""));
    }

    public String getJwtIntrospectionEndpoint() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.JWT_INTROSPECTION_ENDPOINT.getKey()), "");
    }

    public void setJwtClientId(String clientId) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.JWT_CLIENT_ID.getKey(), (Object)StringUtils.defaultIfBlank(clientId, ""));
    }

    public String getJwtClientId() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.JWT_CLIENT_ID.getKey()), "");
    }

    public void setJwtPublicKey(String publicKey) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.JWT_PUBLIC_KEY.getKey(), (Object)StringUtils.defaultIfBlank(publicKey, ""));
    }

    public String getJwtPublicKey() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.JWT_PUBLIC_KEY.getKey()), "");
    }

    public void setJwtUsername(String username) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.JWT_USERNAME.getKey(), (Object)StringUtils.defaultIfBlank(username, ""));
    }

    public String getJwtUsername() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.JWT_USERNAME.getKey()), "");
    }

    public void setOauthTokenType(String type) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.OAUTH_TOKEN_TYPE.getKey(), (Object)StringUtils.defaultIfBlank(type, ""));
    }

    public String getOauthTokenType() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.OAUTH_TOKEN_TYPE.getKey()), "");
    }

    public void setPastDaysConfigured(Integer pastDaysConfigured) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.PAST_DAYS_CONFIGURED.getKey(), (Object)StringUtils.defaultIfBlank(pastDaysConfigured.toString(), ""));
    }

    public String getPastDaysConfigured() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.PAST_DAYS_CONFIGURED.getKey()), "5");
    }

    public void setNumberOfEntries(Integer numberOfEntries) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.NO_OF_ENTRIES_IN_AUDIT_LOGS.getKey(), (Object)StringUtils.defaultIfBlank(numberOfEntries.toString(), ""));
    }

    public String getNumberOfEntries() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.NO_OF_ENTRIES_IN_AUDIT_LOGS.getKey()), "10000");
    }

    public String getClientId() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.CLIENT_ID.getKey()), "");
    }

    public String getClientSecret() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.CLIENT_SECRET.getKey()), "");
    }

    public String getScope() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.SCOPE.getKey()), "");
    }

    public String getState() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.STATE.getKey()), "");
    }

    public void setClientId(String clientId) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.CLIENT_ID.getKey(), (Object)StringUtils.defaultIfBlank(clientId, ""));
    }

    public void setClientSecret(String setClientSecret) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.CLIENT_SECRET.getKey(), (Object)StringUtils.defaultIfBlank(setClientSecret, ""));
    }

    public void setScope(String scope) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.SCOPE.getKey(), (Object)StringUtils.defaultIfBlank(scope, ""));
    }

    public void setState(String state) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.STATE.getKey(), (Object)StringUtils.defaultIfBlank(state, ""));
    }

    public void setApiKey(ApiKey apiKey) {
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
        String apiKeyJson = gson.toJson((Object)apiKey);
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.API_KEY.getKey().concat(apiKey.getId()), (Object)apiKeyJson);
    }

    public ApiKey getApiKey(String key) {
        String apiKeyJson = (String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.API_KEY.getKey().concat(key));
        if (StringUtils.isBlank(apiKeyJson)) {
            return null;
        }
        try {
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
            return (ApiKey)gson.fromJson(apiKeyJson, ApiKey.class);
        }
        catch (Exception e) {
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd").create();
            return (ApiKey)gson.fromJson(apiKeyJson, ApiKey.class);
        }
    }

    public void setApiKeys(Map<String, String> apiKeys, String username) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.API_KEYS.getKey().concat(username), apiKeys);
    }

    public Map<String, String> getApiKeys(String username) {
        Map apiKeys = (Map)this.pluginSettings.get(MoPluginConstants.SettingsConstants.API_KEYS.getKey().concat(username));
        return apiKeys != null ? apiKeys : new HashMap();
    }

    public String getGroup() {
        String group = StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.GROUP.getKey()), "");
        if (StringUtils.isBlank(group) || StringUtils.isEmpty(group)) {
            group = this.getDefaultGroupForInitialConfiguration();
            this.setGroup(group);
        }
        return group;
    }

    public void setGroup(String group) {
        if (group == null) {
            group = this.getDefaultGroupForInitialConfiguration();
        }
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.GROUP.getKey(), (Object)StringUtils.trimToEmpty(group));
    }

    public String getDefaultGroupForInitialConfiguration() {
        String defaultGroup;
        try {
            SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
            defaultGroup = settingsManager.getGlobalSettings().getDefaultUsersGroup();
        }
        catch (Exception E) {
            return "jira-software-users";
        }
        return defaultGroup;
    }

    public Object getGroups() {
        LOGGER.debug("Settings to fetch Groups Called..");
        if (this.pluginSettings.get(MoPluginConstants.SettingsConstants.GROUPS.getKey()) == null) {
            ArrayList<String> defaultGroups = new ArrayList<String>();
            defaultGroups.add(this.getDefaultGroupForInitialConfiguration());
            return defaultGroups;
        }
        return this.pluginSettings.get(MoPluginConstants.SettingsConstants.GROUPS.getKey());
    }

    public Object getReadOnlyGroups() {
        return this.pluginSettings.get(MoPluginConstants.SettingsConstants.READ_ONLY_GROUPS.getKey());
    }

    public void setReadOnlyGroups(List<String> readOnlyGroups) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.READ_ONLY_GROUPS.getKey(), readOnlyGroups);
    }

    public Boolean getReadOnlyGroupsEnabled() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBoolean((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.ENABLE_READ_ONLY_GROUPS.getKey())), Boolean.FALSE);
    }

    public void setReadOnlyGroupsEnabled(Boolean readOnlyGroupsEnabled) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.ENABLE_READ_ONLY_GROUPS.getKey(), (Object)BooleanUtils.toString(readOnlyGroupsEnabled, "true", "false", "false"));
    }

    public void setGroups(List<String> groups) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.GROUPS.getKey(), groups);
    }

    public List<String> convertSelect2StringToList(String groups) {
        ArrayList<String> groupsList = new ArrayList<String>();
        if (StringUtils.isBlank(groups)) {
            return groupsList;
        }
        LOGGER.debug("multiple groups -" + groups);
        Collections.addAll(groupsList, StringUtils.split(groups, ","));
        groupsList.removeAll(Arrays.asList(null, ""));
        return groupsList;
    }

    public void setRestrictGroupEnabled(Boolean restrictGroupEnabled) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.RESTRICT_GROUP_ENABLED.getKey(), (Object)BooleanUtils.toString(restrictGroupEnabled, "true", "false", "false"));
    }

    public Boolean getRestrictGroupEnabled() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBoolean((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.RESTRICT_GROUP_ENABLED.getKey())), Boolean.FALSE);
    }

    public void setRestrictTokenGenerationGroupEnabled(Boolean restrictGroupEnabled) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.RESTRICT_TOKEN_GENERATION_GROUP_ENABLED.getKey(), (Object)BooleanUtils.toString(restrictGroupEnabled, "true", "false", "false"));
    }

    public Boolean getRestrictTokenGenerationGroupEnabled() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBoolean((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.RESTRICT_TOKEN_GENERATION_GROUP_ENABLED.getKey())), Boolean.FALSE);
    }

    public void setRestrictTokenGenerationGroups(List<String> restrictTokenGenerationGroupsList) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.RESTRICT_TOKEN_GENERATION_GROUPS.getKey(), restrictTokenGenerationGroupsList);
    }

    public Object getRestrictTokenGenerationGroups() {
        if (this.pluginSettings.get(MoPluginConstants.SettingsConstants.RESTRICT_TOKEN_GENERATION_GROUPS.getKey()) == null) {
            return new ArrayList();
        }
        return this.pluginSettings.get(MoPluginConstants.SettingsConstants.RESTRICT_TOKEN_GENERATION_GROUPS.getKey());
    }

    public byte[] getSalt(String username) {
        String userSalt;
        HashMap<String, String> saltMap = (HashMap<String, String>)this.pluginSettings.get(MoPluginConstants.SettingsConstants.SALT_MAP.getKey());
        if (saltMap == null) {
            LOGGER.debug("Could not find salt map in the database");
            saltMap = new HashMap<String, String>();
        }
        if (StringUtils.isNotBlank(userSalt = (String)saltMap.get(username))) {
            return userSalt.getBytes();
        }
        LOGGER.debug("creating new salt for the user {}", (Object)username);
        String newSalt = MoHashUtils.createSalt();
        saltMap.put(username, newSalt);
        this.setSalt(saltMap);
        return newSalt.getBytes();
    }

    private void setSalt(Map<String, String> saltMap) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.SALT_MAP.getKey(), saltMap);
    }

    private void resetSettings() {
        Map saltMap = (Map)this.pluginSettings.get(MoPluginConstants.SettingsConstants.SALT_MAP.getKey());
        for (String username : saltMap.keySet()) {
            Map<String, String> apiKeys = this.getApiKeys(username);
            for (String id : apiKeys.keySet()) {
                this.pluginSettings.remove(MoPluginConstants.SettingsConstants.API_KEY.getKey().concat(id));
            }
            this.pluginSettings.remove(MoPluginConstants.SettingsConstants.API_KEYS.getKey().concat(username));
        }
        for (MoPluginConstants.SettingsConstants setttings : MoPluginConstants.SettingsConstants.values()) {
            this.pluginSettings.remove(setttings.getKey());
        }
    }

    public void deleteApiKey(String id) {
        this.pluginSettings.remove(MoPluginConstants.SettingsConstants.API_KEY.getKey().concat(id));
    }

    public void setMaxExpiryTime(boolean setMaxExpiryTime) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.SET_MAX_EXPIRY_TIME.getKey(), (Object)BooleanUtils.toString(setMaxExpiryTime, "true", "false", "false"));
    }

    public boolean getMaxExpiryTime() {
        return BooleanUtils.toBoolean((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.SET_MAX_EXPIRY_TIME.getKey()));
    }

    public void setMaximumExpiryCount(String maximumExpiryCount) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.MAXIMUM_EXPIRY_COUNT.getKey(), (Object)maximumExpiryCount);
    }

    public String getMaximumExpiryCount() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.MAXIMUM_EXPIRY_COUNT.getKey()), "1");
    }

    public void setMaximumExpiryInterval(String maximumExpiryInterval) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.MAXIMUM_EXPIRY_INTERVAL.getKey(), (Object)maximumExpiryInterval);
    }

    public String getMaximumExpiryInterval() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.MAXIMUM_EXPIRY_INTERVAL.getKey()), "2");
    }

    public void setMaxToken(boolean setMaxToken) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.SET_MAX_TOKENS.getKey(), (Object)BooleanUtils.toString(setMaxToken, "true", "false", "false"));
    }

    public boolean getMaxToken() {
        return BooleanUtils.toBoolean((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.SET_MAX_TOKENS.getKey()));
    }

    public void setMaximumTokenCount(String maximumTokenCount) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.MAXIMUM_TOKEN_COUNT.getKey(), (Object)maximumTokenCount);
    }

    public String getMaximumTokenCount() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.MAXIMUM_TOKEN_COUNT.getKey()), "1");
    }

    public void setRestrictIPEnabled(Boolean restrictIPEnabled) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.RESTRICT_IP_ENABLED.getKey(), (Object)BooleanUtils.toString(restrictIPEnabled, "true", "false", "false"));
    }

    public boolean getRestrictIPEnabled() {
        return BooleanUtils.toBoolean((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.RESTRICT_IP_ENABLED.getKey()));
    }

    public void setRestrictedIP(List<String> ipRestriction) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.IP_RESTRICTION.getKey(), ipRestriction);
    }

    public void setEnableBasicAuth(Boolean enableBasicAuth) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.ENABLE_BASIC_AUTH.getKey(), (Object)BooleanUtils.toString(enableBasicAuth, "true", "false", "false"));
    }

    public Boolean getAllowUsersToCreateTokens() {
        Object allowUsersToCreateTokens = this.pluginSettings.get(MoPluginConstants.SettingsConstants.ALLOW_USERS_TO_CREATE_TOKENS.getKey());
        if (allowUsersToCreateTokens == null) {
            return true;
        }
        return BooleanUtils.toBoolean(allowUsersToCreateTokens.toString());
    }

    public void setAllowUsersToCreateTokens(Boolean allowUsersToCreateTokens) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.ALLOW_USERS_TO_CREATE_TOKENS.getKey(), (Object)BooleanUtils.toString(allowUsersToCreateTokens, "true", "false", "false"));
    }

    public List<String> getRestrictedIP() {
        Object ip = this.pluginSettings.get(MoPluginConstants.SettingsConstants.IP_RESTRICTION.getKey());
        if (ip != null) {
            return (List)ip;
        }
        return new ArrayList<String>();
    }

    public Boolean getEnableDebugLogs() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBooleanObject((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.ENABLE_DEBUG_LOGS.getKey())), false);
    }

    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.ENABLE_DEBUG_LOGS.getKey(), (Object)BooleanUtils.toString(enableDebugLogs, "true", "false", "false"));
    }

    public void setEnableAuditLogs(Boolean enableAuditLogs) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.ENABLE_AUDIT_LOGS.getKey(), (Object)BooleanUtils.toString(enableAuditLogs, "true", "false", "false"));
    }

    public Boolean getEnableAuditLogs() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBooleanObject((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.ENABLE_AUDIT_LOGS.getKey())), false);
    }

    public void setHideSensitiveInformation(Boolean hideSensitiveInformation) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.ENABLE_HIDE_SENSITIVE_INFORMATION.getKey(), (Object)BooleanUtils.toString(hideSensitiveInformation, "true", "false", "false"));
    }

    public Boolean getHideSensitiveInformation() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBooleanObject((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.ENABLE_HIDE_SENSITIVE_INFORMATION.getKey())), false);
    }

    public void setMigration(Boolean isMigrationHandled) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.RESTAPI_PLUGIN_SETTINGS_MIGRATED.getKey(), (Object)BooleanUtils.toString(isMigrationHandled, "true", "false", "false"));
    }

    public Boolean isMigrationHandled() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBooleanObject((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.RESTAPI_PLUGIN_SETTINGS_MIGRATED.getKey())), false);
    }

    public void setPluginSettingsMigrationAuditLogs(Boolean pluginSettings) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.AUDIT_LOGS_PLUGIN_SETTINGS_MIGRATION.getKey(), (Object)BooleanUtils.toString(pluginSettings, "true", "false", "false"));
    }

    public Boolean getPluginSettingsAuditLogs() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBooleanObject((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.AUDIT_LOGS_PLUGIN_SETTINGS_MIGRATION.getKey())), false);
    }

    public Boolean isAuditLogsMigrationHandled() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBooleanObject((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.AUDIT_LOGS_HANDLER.getKey())), false);
    }

    public void setAuditLogsMigrationHandling(Boolean result) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.AUDIT_LOGS_HANDLER.getKey(), (Object)BooleanUtils.toString(result, "true", "false", "false"));
    }

    public Boolean isOAuthConfigMigrationHandled() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBooleanObject((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.OAUTH_CONFIG_MIGRATION_HANDLED.getKey())), false);
    }

    public void setOAuthConfigMigrationHandling(Boolean result) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.OAUTH_CONFIG_MIGRATION_HANDLED.getKey(), (Object)BooleanUtils.toString(result, "true", "false", "false"));
    }

    public Boolean viewPastAuditLogs() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBooleanObject((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.VIEW_PAST_AUDIT_LOGS.getKey())), false);
    }

    public void setViewPastAuditLogs(Boolean value) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.VIEW_PAST_AUDIT_LOGS.getKey(), (Object)BooleanUtils.toString(value, "true", "false", "false"));
    }

    public void setSchedulerStatus(Boolean value) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.SCHEDULER_STATUS.getKey(), (Object)BooleanUtils.toString(value, "true", "false", "false"));
    }

    public Boolean getSchedulerStatus() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBooleanObject((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.SCHEDULER_STATUS.getKey())), false);
    }

    public String getService_acc() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.SERVICE_ACCOUNT_USERNAME.getKey()), "");
    }

    public void setService_acc(String service_acc) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.SERVICE_ACCOUNT_USERNAME.getKey(), (Object)StringUtils.defaultIfBlank(service_acc, ""));
    }

    public void setEnableRateLimitng(boolean enableRateLimiting) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.ENABLE_RATE_LIMITING.getKey(), (Object)BooleanUtils.toString(enableRateLimiting, "true", "false", "false"));
    }

    public boolean getEnableRateLimiting() {
        return BooleanUtils.toBoolean((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.ENABLE_RATE_LIMITING.getKey()));
    }

    public void setNumberOfRequest(String maximumExpiryCount) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.NUMBER_OF_REQUEST.getKey(), (Object)maximumExpiryCount);
    }

    public String getNumberOfRequest() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.NUMBER_OF_REQUEST.getKey()), "1");
    }

    public void setRateLimitingIntervalCount(String intervalCount) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.RATE_LIMITING_INTERVAL_COUNT.getKey(), (Object)intervalCount);
    }

    public String getRateLimitingIntervalCount() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.RATE_LIMITING_INTERVAL_COUNT.getKey()), "1");
    }

    public void setRateLimitingInterval(String interval) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.RATE_LIMITING_INTERVAL.getKey(), (Object)interval);
    }

    public String getRateLimitingInterval() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.RATE_LIMITING_INTERVAL.getKey()), "1");
    }

    public void setRateLimitingIntervalInSeconds(String interval) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.RATE_LIMITING_INTERVAL_IN_SECONDS.getKey(), (Object)interval);
    }

    public String getRateLimitingIntervalInSeconds() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.RATE_LIMITING_INTERVAL_IN_SECONDS.getKey()), "60");
    }
}

