/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.miniorange.rest.auth.commons.MoAuditTrackerService;
import com.miniorange.rest.auth.commons.entity.MoAuditTracker;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoAuditTrackerServiceImpl
implements MoAuditTrackerService {
    private ActiveObjects ao;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAuditTrackerServiceImpl.class);
    private MoRESTPluginHandler moRESTPluginHandler;

    public MoAuditTrackerServiceImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public void addAuditEntries(String name, String ipAddress, String requestType, String requestUrl, Date date, String status) {
        MoAuditTracker moAuditTracker = (MoAuditTracker)this.ao.create(MoAuditTracker.class, new DBParam[0]);
        moAuditTracker.setUserName(name);
        moAuditTracker.setIpAddress(ipAddress);
        moAuditTracker.setRequestType(requestType);
        moAuditTracker.setRequestUrl(requestUrl);
        moAuditTracker.setDateAndTime(date);
        moAuditTracker.setStatus(status);
        moAuditTracker.save();
    }

    @Override
    public void deleteExcessAuditLogs(final Integer pastDays, final Integer numberOfEntries) {
        int count = 0;
        boolean isInitialized = false;
        while (!isInitialized && count < 10) {
            try {
                this.ao.moduleMetaData().awaitInitialization(1L, TimeUnit.MINUTES);
                isInitialized = this.ao.moduleMetaData().isInitialized();
            }
            catch (InterruptedException | ExecutionException | TimeoutException exp) {
                ++count;
            }
        }
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                int size = MoAuditTrackerServiceImpl.this.getAuditEntriesCountPastDays(pastDays);
                LOGGER.debug("Audit entries count past " + pastDays + " days are " + size);
                if (size <= 10000 && size != 0) {
                    LOGGER.debug("Audit Logs Entries count past " + pastDays + "days are less than 10000");
                    MoAuditTrackerServiceImpl.this.deleteLogs(size, pastDays);
                } else {
                    while (size > 0) {
                        int entryDiff;
                        LOGGER.debug("Audit logs entries are greater than 10000,hence executing logs deletion in batches");
                        int n = entryDiff = size > 10000 ? size - 10000 : size;
                        if (entryDiff >= 15000) {
                            MoAuditTrackerServiceImpl.this.deleteLogs(15000, pastDays);
                            size -= 15000;
                            continue;
                        }
                        MoAuditTrackerServiceImpl.this.deleteLogs(entryDiff, pastDays);
                        size -= entryDiff;
                    }
                }
                int auditEntryCountAfterSchedulerExecution = MoAuditTrackerServiceImpl.this.all().size();
                while (auditEntryCountAfterSchedulerExecution > numberOfEntries) {
                    LOGGER.debug("Audit Logs Entries after Scheduler operation are greater than " + numberOfEntries);
                    int entriesDiff = auditEntryCountAfterSchedulerExecution - numberOfEntries;
                    if (entriesDiff >= 15000) {
                        MoAuditTrackerServiceImpl.this.clearAuditLogs(15000);
                        auditEntryCountAfterSchedulerExecution -= 15000;
                        continue;
                    }
                    MoAuditTrackerServiceImpl.this.clearAuditLogs(entriesDiff);
                    auditEntryCountAfterSchedulerExecution -= entriesDiff;
                }
                return null;
            }
        });
    }

    @Override
    public void clearAuditLogs(final Integer excessCount) {
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                MoAuditTrackerServiceImpl.this.ao.delete(MoAuditTrackerServiceImpl.this.ao.find(MoAuditTracker.class, Query.select().order("DATE_AND_TIME ASC").limit(excessCount.intValue())));
                return null;
            }
        });
    }

    @Override
    public List<MoAuditTracker> all() {
        return Arrays.asList((MoAuditTracker[])this.ao.find(MoAuditTracker.class));
    }

    @Override
    public void clearAllAuditLogs() {
        List<MoAuditTracker> auditLogsList = this.all();
        for (MoAuditTracker auditLogs : auditLogsList) {
            this.ao.delete(new RawEntity[]{auditLogs});
        }
    }

    @Override
    public void deleteLogs(final Integer excessLogsCount, Integer pastDays) {
        Calendar calendar = Calendar.getInstance();
        long currentTimeInMilliSecs = calendar.getTimeInMillis();
        long filterLogsPeriodInMilliSecs = pastDays * 86400000;
        long timeInPast = currentTimeInMilliSecs - filterLogsPeriodInMilliSecs;
        final Date period = new Date(timeInPast);
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                MoAuditTrackerServiceImpl.this.ao.delete(MoAuditTrackerServiceImpl.this.ao.find(MoAuditTracker.class, Query.select().order("DATE_AND_TIME ASC").where(" DATE_AND_TIME < ? ", new Object[]{period}).limit(excessLogsCount.intValue())));
                return null;
            }
        });
    }

    @Override
    public List<MoAuditTracker> getPaginatedLogs(Date date, Integer offset, Integer pageLimitForLogs) {
        List<MoAuditTracker> auditLogs = Arrays.asList((MoAuditTracker[])this.ao.find(MoAuditTracker.class, Query.select().order("DATE_AND_TIME DESC").where(" DATE_AND_TIME  >= ?", new Object[]{date}).offset((offset - 1) * 20).limit(pageLimitForLogs.intValue())));
        return auditLogs;
    }

    @Override
    public Integer getAuditEntriesCountByDateFilter(Date date) {
        return this.ao.count(MoAuditTracker.class, Query.select().where(" DATE_AND_TIME >= ?", new Object[]{date}));
    }

    @Override
    public Integer getAuditEntriesCountPastDays(Integer pastDays) {
        Calendar calendar = Calendar.getInstance();
        long currentTimeInMilliSecs = calendar.getTimeInMillis();
        long filterLogsPeriodInMilliSecs = pastDays * 86400000;
        long timeInPast = currentTimeInMilliSecs - filterLogsPeriodInMilliSecs;
        Date period = new Date(timeInPast);
        int size = 0;
        size = this.ao.count(MoAuditTracker.class, Query.select().where(" DATE_AND_TIME < ? ", new Object[]{period}));
        return size;
    }
}

