/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.miniorange.rest.auth.commons.MoAuditService;
import com.miniorange.rest.auth.commons.entity.MoAuditLogs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoAuditServiceImpl
implements MoAuditService {
    private ActiveObjects ao;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAuditServiceImpl.class);

    public MoAuditServiceImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public void addAuditLogs(String name, String ipAddress, String date, String requestUrl, String requestType, String status) {
        MoAuditLogs auditLogs = (MoAuditLogs)this.ao.create(MoAuditLogs.class, new DBParam[0]);
        auditLogs.setUserName(name);
        auditLogs.setIpAddress(ipAddress);
        auditLogs.setDate(date);
        auditLogs.setRequestUrl(requestUrl);
        auditLogs.setRequestType(requestType);
        auditLogs.setStatus(status);
        auditLogs.save();
    }

    @Override
    public List<MoAuditLogs> all() {
        return Arrays.asList((MoAuditLogs[])this.ao.find(MoAuditLogs.class));
    }

    @Override
    public void deleteAuditLogs() {
        List<MoAuditLogs> auditLogs = this.all();
        for (MoAuditLogs auditLogs1 : auditLogs) {
            this.ao.delete(new RawEntity[]{auditLogs1});
        }
    }

    @Override
    public List<MoAuditLogs> getLatestAuditLogsEntries() {
        try {
            return Arrays.asList((MoAuditLogs[])this.ao.find(MoAuditLogs.class, Query.select().order("ID DESC").limit(10000)));
        }
        catch (Exception e) {
            LOGGER.error("An Exception occurred while fetching the latest Audit Logs entries" + e.getMessage());
            return new ArrayList<MoAuditLogs>();
        }
    }
}

