/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.miniorange.rest.auth.commons.MoApiKeysService;
import com.miniorange.rest.auth.commons.entity.MoApiKeysEntity;
import com.miniorange.rest.auth.commons.entity.MoUserdataEntity;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoApiKeysServiceImpl
implements MoApiKeysService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoApiKeysServiceImpl.class);
    public ActiveObjects ao;

    public MoApiKeysServiceImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public MoApiKeysEntity addApiKeys(MoUserdataEntity moUserdataEntity, String creationDate, String key, String name, String apiId, String expiryDate) {
        MoApiKeysEntity apiKey = (MoApiKeysEntity)this.ao.create(MoApiKeysEntity.class, new DBParam[0]);
        apiKey.setUserDataEntity(moUserdataEntity);
        apiKey.setCreationDate(creationDate);
        apiKey.setKey(key);
        apiKey.setName(name);
        apiKey.setApiKeyId(apiId);
        apiKey.setExpiryDate(expiryDate);
        apiKey.save();
        return apiKey;
    }

    @Override
    public List<MoApiKeysEntity> all() {
        return Arrays.asList((MoApiKeysEntity[])this.ao.find(MoApiKeysEntity.class));
    }

    @Override
    public void deleteApiKeys() {
        List<MoApiKeysEntity> apiKeys = this.all();
        for (MoApiKeysEntity moApiKeysEntity : apiKeys) {
            this.ao.delete(new RawEntity[]{moApiKeysEntity});
        }
    }

    @Override
    public Boolean deleteApiKey(String id) {
        List<MoApiKeysEntity> apiKeys = this.all();
        for (MoApiKeysEntity moApiKeysEntity : apiKeys) {
            if (moApiKeysEntity.getApiKeyId() == null || !moApiKeysEntity.getApiKeyId().equals(id)) continue;
            this.ao.delete(new RawEntity[]{moApiKeysEntity});
            return true;
        }
        return false;
    }

    @Override
    public Boolean updateApiKey(String id, String windowStart, String windowCount) {
        List<MoApiKeysEntity> apiKeys = this.all();
        for (MoApiKeysEntity moApiKeysEntity : apiKeys) {
            if (moApiKeysEntity.getApiKeyId() == null) {
                LOGGER.debug("API key not found!");
            }
            if (!moApiKeysEntity.getApiKeyId().equals(id)) continue;
            MoApiKeysEntity[] data = (MoApiKeysEntity[])this.ao.find(MoApiKeysEntity.class, Query.select().where("API_KEY_ID = ?", new Object[]{id}));
            Calendar now = Calendar.getInstance();
            data[0].setLastAccessedTime(String.valueOf(now.getTime()));
            if (windowStart != null && windowCount != null) {
                data[0].setWindowStart(windowStart);
                data[0].setWindowSize(windowCount);
            }
            data[0].save();
            return true;
        }
        return false;
    }
}

