/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.miniorange.license.MoLicenseDetails;
import com.miniorange.license.MoLicenseManager;
import com.miniorange.license.constants.MoPluginKey;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoOfflineLicenseHandler;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoConfluenceOfflineLicensingAction
extends ConfluenceActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoConfluenceOfflineLicensingAction.class);
    private UserManager userManager;
    private MoRESTPluginHandler pluginHandler;
    private MoOfflineLicenseHandler licenseSettings;
    private PluginLicenseManager pluginLicenseManager;
    private LicenseService licenseService;
    private LicenseHandler licenseHandler;
    private I18nResolver i18nResolver;
    private MoLicenseManager moLicenseManager;
    private MoRESTAuthSettings settings;
    private File licenseFile;
    private String serverLicenseExpiryDate = "";
    private boolean error = false;
    private boolean isOfflineLicensevalid = false;
    private boolean isDatacenter;
    private boolean licenseConfigured = false;
    private int daysLeftToExpire;
    private String licenseExpiryDate;
    private Boolean licenseFileSubmitted = false;

    public MoConfluenceOfflineLicensingAction(UserManager userManager, MoRESTPluginHandler pluginHandler, MoOfflineLicenseHandler licenseSettings, PluginLicenseManager pluginLicenseManager, LicenseService licenseService, LicenseHandler licenseHandler, I18nResolver i18nResolver, MoLicenseManager moLicenseManager, MoRESTAuthSettings settings) {
        this.userManager = userManager;
        this.pluginHandler = pluginHandler;
        this.licenseSettings = licenseSettings;
        this.pluginLicenseManager = pluginLicenseManager;
        this.licenseService = licenseService;
        this.licenseHandler = licenseHandler;
        this.i18nResolver = i18nResolver;
        this.moLicenseManager = moLicenseManager;
        this.settings = settings;
    }

    public String execute() throws Exception {
        LOGGER.debug("mo Confluence Offline licensing execute called");
        MoRESTPluginHandler.enforceWebsudoProtection(this.getCurrentRequest(), null);
        if (this.isAdministrator()) {
            if (BooleanUtils.toBoolean(this.licenseFileSubmitted)) {
                String licenseKey = this.handleUpload();
                if (this.validateOfflineLicensing(licenseKey).booleanValue()) {
                    LOGGER.debug("`License validation done`");
                    this.settings.setOfflineLicenseKey(licenseKey);
                    this.addActionMessage("License Updated Successfully", new Object[]{"success", true, null});
                    this.isOfflineLicensevalid = true;
                } else {
                    this.isOfflineLicensevalid = false;
                    this.error = true;
                    this.addActionError("License Validation Failed");
                }
            }
            this.initialize();
            LOGGER.debug("isLicenseConfigured:" + this.licenseConfigured);
            return "input";
        }
        return "input";
    }

    public Boolean validateOfflineLicensing(String licenseKey) {
        LOGGER.debug("inside validating offline licensing");
        if (this.isDatacenter()) {
            return true;
        }
        MoPluginKey pluginKey = MoPluginKey.CONFLUENCE_REST;
        String serverId = this.licenseHandler.getServerId();
        MoLicenseDetails moLicenseDetails = this.moLicenseManager.verifyAndFetchDetails(licenseKey, serverId, pluginKey);
        if (moLicenseDetails == null) {
            this.licenseSettings.setIsValidLicenseFileConfigured(false);
            LOGGER.error("Unable to fetch License Details Object");
            return false;
        }
        int userTier = this.getLicensedUserTierForConfluence();
        LOGGER.debug("\n\nUserTier is :- " + userTier + "\n");
        if (userTier != moLicenseDetails.getUserTier()) {
            LOGGER.error("User tier does not match with Licensed User Tier");
            return false;
        }
        String licenseExpiryDate = moLicenseDetails.getExpiryDate();
        if (this.licenseSettings.getDaysLeftToExpire(licenseExpiryDate) < 0) {
            LOGGER.error("License has expired");
            return false;
        }
        this.licenseSettings.setMOCustomerToken(moLicenseDetails.getCustomerToken());
        this.licenseSettings.setMOLicensedUserTier(userTier);
        this.licenseSettings.setIsValidLicenseFileConfigured(true);
        this.licenseSettings.setMOLicenseExpiryDate(licenseExpiryDate);
        return true;
    }

    public int getLicensedUserTierForConfluence() {
        try {
            ConfluenceLicense license = this.licenseService.retrieve();
            int userTier = license.getMaximumNumberOfUsers();
            return userTier;
        }
        catch (Exception e) {
            LOGGER.error("Error occured", (Throwable)e);
            return 0;
        }
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }

    public boolean isOfflineLicenseValid() {
        String licenseKey = this.licenseSettings.getOfflineLicenseKey();
        return this.validateOfflineLicensing(licenseKey);
    }

    public void initialize() throws ParseException {
        this.licenseConfigured = this.licenseSettings.getIsValidLicenseFileConfigured();
        this.isOfflineLicensevalid = this.isOfflineLicenseValid();
        this.isDatacenter = this.settings.isDatacenter();
        this.daysLeftToExpire = this.licenseSettings.getDaysLeftToExpire(this.licenseSettings.getMOLicenseExpiryDate());
        this.licenseExpiryDate = this.licenseSettings.getMOLicenseExpiryDate().split(" ")[0];
        try {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (pluginLicense != null) {
                String expiryDateString = pluginLicense.getExpiryDate().toString();
                expiryDateString = expiryDateString.substring(5);
                expiryDateString = expiryDateString.substring(0, expiryDateString.length() - 1);
                DateTime currentDate = new DateTime();
                LOGGER.debug("Current Date is " + currentDate);
                DateTime expiryDate = new DateTime(expiryDateString);
                this.serverLicenseExpiryDate = expiryDate.toString().substring(0, 10);
            } else {
                this.serverLicenseExpiryDate = "";
            }
        }
        catch (Exception e) {
            LOGGER.error("Issue getting license validity" + e);
        }
    }

    private String handleUpload() throws IOException {
        try {
            MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
            this.licenseFile = wrapper.getFile("licenseFile");
            if (this.licenseFile != null) {
                String licenseKey = IOUtils.toString((InputStream)new FileInputStream(this.licenseFile));
                LOGGER.debug("License Key : " + licenseKey);
                return licenseKey;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occured := ", (Throwable)e);
        }
        return null;
    }

    public File getLicenseFile() {
        return this.licenseFile;
    }

    public void setLicenseFile(File licenseFile) {
        this.licenseFile = licenseFile;
    }

    public boolean getIsOfflineLicensevalid() {
        return this.isOfflineLicensevalid;
    }

    public void setIsOfflineLicensevalid(boolean isOfflineLicensevalid) {
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public Boolean getLicenseFileSubmitted() {
        return this.licenseFileSubmitted;
    }

    public void setLicenseFileSubmitted(Boolean licenseFileSubmitted) {
        this.licenseFileSubmitted = licenseFileSubmitted;
    }

    public boolean getIsDatacenter() {
        return this.isDatacenter;
    }

    public void setIsDatacenter(boolean isDatacenter) {
        this.isDatacenter = isDatacenter;
    }

    public String getServerLicenseExpiryDate() {
        return this.serverLicenseExpiryDate;
    }

    public void setServerLicenseExpiryDate(String serverLicenseExpiryDate) {
        this.serverLicenseExpiryDate = serverLicenseExpiryDate;
    }

    public boolean isOfflineLicensevalid() {
        return this.isOfflineLicensevalid;
    }

    public void setOfflineLicensevalid(boolean offlineLicensevalid) {
        this.isOfflineLicensevalid = offlineLicensevalid;
    }

    public boolean isDatacenter() {
        return this.isDatacenter;
    }

    public void setDatacenter(boolean datacenter) {
        this.isDatacenter = datacenter;
    }

    public boolean isLicenseConfigured() {
        return this.licenseConfigured;
    }

    public void setLicenseConfigured(boolean licenseConfigured) {
        this.licenseConfigured = licenseConfigured;
    }

    public String getLicenseExpiryDate() {
        return this.licenseExpiryDate;
    }

    public void setLicenseExpiryDate(String licenseExpiryDate) {
        this.licenseExpiryDate = licenseExpiryDate;
    }

    public MoRESTAuthSettings getSettings() {
        return this.settings;
    }

    public int getDaysLeftToExpire() {
        return this.daysLeftToExpire;
    }

    public void setDaysLeftToExpire(int daysLeftToExpire) {
        this.daysLeftToExpire = daysLeftToExpire;
    }

    public void setSettings(MoRESTAuthSettings settings) {
        this.settings = settings;
    }
}

