/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.spring.container.ContainerManager;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.util.PlatformUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoConfigureTokenviaRestAPI
extends ConfluenceActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoConfigureTokenviaRestAPI.class);
    private MoRESTAuthSettings restAuthSettings;
    private final I18nResolver i18nResolver;
    private PlatformUtils platformUtils;
    private String platform;
    private UserManager userManager;
    private String baseUrl;
    private Boolean isAdmin;

    public MoConfigureTokenviaRestAPI(MoRESTAuthSettings moRESTAuthSettings, I18nResolver i18nResolver, UserManager userManager) {
        this.restAuthSettings = moRESTAuthSettings;
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
    }

    public String execute() {
        try {
            LOGGER.debug("MoConfigureTokenViaRestApi execute called");
            this.platform = this.i18nResolver.getText("my.plugin.platform");
            LOGGER.debug("platform is " + this.platform);
            this.baseUrl = this.getBaseUrl();
            this.isAdmin = this.isAdministrator();
            return "success";
        }
        catch (Exception e) {
            LOGGER.debug("An exception occured" + e.getMessage());
            return "error";
        }
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public void setIsAdmin(Boolean admin) {
        this.isAdmin = admin;
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }

    public String getBaseUrl() {
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        return settingsManager.getGlobalSettings().getBaseUrl();
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public PlatformUtils getPlatformUtils() {
        return this.platformUtils;
    }

    public void setPlatformUtils(PlatformUtils platformUtils) {
        this.platformUtils = platformUtils;
    }
}

