/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.themes.ThemeHelper;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoOfflineLicenseHandler;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.util.MoPluginConstants;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoConfigureProviderAction
extends ConfluenceActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoConfigureProviderAction.class);
    private MoRESTAuthSettings settings;
    private MoRESTPluginHandler pluginHandler;
    private String oauthProvider;
    private MoOfflineLicenseHandler moOfflineLicenseHandler;
    private List<String> oauthProviders;
    private String keycloakHost;
    private String keycloakRealm;
    private String salesforceDomain;
    private String awsCognitoDomainName;
    private String oktaDomainName;
    private String usernameAttribute;
    private String introspectionEndpoint;
    private String azureAdTenantID;
    private Boolean providerSubmitted;
    private ThemeHelper i18nHelper = this.getHelper();
    private String platform;
    private Boolean enableDebugLogs;
    private Boolean hideSensitiveInformation;
    private String baseUrl;
    private String authEndpointForCustomProvider;
    private String tokenEndpointForCustomProvider;
    private String clientID;
    private String clientSecret;
    private String scope;
    private String state;
    private String oauthType;
    private boolean isDatacenter;

    public MoConfigureProviderAction(MoRESTAuthSettings settings, MoRESTPluginHandler pluginHandler, MoOfflineLicenseHandler moOfflineLicenseHandler) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.moOfflineLicenseHandler = moOfflineLicenseHandler;
    }

    public void doValidate() {
        MoRESTPluginHandler.enforceWebsudoProtection(this.getCurrentRequest(), null);
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (BooleanUtils.toBoolean(this.providerSubmitted)) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank(this.introspectionEndpoint)) {
                try {
                    new URL(this.introspectionEndpoint);
                }
                catch (MalformedURLException e) {
                    LOGGER.error(e.getMessage());
                    validationErrors.add("restauth.error.introspection.invalid");
                }
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase(this.oauthProvider, "custom")) {
                validationErrors.add("restauth.error.introspection.empty");
            }
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase(this.oauthProvider, "keycloak")) {
                if (org.apache.commons.lang3.StringUtils.isBlank(this.keycloakHost)) {
                    validationErrors.add("restauth.error.keycloakhost.empty");
                }
                if (org.apache.commons.lang3.StringUtils.isBlank(this.keycloakRealm)) {
                    validationErrors.add("restauth.error.keycloakrealm.empty");
                }
            }
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase(this.oauthProvider, "salesforce") && org.apache.commons.lang3.StringUtils.isBlank(this.salesforceDomain)) {
                validationErrors.add("restauth.error.salesforcedomain.empty");
            }
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase(this.oauthProvider, "AWS_Cognito") && org.apache.commons.lang3.StringUtils.isBlank(this.awsCognitoDomainName)) {
                validationErrors.add("restauth.error.domainName.empty");
            }
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase(this.oauthProvider, "Okta") && org.apache.commons.lang3.StringUtils.isBlank(this.oktaDomainName)) {
                validationErrors.add("restauth.error.domainName.empty");
            }
            if (StringUtils.equalsIgnoreCase((String)this.oauthProvider, (String)"Azure AD") && StringUtils.isBlank((String)this.azureAdTenantID)) {
                validationErrors.add("restauth.error.tenant_id.empty");
            }
        }
        if (!validationErrors.isEmpty()) {
            for (String errorKey : validationErrors) {
                this.addActionError(errorKey);
            }
            this.initializeForm();
        }
    }

    public String execute() {
        if (BooleanUtils.toBoolean(this.providerSubmitted)) {
            this.pluginHandler.saveOauthProviderConfig(this.oauthProvider, this.clientID, this.clientSecret, this.scope, this.state, this.usernameAttribute);
            if (org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, MoPluginConstants.Providers.KEYCLOAK.getName())) {
                this.pluginHandler.saveKeyCloakConfig(this.keycloakHost, this.keycloakRealm);
            } else if (org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, MoPluginConstants.Providers.AZURE.getName()) || org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, MoPluginConstants.Providers.AZURE_B2C.getName())) {
                this.pluginHandler.saveAzureConfig(this.azureAdTenantID);
            } else if (org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, MoPluginConstants.Providers.GITHUB.getName()) || org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, MoPluginConstants.Providers.GITHUB_ENTERPRISE.getName())) {
                this.pluginHandler.saveGithubConfig();
            } else if (org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, MoPluginConstants.Providers.MEETUP.getName())) {
                this.pluginHandler.saveMeetupConfig();
            } else if (org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, MoPluginConstants.Providers.SLACK.getName())) {
                this.pluginHandler.saveSlackConfig();
            } else if (org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, MoPluginConstants.Providers.SALESFORCE.getName())) {
                this.pluginHandler.saveSalesforceConfig(this.salesforceDomain);
            } else if (org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, MoPluginConstants.Providers.AWS_Cognito.getName())) {
                this.pluginHandler.saveAwsCognitoConfig(this.awsCognitoDomainName);
            } else if (org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, MoPluginConstants.Providers.GOOGLE.getName())) {
                this.pluginHandler.saveGoogleConfig();
            } else if (org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, MoPluginConstants.Providers.GITLAB.getName())) {
                this.pluginHandler.saveGitlabConfig();
            } else if (org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, MoPluginConstants.Providers.FACEBOOK.getName())) {
                this.pluginHandler.saveFacebookConfig();
            } else if (org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, MoPluginConstants.Providers.DISCORD.getName())) {
                this.pluginHandler.saveDiscordConfig();
            } else if (org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, MoPluginConstants.Providers.OKTA.getName())) {
                this.pluginHandler.saveOkta(this.oktaDomainName);
            } else if (org.apache.commons.lang3.StringUtils.equals(this.oauthProvider, "custom")) {
                this.pluginHandler.saveCustomConfig(this.introspectionEndpoint, this.authEndpointForCustomProvider, this.tokenEndpointForCustomProvider);
            }
            this.addActionMessage(this.i18nHelper.getText("restauth.success.save"), new Object[]{"success", true, null});
        }
        this.initializeForm();
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)"com.miniorange.rest.auth");
        logger.setLevel(Level.DEBUG);
        return "success";
    }

    private void initializeForm() {
        LOGGER.debug("Inside initialise form");
        this.isDatacenter = this.settings.isDatacenter();
        this.oauthProvider = this.settings.getOAuthProvider();
        this.keycloakHost = this.settings.getKeycloakHost();
        this.keycloakRealm = this.settings.getKeycloakRealm();
        this.salesforceDomain = this.settings.getSalesforceDomain();
        this.oktaDomainName = this.settings.getOktaDomainName();
        this.awsCognitoDomainName = this.settings.getAwsCognitoDomainName();
        this.usernameAttribute = this.settings.getUsernameAttribute();
        this.introspectionEndpoint = this.settings.getIntrospectionEndpoint();
        LOGGER.debug("introspection Endpoint = " + this.introspectionEndpoint);
        this.azureAdTenantID = this.settings.getAzureADTenantID();
        this.enableDebugLogs = this.settings.getEnableDebugLogs();
        this.hideSensitiveInformation = this.settings.getHideSensitiveInformation();
        this.clientID = this.settings.getClientId();
        this.clientSecret = this.settings.getClientSecret();
        this.scope = this.settings.getScope();
        this.state = this.settings.getState();
        this.baseUrl = this.settings.getBaseUrl();
        this.authEndpointForCustomProvider = this.settings.getAuthUrlForOAuthToken();
        this.tokenEndpointForCustomProvider = this.settings.getTokenUrlForOAuthToken();
        this.oauthType = this.settings.getOauthTokenType();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Boolean getEnableDebugLogs() {
        return this.enableDebugLogs;
    }

    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.enableDebugLogs = enableDebugLogs;
    }

    public MoRESTAuthSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoRESTAuthSettings settings) {
        this.settings = settings;
    }

    public String getOauthProvider() {
        return this.oauthProvider;
    }

    public void setOauthProvider(String oauthProvider) {
        this.oauthProvider = oauthProvider;
    }

    public List<String> getOauthProviders() {
        ArrayList<String> oauthProviders = new ArrayList<String>();
        for (MoPluginConstants.Providers provider : MoPluginConstants.Providers.values()) {
            oauthProviders.add(provider.getName());
        }
        Collections.sort(oauthProviders);
        return oauthProviders;
    }

    public String getAwsCognitoDomainName() {
        return this.awsCognitoDomainName;
    }

    public void setAwsCognitoDomainName(String awsCognitoDomainName) {
        this.awsCognitoDomainName = awsCognitoDomainName;
    }

    public String getOktaDomainName() {
        return this.oktaDomainName;
    }

    public void setOktaDomainName(String oktaDomainName) {
        this.oktaDomainName = oktaDomainName;
    }

    public void setOauthProviders(List<String> oauthProviders) {
        this.oauthProviders = oauthProviders;
    }

    public String getKeycloakHost() {
        return this.keycloakHost;
    }

    public MoRESTPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoRESTPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public void setKeycloakHost(String keycloakHost) {
        this.keycloakHost = keycloakHost;
    }

    public String getKeycloakRealm() {
        return this.keycloakRealm;
    }

    public void setKeycloakRealm(String keycloakRealm) {
        this.keycloakRealm = keycloakRealm;
    }

    public String getSalesforceDomain() {
        return this.salesforceDomain;
    }

    public void setSalesforceDomain(String salesforceDomain) {
        this.salesforceDomain = salesforceDomain;
    }

    public Boolean getProviderSubmitted() {
        return this.providerSubmitted;
    }

    public void setProviderSubmitted(Boolean providerSubmitted) {
        this.providerSubmitted = providerSubmitted;
    }

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public String getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    public void setIntrospectionEndpoint(String introspectionEndpoint) {
        this.introspectionEndpoint = introspectionEndpoint;
    }

    public String getPlatform() {
        return this.i18nHelper.getText("my.plugin.platform");
    }

    public String getAzureAdTenantID() {
        return this.azureAdTenantID;
    }

    public void setAzureAdTenantID(String azureAdTenantID) {
        this.azureAdTenantID = azureAdTenantID;
    }

    public Boolean getHideSensitiveInformation() {
        return this.hideSensitiveInformation;
    }

    public void setHideSensitiveInformation(Boolean hideSensitiveInformation) {
        this.hideSensitiveInformation = hideSensitiveInformation;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getAuthEndpointForCustomProvider() {
        return this.authEndpointForCustomProvider;
    }

    public void setAuthEndpointForCustomProvider(String authEndpointForCustomProvider) {
        this.authEndpointForCustomProvider = authEndpointForCustomProvider;
    }

    public String getTokenEndpointForCustomProvider() {
        return this.tokenEndpointForCustomProvider;
    }

    public void setTokenEndpointForCustomProvider(String tokenEndpointForCustomProvider) {
        this.tokenEndpointForCustomProvider = tokenEndpointForCustomProvider;
    }

    public String getOauthType() {
        return this.oauthType;
    }

    public void setOauthType(String oauthType) {
        this.oauthType = oauthType;
    }

    public boolean getIsDatacenter() {
        return this.isDatacenter;
    }

    public void setIsDatacenter(boolean datacenter) {
        this.isDatacenter = datacenter;
    }
}

