/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.themes.ThemeHelper;
import com.atlassian.confluence.user.UserAccessor;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoClientCredentials
extends ConfluenceActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoClientCredentials.class);
    private MoRESTAuthSettings settings;
    private MoRESTPluginHandler pluginHandler;
    private ThemeHelper i18nHelper = this.getHelper();
    private UserAccessor userAccessor;
    private String platform;
    private boolean clientCredFormSubmitted;
    private String oauthProvider;
    private String introspectionUrl;
    private String redirectUri;
    private String clientId;
    private String clientSecret;
    private String username;
    private String scope;
    private String oauthType;

    public MoClientCredentials(MoRESTAuthSettings settings, MoRESTPluginHandler pluginHandler, UserAccessor userAccessor) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.userAccessor = userAccessor;
    }

    public void validate() {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (StringUtils.isNotBlank(this.introspectionUrl)) {
            try {
                new URL(this.introspectionUrl);
            }
            catch (MalformedURLException e) {
                LOGGER.error(e.getMessage());
                validationErrors.add("restauth.error.introspection.invalid");
            }
        }
        if (StringUtils.isNotBlank(this.redirectUri)) {
            try {
                new URL(this.redirectUri);
            }
            catch (MalformedURLException e) {
                LOGGER.error(e.getMessage());
                validationErrors.add("restauth.error.redirect.invalid");
            }
        }
        if (StringUtils.isNotBlank(this.username)) {
            LOGGER.debug(this.username);
            LOGGER.debug("bool : " + this.userAccessor.exists(this.username));
            if (!this.userAccessor.exists(this.username)) {
                validationErrors.add("restauth.error.username.invalid");
            }
        }
        if (!validationErrors.isEmpty()) {
            for (String errorKey : validationErrors) {
                this.addActionError(errorKey);
            }
            this.initializeForm();
        }
    }

    public String execute() {
        LOGGER.debug("Submitted: " + this.clientCredFormSubmitted);
        if (this.clientCredFormSubmitted) {
            LOGGER.debug("Client Credentials Form Submitted");
            this.pluginHandler.saveClientCredentialSettings(this.oauthProvider, this.introspectionUrl, this.redirectUri, this.clientId, this.clientSecret, this.username, this.scope);
            this.addActionMessage(this.i18nHelper.getText("restauth.success.save"), new Object[]{"success", true, null});
        }
        this.initializeForm();
        return "success";
    }

    private void initializeForm() {
        LOGGER.debug("Inside initialise form");
        this.oauthProvider = this.settings.getClientCredProviderName();
        this.introspectionUrl = this.settings.getClientCredIntrospectionEndpoint();
        this.redirectUri = this.settings.getClientCredRedirectUri();
        this.clientId = this.settings.getClientCredClientId();
        this.clientSecret = this.settings.getClientCredClientSecret();
        this.username = this.settings.getServiceAccountUsername();
        this.scope = this.settings.getClientCredScope();
        this.oauthType = this.settings.getOauthTokenType();
    }

    public String getPlatform() {
        return this.i18nHelper.getText("my.plugin.platform");
    }

    public Boolean getClientCredFormSubmitted() {
        return this.clientCredFormSubmitted;
    }

    public void setClientCredFormSubmitted(Boolean clientCredFormSubmitted) {
        this.clientCredFormSubmitted = clientCredFormSubmitted;
    }

    public String getOauthProvider() {
        return this.oauthProvider;
    }

    public void setOauthProvider(String oauthProvider) {
        this.oauthProvider = oauthProvider;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getIntrospectionUrl() {
        return this.introspectionUrl;
    }

    public void setIntrospectionUrl(String introspectionUrl) {
        this.introspectionUrl = introspectionUrl;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getOauthType() {
        return this.oauthType;
    }

    public void setOauthType(String oauthType) {
        this.oauthType = oauthType;
    }

    public MoRESTAuthSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoRESTAuthSettings settings) {
        this.settings = settings;
    }
}

