/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.gson.Gson;
import com.miniorange.rest.auth.commons.MoApiKeysService;
import com.miniorange.rest.auth.commons.MoAuditService;
import com.miniorange.rest.auth.commons.MoAuditTrackerService;
import com.miniorange.rest.auth.commons.MoUserDataService;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.dto.ApiKey;
import com.miniorange.rest.auth.commons.dto.AuditLog;
import com.miniorange.rest.auth.commons.entity.MoApiKeysEntity;
import com.miniorange.rest.auth.commons.entity.MoAuditLogs;
import com.miniorange.rest.auth.commons.entity.MoUserdataEntity;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.scheduler.AuditLogScheduler;
import com.miniorange.rest.auth.commons.util.MoPluginConstants;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class MoRestApiMigrationEvent
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoRestApiMigrationEvent.class);
    private EventPublisher eventPublisher;
    private MoRESTAuthSettings restAuthSettings;
    private CrowdService crowdService;
    private MoRESTPluginHandler restPluginHandler;
    private MoUserdataEntity moUserdataEntity;
    private MoApiKeysEntity moApiKeysEntity;
    private MoUserDataService moUserDataService;
    private MoApiKeysService moApiKeysService;
    private PluginSettings pluginSettings;
    private PluginSettingsFactory pluginSettingsFactory;
    private MoAuditService moAuditService;
    private MoAuditTrackerService moAuditTrackerService;
    private AuditLogScheduler auditLogScheduler;

    public MoRestApiMigrationEvent(EventPublisher eventPublisher, MoRESTAuthSettings restAuthSettings, CrowdService crowdService, MoRESTPluginHandler moRESTPluginHandler, MoUserDataService moUserDataService, MoApiKeysService moApiKeysService, PluginSettingsFactory pluginSettingsFactory, MoAuditService moAuditService, MoAuditTrackerService moAuditTrackerService, AuditLogScheduler auditLogScheduler) {
        this.eventPublisher = eventPublisher;
        this.restAuthSettings = restAuthSettings;
        this.crowdService = crowdService;
        this.restPluginHandler = moRESTPluginHandler;
        this.moUserDataService = moUserDataService;
        this.moApiKeysService = moApiKeysService;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.moAuditService = moAuditService;
        this.moAuditTrackerService = moAuditTrackerService;
        this.auditLogScheduler = auditLogScheduler;
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.debug("Rest api migration event called");
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onPluginEnabledEvent(PluginEnabledEvent pluginEnabledEvent) {
        LOGGER.debug("On plugin enable event");
        Plugin plugin = pluginEnabledEvent.getPlugin();
        if (plugin.getKey().equals("com.miniorange.rest.auth.confluence-rest-api-oauth")) {
            if (!this.restAuthSettings.isMigrationHandled().booleanValue()) {
                LOGGER.debug("Migrating api tokens storage into active objects");
                EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
                Iterable users = this.crowdService.search((Query)query);
                try {
                    for (Object u : users) {
                        List<Object> apiKeys = new ArrayList();
                        apiKeys = this.restPluginHandler.getApiKeys(u.getName());
                        if (apiKeys.isEmpty()) {
                            LOGGER.debug("Api Keys are not present for the user " + u.getName());
                            continue;
                        }
                        LOGGER.debug("Api keys are present for the user " + u.getName());
                        this.moUserdataEntity = this.moUserDataService.addUserDetails(u.getName());
                        for (int i = 0; i < apiKeys.size(); ++i) {
                            ApiKey apiKey = (ApiKey)apiKeys.get(i);
                            String encodedString = Base64.getEncoder().encodeToString(apiKey.getKey().getBytes());
                            LOGGER.debug("encoded string is " + encodedString);
                            this.moApiKeysEntity = apiKey.getExpiryDate() == null ? this.moApiKeysService.addApiKeys(this.moUserdataEntity, apiKey.getCreationDate().toString(), encodedString, apiKey.getName(), apiKey.getId(), "") : this.moApiKeysService.addApiKeys(this.moUserdataEntity, apiKey.getCreationDate().toString(), encodedString, apiKey.getName(), apiKey.getId(), apiKey.getExpiryDate().toString());
                            this.pluginSettings.remove(MoPluginConstants.SettingsConstants.API_KEY.getKey().concat(apiKey.getId()));
                        }
                        this.pluginSettings.remove(MoPluginConstants.SettingsConstants.API_KEYS.getKey().concat(u.getName()));
                    }
                    this.restAuthSettings.setMigration(true);
                }
                catch (Exception e) {
                    LOGGER.error("The exception is " + e);
                }
            }
            if (!this.restAuthSettings.getPluginSettingsAuditLogs().booleanValue()) {
                try {
                    LOGGER.debug("Migration of Audit Logs into active objects");
                    Object auditLogsList = this.pluginSettings.get(MoPluginConstants.SettingsConstants.AUDIT_LOGS.getKey());
                    List auditLogs = (List)auditLogsList;
                    Gson gson = new Gson();
                    for (String auditLog : auditLogs) {
                        AuditLog auditLogObject = (AuditLog)gson.fromJson(auditLog, AuditLog.class);
                        this.moAuditService.addAuditLogs(auditLogObject.getUsername(), auditLogObject.getIpAddress(), auditLogObject.getDate().toString(), auditLogObject.getApiUrl(), auditLogObject.getRequestType(), auditLogObject.getStatus());
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Exception is " + e);
                }
                this.pluginSettings.remove(MoPluginConstants.SettingsConstants.AUDIT_LOGS.getKey());
                this.restAuthSettings.setPluginSettingsMigrationAuditLogs(true);
                LOGGER.debug("Audit logs migration is set to " + this.restAuthSettings.getPluginSettingsAuditLogs());
            }
            LOGGER.debug("Is Audit Logs Migration  handled :-" + this.restAuthSettings.isAuditLogsMigrationHandled());
            if (!this.restAuthSettings.isAuditLogsMigrationHandled().booleanValue()) {
                LOGGER.debug("Handling Audit Logs Migration");
                try {
                    List<MoAuditLogs> moAuditLogs = this.moAuditService.getLatestAuditLogsEntries();
                    LOGGER.debug("Latest Audit Entries Size - " + moAuditLogs.size());
                    if (this.restAuthSettings.getEnableAuditLogs().booleanValue() && moAuditLogs.size() == 0) {
                        LOGGER.debug("Moving Audit Logs storage to Active Objects");
                        this.restAuthSettings.setViewPastAuditLogs(true);
                    }
                    if (moAuditLogs.size() != 0) {
                        Collections.reverse(moAuditLogs);
                        for (MoAuditLogs moAuditEntries : moAuditLogs) {
                            String auditEntryStr = moAuditEntries.getDate();
                            SimpleDateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
                            Date moAuditCreation = formatter.parse(auditEntryStr);
                            this.moAuditTrackerService.addAuditEntries(moAuditEntries.getUserName(), moAuditEntries.getIpAddress(), moAuditEntries.getRequestType(), moAuditEntries.getRequestUrl(), moAuditCreation, moAuditEntries.getStatus());
                        }
                        LOGGER.debug("Audit Logs entries transferred to modified AO table");
                    }
                    this.restAuthSettings.setAuditLogsMigrationHandling(true);
                    LOGGER.debug("Scheduling the deletion of Audit Logs to avoid excess of entries");
                    this.auditLogScheduler.schedule();
                    LOGGER.debug("View Past Audit Logs Status is:-" + this.restAuthSettings.viewPastAuditLogs());
                }
                catch (Exception e) {
                    LOGGER.error("An Exception occurred while Handling Audit Logs Migration" + e);
                }
            }
            LOGGER.debug("Is OAuth 2.0 Configurations Migration handled :-" + this.restAuthSettings.isOAuthConfigMigrationHandled());
            if (!this.restAuthSettings.isOAuthConfigMigrationHandled().booleanValue()) {
                LOGGER.debug("Handling OAuth Configuration Migration");
                if (!StringUtils.equals(this.restAuthSettings.getOAuthProvider(), "")) {
                    LOGGER.debug("OAuth Third Party provider configured is : " + this.restAuthSettings.getOAuthProvider());
                    if (StringUtils.equals(this.restAuthSettings.getOAuthProvider(), "Jwt")) {
                        this.restAuthSettings.setOauthTokenType(MoPluginConstants.OauthTokenType.JWT.getValue());
                        this.restPluginHandler.saveJwtSettings(this.restAuthSettings.getOAuthProvider(), this.restAuthSettings.getIntrospectionEndpoint(), this.restAuthSettings.getClientId(), this.restAuthSettings.getPublicKey(), this.restAuthSettings.getUsernameAttribute());
                        LOGGER.debug("JWT Configuration Migration completed successfully");
                    } else if (StringUtils.equals(this.restAuthSettings.getOAuthProvider(), "ClientCredentials")) {
                        this.restAuthSettings.setOauthTokenType(MoPluginConstants.OauthTokenType.CLIENT_CRED_GRANT.getValue());
                        this.restPluginHandler.saveClientCredentialSettings(this.restAuthSettings.getOAuthProvider(), this.restAuthSettings.getIntrospectionEndpoint(), this.restAuthSettings.getBaseUrl() + "/plugins/servlet/restauth/token", this.restAuthSettings.getClientId(), this.restAuthSettings.getClientSecret(), this.restAuthSettings.getService_acc(), null);
                        LOGGER.debug("Client Credential Configuration Migration completed successfully");
                    } else {
                        this.restAuthSettings.setOauthTokenType(MoPluginConstants.OauthTokenType.AUTHORIZATION_GRANT.getValue());
                        LOGGER.debug("Authorization Grant Configuration Migration completed successfully");
                    }
                } else {
                    LOGGER.debug("OAuth Third Party provider not configured");
                }
                this.restAuthSettings.setOAuthConfigMigrationHandling(true);
            }
        }
    }
}

