/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web.support;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.datetime.FriendlyDateFormatter;
import com.atlassian.confluence.core.datetime.RequestTimeThreadLocal;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.user.UserPreferencesAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.spring.container.ContainerManager;
import com.midori.confluence.plugin.archiving.service.support.DateTimeProvider;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;

public class UserFriendlyDateFormatter {
    private FormatSettingsManager formatSettingsManager;
    private I18NBeanFactory i18NBeanFactory;
    private LocaleManager localeManager;
    private UserPreferencesAccessor userPreferencesAccessor;

    public static UserFriendlyDateFormatter getInstance() {
        return new UserFriendlyDateFormatter();
    }

    private UserFriendlyDateFormatter() {
        this.formatSettingsManager = (FormatSettingsManager)ContainerManager.getComponent((String)"formatSettingsManager");
        this.i18NBeanFactory = (I18NBeanFactory)ContainerManager.getComponent((String)"i18NBeanFactory");
        this.localeManager = (LocaleManager)ContainerManager.getComponent((String)"localeManager");
        this.userPreferencesAccessor = (UserPreferencesAccessor)ContainerManager.getComponent((String)"userPreferencesAccessor");
    }

    public UserFriendlyDateFormatter(FormatSettingsManager formatSettingsManager, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, UserPreferencesAccessor userPreferencesAccessor) {
        this.formatSettingsManager = formatSettingsManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
        this.userPreferencesAccessor = userPreferencesAccessor;
    }

    public String formatRelative(Date date) {
        return this.formatRelative(date, "", "");
    }

    public String formatRelative(Date date, String numericPhrasePrefix, String numericPhrasePostfix) {
        if (date == null) {
            return "unknown time ago";
        }
        ZonedDateTime lastSecondOfDayBeforeYesterday = ZonedDateTime.now().minusDays(1L).truncatedTo(ChronoUnit.DAYS).minusSeconds(1L);
        boolean needsFriendlyFormatting = Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).isAfter(lastSecondOfDayBeforeYesterday);
        String result = needsFriendlyFormatting ? this.builtInFriendlyFormatDays(date) : this.simplyFormatDays(date);
        return this.addNumericPhraseDelimiters(result, numericPhrasePrefix, numericPhrasePostfix);
    }

    private String simplyFormatDays(Date date) {
        int days = (int)((DateTimeProvider.currentTimeMillis() - date.getTime()) / 86400000L);
        return String.format("%d day%s ago", days, days == 1 ? "" : "s");
    }

    public String formatAccordingToUserPreferences(Date date) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        UserPreferences preferences = this.userPreferencesAccessor.getUserPreferences(user);
        DateFormatter dateFormatter = new DateFormatter(preferences.getTimeZone(), this.formatSettingsManager, this.localeManager);
        return dateFormatter.formatDateTime(date);
    }

    private String builtInFriendlyFormatDays(Date date) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        UserPreferences preferences = this.userPreferencesAccessor.getUserPreferences(user);
        DateFormatter dateFormatter = new DateFormatter(preferences.getTimeZone(), this.formatSettingsManager, this.localeManager);
        Message message = new FriendlyDateFormatter(RequestTimeThreadLocal.getTimeOrNow(), dateFormatter).getFormatMessage(date);
        return this.i18NBeanFactory.getI18NBean(Locale.ENGLISH).getText(message);
    }

    private String addNumericPhraseDelimiters(String str, String numericPhrasePrefix, String numericPhrasePostfix) {
        return str.replaceFirst("(\\s|^)(\\d+) ", "$1" + Matcher.quoteReplacement(numericPhrasePrefix) + "$2" + Matcher.quoteReplacement(numericPhrasePostfix) + " ");
    }
}

