/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web.rest.model;

import com.midori.confluence.plugin.archiving.web.support.UserFriendlyDateFormatter;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Date;

@XmlRootElement
public class ContentStatusEvent {
    private Date date;
    private String displayName;

    public ContentStatusEvent(Date date, String displayName) {
        this.date = date;
        this.displayName = displayName;
    }

    @XmlElement
    public String getDateFormatted() {
        return UserFriendlyDateFormatter.getInstance().formatAccordingToUserPreferences(this.date);
    }

    @XmlElement
    public String getLongInfoAsHtml() {
        return this.formatRelativeDateBold() + " <small>(" + this.displayName + " on " + this.getDateFormatted() + ")</small>";
    }

    @XmlElement
    public String getShortInfoAsHtml() {
        return "<span title=\"" + this.getDateFormatted() + "\">" + this.formatRelativeDateBold() + "</span> <small>(" + this.displayName + ")</small>";
    }

    public Date getDate() {
        return this.date;
    }

    private String formatRelativeDateBold() {
        return UserFriendlyDateFormatter.getInstance().formatRelative(this.date, "<b>", "</b>");
    }
}

