/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskResultManager;
import com.midori.confluence.plugin.archiving.service.task.result.LongRunningTaskResult;
import com.midori.confluence.plugin.archiving.web.base.AbstractArchivingAction;
import java.io.IOException;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongRunningTaskCompletedAction
extends AbstractArchivingAction {
    private static final Logger log = LoggerFactory.getLogger(LongRunningTaskCompletedAction.class);
    private ContentLifecycleLongRunningTaskResultManager contentLifecycleLongRunningTaskResultManager;
    private String taskId;
    private LongRunningTaskResult result;

    public void setLongRunningTaskResultManager(ContentLifecycleLongRunningTaskResultManager contentLifecycleLongRunningTaskResultManager) {
        this.contentLifecycleLongRunningTaskResultManager = contentLifecycleLongRunningTaskResultManager;
    }

    public String getTaskId() {
        return this.taskId;
    }

    @StrutsParameter
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public LongRunningTaskResult getResult() {
        return this.result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute() throws IOException {
        log.debug(String.format("Viewing task result for task <%s>", this.taskId));
        try {
            this.result = this.contentLifecycleLongRunningTaskResultManager.getResult(this.taskId);
            if (this.result == null) {
                log.debug("No result found");
                return "none";
            }
            String redirectUrl = this.result.getResultRedirectUrl();
            if (redirectUrl != null) {
                String url = this.getBaseUrl() + redirectUrl;
                log.debug(String.format("Redirecting to <%s>", url));
                ServletActionContext.getResponse().sendRedirect(url);
                return "none";
            }
            this.reloadArchiveSpace();
            String action = this.result.getResultWebAction();
            if (action == null) {
                throw new IllegalStateException("Result web action is null");
            }
            log.debug(String.format("Forwarding to result <%s>", action));
            return action;
        }
        catch (ClassCastException ex) {
            log.warn("Failed to get task result (was the app hot-deployed in the meanwhile?)", (Throwable)ex);
            return "none";
        }
    }
}

