/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.atlassian.confluence.core.Beanable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.AbstractPageAction;
import com.atlassian.confluence.user.ConfluenceUser;
import com.google.common.collect.Sets;
import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.service.ContentArchivingManager;
import com.midori.confluence.plugin.archiving.service.ContentStatusCalculator;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.service.strategy.replication.PageReplicator;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleLabelHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentTraversalHelper;
import com.midori.confluence.plugin.archiving.service.support.DateTimeProvider;
import com.midori.confluence.plugin.archiving.service.support.PluginHelper;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPage;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightSpace;
import com.midori.confluence.plugin.archiving.web.rest.model.ContentStatus;
import com.midori.confluence.plugin.archiving.web.rest.model.ContentStatusType;
import com.midori.confluence.plugin.archiving.web.support.QuickActionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivingQuickAction
extends AbstractPageAction
implements Beanable {
    private static final Logger log = LoggerFactory.getLogger(ArchivingQuickAction.class);
    private static final int MAX_PAGES_TO_CONFIRM = 100;
    static final String MC_DISCUSS_EMAILS_SENT = "sdes";
    static final String MC_DISCUSS_SOME_EMAILS_NOT_SENT = "edens";
    static final String MC_CONFIRMED = "sc";
    static final String MC_CONFIRMED_REMAINS_EXPIRED = "wcre";
    static final String MC_CONFIRMED_REMAINS_ARCHIVED = "wcra";
    static final String MC_MARKED_FOR_EXPIRATION = "smfe";
    static final String MC_EXPIRATION_TRACKING_DISABLED = "wetd";
    static final String MC_UNEXPIRED = "sue";
    static final String MC_MARKED_FOR_ARCHIVING = "smfa";
    static final String MC_ARCHIVING_DISABLED = "wad";
    static final String MC_UNARCHIVED = "sua";
    static final String MC_EXCLUDED = "sefa";
    static final String MC_INCLUDED = "si";
    static final String MC_OWNERS_SET = "so";
    static final String MC_NOT_ALLOWED = "ena";
    private CommentManager commentManager;
    private ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private ContentArchivingManager contentArchivingManager;
    private ContentLifecycleLabelHelper contentLifecycleLabelHelper;
    private ContentStatusCalculator contentStatusCalculator;
    private ContentTraversalHelper contentTraversalHelper;
    private PageManager pageManager;
    private PageReplicator pageReplicator;
    private QuickActionHelper quickActionHelper;
    private ContentStatusType contentStatusType;
    private Long ancestorId;
    private String recipients;
    private String message;
    private boolean archiveByDate;
    private String date;
    private boolean recursive;
    private String ownersSingle;
    private String ownersRecursive;
    private Map<String, Object> bean = new HashMap<String, Object>();
    private List<String> validationErrors = new ArrayList<String>();
    private String messageCode;
    private String labelName;

    public void setCommentManager(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    public void setContentArchivingConfigurationManager(ContentArchivingConfigurationManager contentArchivingConfigurationManager) {
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
    }

    public void setContentArchivingManager(ContentArchivingManager contentArchivingManager) {
        this.contentArchivingManager = contentArchivingManager;
    }

    public void setContentLifecycleLabelHelper(ContentLifecycleLabelHelper contentLifecycleLabelHelper) {
        this.contentLifecycleLabelHelper = contentLifecycleLabelHelper;
    }

    public void setContentStatusCalculator(ContentStatusCalculator contentStatusCalculator) {
        this.contentStatusCalculator = contentStatusCalculator;
    }

    public void setContentTraversalHelper(ContentTraversalHelper contentTraversalHelper) {
        this.contentTraversalHelper = contentTraversalHelper;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setPageReplicator(PageReplicator pageReplicator) {
        this.pageReplicator = pageReplicator;
    }

    public void setQuickActionHelper(QuickActionHelper quickActionHelper) {
        this.quickActionHelper = quickActionHelper;
    }

    @StrutsParameter
    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    @StrutsParameter
    public void setMessage(String message) {
        this.message = message;
    }

    @StrutsParameter
    public void setOwnersSingle(String ownersSingle) {
        this.ownersSingle = ownersSingle;
    }

    @StrutsParameter
    public void setOwnersRecursive(String ownersRecursive) {
        this.ownersRecursive = ownersRecursive;
    }

    @StrutsParameter
    public void setArchiveByDate(boolean archiveByDate) {
        this.archiveByDate = archiveByDate;
    }

    @StrutsParameter
    public void setDate(String date) {
        this.date = date;
    }

    @StrutsParameter
    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @StrutsParameter
    public void setStatusCode(String statusCode) {
        this.contentStatusType = ContentStatusType.fromCode(statusCode);
    }

    @StrutsParameter
    public void setAncestorId(Long ancestorId) {
        this.ancestorId = ancestorId;
    }

    public Object getBean() {
        this.bean.put("validationErrors", this.validationErrors);
        this.bean.put("messageCode", this.messageCode);
        this.bean.put("labelName", this.labelName);
        return this.bean;
    }

    public String init() {
        Page page = (Page)this.getPage();
        long start = DateTimeProvider.currentTimeMillis();
        List<String> primaryActions = this.quickActionHelper.getPrimaryActionCodesAvailableForPage(page, this.contentStatusType, this.ancestorId);
        List<String> secondaryActions = this.quickActionHelper.getSecondaryActionCodesAvailableForPage(page, this.contentStatusType, this.ancestorId);
        secondaryActions.removeIf(primaryActions::contains);
        this.bean.put("actions", this.quickActionHelper.getActionsForPage(page, this.contentStatusType, this.ancestorId));
        this.bean.put("primaryActions", primaryActions);
        this.bean.put("secondaryActions", secondaryActions);
        this.bean.put("isReadOnlyAccessModeEnabled", PluginHelper.isReadOnlyAccessModeEnabled());
        log.debug(String.format("Quick actions initialized in %d ms", DateTimeProvider.currentTimeMillis() - start));
        return "success";
    }

    public String discuss() {
        LightSpace space = LightSpace.fromSpace(this.getSpace());
        LightPage page = LightPage.fromPage((Page)this.getPage());
        ConfluenceUser sender = this.getAuthenticatedUser();
        String[] addressees = StringUtils.split((String)this.recipients, (String)",");
        this.message = this.message.trim();
        if (addressees.length == 0) {
            this.validationErrors.add("At least one recipient is required.");
        }
        if (this.message.isEmpty()) {
            this.validationErrors.add("Message is required.");
        }
        if (!this.validationErrors.isEmpty()) {
            return "success";
        }
        int emailsSent = this.contentArchivingManager.sendDiscussedPagesNotificationEmails(space, page, sender, addressees, this.message);
        int failedEmails = addressees.length - emailsSent;
        this.bean.put("failedEmails", failedEmails);
        this.messageCode = failedEmails == 0 ? MC_DISCUSS_EMAILS_SENT : MC_DISCUSS_SOME_EMAILS_NOT_SENT;
        return "success";
    }

    public String confirm() {
        int pagesToConfirm;
        Page page = (Page)this.getPage();
        if (this.recursive && (pagesToConfirm = this.pageManager.getDescendantIds(page).size() + 1) > 100) {
            this.validationErrors.add(String.format("%d pages would be confirmed. Maximum %d is allowed for performance reasons.<br>Either confirm this page only (by unchecking \"Also confirm all descendant pages\") or confirm pages in a smaller page tree.", pagesToConfirm, 100));
            return "success";
        }
        long start = DateTimeProvider.currentTimeMillis();
        String versionComment = StringUtils.isBlank((CharSequence)this.message) ? "Confirmed." : "Confirmed: " + StringUtils.trimToEmpty((String)this.message);
        this.pageReplicator.addNewPageVersion(this.getPageId(), versionComment, this.recursive);
        log.debug(String.format("Quick action \"confirm\" completed in %d ms", DateTimeProvider.currentTimeMillis() - start));
        ContentStatus contentStatus = this.contentStatusCalculator.calculateContentStatus(page);
        this.messageCode = contentStatus.getContentStatusSummary().getType() == ContentStatusType.EXPIRED_BY_LABEL ? MC_CONFIRMED_REMAINS_EXPIRED : (contentStatus.getContentStatusSummary().getType() == ContentStatusType.TO_BE_ARCHIVED_BY_LABEL ? MC_CONFIRMED_REMAINS_ARCHIVED : MC_CONFIRMED);
        return "success";
    }

    public String own() {
        HashSet<String> ownersSingle = Sets.newHashSet(StringUtils.split((String)this.ownersSingle, (String)","));
        HashSet<String> ownersRecursive = Sets.newHashSet(StringUtils.split((String)this.ownersRecursive, (String)","));
        ownersSingle.removeAll(ownersRecursive);
        if (this.removeLabelsWithPattern(ContentLifecycleLabelHelper.ALL_OWNED_BY_LABEL_PATTERNS)) {
            boolean labelsAdded = true;
            for (String owner : ownersSingle) {
                labelsAdded &= this.addLabel("owned-single-by-" + ContentLifecycleLabelHelper.escapeLabelName(owner));
            }
            for (String owner : ownersRecursive) {
                labelsAdded &= this.addLabel("owned-by-" + ContentLifecycleLabelHelper.escapeLabelName(owner));
            }
            this.messageCode = labelsAdded ? MC_OWNERS_SET : MC_NOT_ALLOWED;
        } else {
            this.messageCode = MC_NOT_ALLOWED;
        }
        return "success";
    }

    public String expire() {
        ContentArchivingConfiguration config;
        this.validateDateFieldValue("Expiration date");
        if (!this.validationErrors.isEmpty()) {
            return "success";
        }
        this.labelName = (this.recursive ? "expire-" : "expire-single-") + this.date;
        this.messageCode = this.removeLabelsWithPattern(ContentLifecycleLabelHelper.ALL_EXPIRE_LABEL_PATTERNS) && this.addLabel(this.labelName) ? ((config = this.contentArchivingConfigurationManager.findResolvedConfiguration(this.getSpaceKey())).isPageExpirationTrackingByLabelEnabled() ? MC_MARKED_FOR_EXPIRATION : MC_EXPIRATION_TRACKING_DISABLED) : MC_NOT_ALLOWED;
        return "success";
    }

    public String unexpire() {
        this.messageCode = this.removeLabelsWithPattern(ContentLifecycleLabelHelper.ALL_EXPIRE_LABEL_PATTERNS) ? MC_UNEXPIRED : MC_NOT_ALLOWED;
        return "success";
    }

    public String archive() {
        if (this.archiveByDate) {
            this.validateDateFieldValue("Archiving date");
            this.labelName = (this.recursive ? "archive-" : "archive-single-") + this.date;
        } else {
            this.labelName = this.recursive ? "archive" : "archive-single";
        }
        ContentArchivingConfiguration config = this.contentArchivingConfigurationManager.findResolvedConfiguration(this.getSpaceKey());
        if (config.isArchivingReasonRequired() && StringUtils.isBlank((CharSequence)this.message)) {
            this.validationErrors.add("Reason is required.");
        }
        if (!this.validationErrors.isEmpty()) {
            return "success";
        }
        if (this.removeLabelsWithPattern(ContentLifecycleLabelHelper.ALL_ARCHIVE_LABEL_PATTERNS) && this.addLabel(this.labelName)) {
            if (this.shouldArchivingReasonBeAdded(this.message)) {
                String comment = StringUtils.trimToEmpty((String)this.message) + " " + "#archive";
                this.commentManager.addCommentToObject((ContentEntityObject)this.getPage(), null, comment);
            }
            this.messageCode = config.isPageArchivingByLabelEnabled() ? MC_MARKED_FOR_ARCHIVING : MC_ARCHIVING_DISABLED;
        } else {
            this.messageCode = MC_NOT_ALLOWED;
        }
        return "success";
    }

    public String unarchive() {
        this.messageCode = this.removeLabelsWithPattern(ContentLifecycleLabelHelper.ALL_ARCHIVE_LABEL_PATTERNS) ? MC_UNARCHIVED : MC_NOT_ALLOWED;
        return "success";
    }

    public String exclude() {
        this.labelName = this.recursive ? "noarchive" : "noarchive-single";
        this.messageCode = this.removeLabelsWithPattern(ContentLifecycleLabelHelper.ALL_NOARCHIVE_LABEL_PATTERNS) && this.addLabel(this.labelName) ? MC_EXCLUDED : MC_NOT_ALLOWED;
        return "success";
    }

    public String include() {
        this.messageCode = this.removeLabelsWithPattern(ContentLifecycleLabelHelper.ALL_NOARCHIVE_LABEL_PATTERNS) ? MC_INCLUDED : MC_NOT_ALLOWED;
        return "success";
    }

    private void validateDateFieldValue(String dateFieldLabel) {
        if (StringUtils.isBlank((CharSequence)this.date)) {
            this.validationErrors.add(dateFieldLabel + " is required.");
        } else if (!this.date.matches("\\d{2}\\/\\d{1,2}\\/\\d{1,2}")) {
            this.validationErrors.add("Invalid date format.");
        }
    }

    private boolean addLabel(String labelName) {
        return this.contentLifecycleLabelHelper.addLabelToPage(this.getAuthenticatedUser(), this.getPageId(), labelName) != null;
    }

    private boolean removeLabelsWithPattern(String ... labelPatterns) {
        for (Label label : this.getPage().getLabels()) {
            for (String pattern : labelPatterns) {
                Collection<String> labelsRemoved;
                if (!label.getName().matches(pattern) || (labelsRemoved = this.contentLifecycleLabelHelper.removeLabelFromPage(this.getAuthenticatedUser(), this.getPageId(), label.getName())) != null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean shouldArchivingReasonBeAdded(String reason) {
        String existingReason = this.contentTraversalHelper.getArchivingReason((Page)this.getPage(), false);
        String newReason = StringUtils.trimToNull((String)reason);
        return newReason != null && !newReason.equals(existingReason);
    }
}

