/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.task;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.api.model.longtasks.LongTaskId;
import com.atlassian.confluence.api.model.longtasks.LongTaskStatus;
import com.atlassian.confluence.api.model.messages.Message;
import com.atlassian.confluence.api.model.messages.SimpleMessage;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.midori.confluence.plugin.archiving.model.type.PageViewInitializationType;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.ContentArchivingManager;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentEventDataProvider;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentEventIndexer;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.service.persistence.ContentQualityStatsManager;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleStatusHelper;
import com.midori.confluence.plugin.archiving.service.support.PluginHelper;
import com.midori.confluence.plugin.archiving.service.support.SpaceHelper;
import com.midori.confluence.plugin.archiving.service.support.SqlHelper;
import com.midori.confluence.plugin.archiving.service.task.ContentArchivingLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.ContentEventIndexerLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskResultManager;
import com.midori.confluence.plugin.archiving.service.task.ContentQualityAnalyzerLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.ProxyLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.base.AbstractArchivingLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.base.ArchivingLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.model.LongRunningTaskControl;
import com.midori.confluence.plugin.archiving.service.task.model.LongRunningTaskDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ContentLifecycleLongRunningTaskManager {
    private static Logger log = LoggerFactory.getLogger(ContentLifecycleLongRunningTaskManager.class);
    private static final String CLUSTER_WIDE_LOCK_NAME = "carch.currentLongRunningTask.lock";
    private static final String CLUSTER_WIDE_CACHE_NAME = "Archiving Plugin: Cluster-wide Long Running Tasks";
    private static final String CLUSTER_WIDE_CURRENT_TASK_DESCRIPTOR_KEY = "carch.currentLongRunningTask.descriptor";
    private static final String CLUSTER_WIDE_CURRENT_TASK_CONTROL_KEY = "carch.currentLongRunningTask.control";
    private ClusterLockService clusterLockService;
    private LongRunningTaskManager longRunningTaskManager;
    private PageManager pageManager;
    private SpaceManager spaceManager;
    private TransactionTemplate transactionTemplate;
    private ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private ContentArchivingManager contentArchivingManager;
    private ContentEventDataProvider contentEventDataProvider;
    private ContentLifecycleActorHelper contentLifecycleActorHelper;
    private ContentLifecycleStatusHelper contentLifecycleStatusHelper;
    private ContentQualityStatsManager contentQualityStatsManager;
    private ContentEventIndexer contentEventIndexer;
    private ContentLifecycleLongRunningTaskResultManager contentLifecycleLongRunningTaskResultManager;
    private PluginHelper pluginHelper;
    private SpaceHelper spaceHelper;
    private SqlHelper sqlHelper;
    private ObjectMapper jsonMapper = new ObjectMapper();
    private final Cache<String, String> clusterWideCache;
    private final ClusterNodeInformation clusterNodeInformation;
    private Set<LongRunningTaskId> historicalTaskIds = new HashSet<LongRunningTaskId>();
    private static Predicate<LongTaskStatus> runningTaskPredicate = longTaskStatus -> longTaskStatus != null && longTaskStatus.getPercentageComplete() < 100 && longTaskStatus.isSuccessful();

    public ContentLifecycleLongRunningTaskManager(CacheManager cacheManager, ClusterLockService clusterLockService, ClusterManager clusterManager, LongRunningTaskManager longRunningTaskManager, PageManager pageManager, SpaceManager spaceManager, TransactionTemplate transactionTemplate, ContentArchivingConfigurationManager contentArchivingConfigurationManager, ContentArchivingManager contentArchivingManager, ContentEventDataProvider contentEventDataProvider, ContentLifecycleActorHelper contentLifecycleActorHelper, ContentLifecycleStatusHelper contentLifecycleStatusHelper, ContentQualityStatsManager contentQualityStatsManager, ContentEventIndexer contentEventIndexer, ContentLifecycleLongRunningTaskResultManager contentLifecycleLongRunningTaskResultManager, PluginHelper pluginHelper, SpaceHelper spaceHelper, SqlHelper sqlHelper) {
        this.clusterLockService = clusterLockService;
        this.longRunningTaskManager = longRunningTaskManager;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.transactionTemplate = transactionTemplate;
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
        this.contentArchivingManager = contentArchivingManager;
        this.contentEventDataProvider = contentEventDataProvider;
        this.contentLifecycleActorHelper = contentLifecycleActorHelper;
        this.contentLifecycleStatusHelper = contentLifecycleStatusHelper;
        this.contentQualityStatsManager = contentQualityStatsManager;
        this.contentEventIndexer = contentEventIndexer;
        this.contentLifecycleLongRunningTaskResultManager = contentLifecycleLongRunningTaskResultManager;
        this.pluginHelper = pluginHelper;
        this.spaceHelper = spaceHelper;
        this.sqlHelper = sqlHelper;
        this.jsonMapper.setVisibilityChecker((VisibilityChecker<?>)this.jsonMapper.getVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
        this.clusterWideCache = cacheManager.getCache(CLUSTER_WIDE_CACHE_NAME, null, new CacheSettingsBuilder().expireAfterAccess(24L, TimeUnit.HOURS).build());
        this.clusterNodeInformation = clusterManager.getThisNodeInformation();
    }

    public LongRunningTask getTask(LongRunningTaskId taskId) {
        return this.longRunningTaskManager.getLongRunningTask(this.findActorUser(), taskId);
    }

    public LongRunningTask getTask(String taskId) {
        return this.getTask(LongRunningTaskId.valueOf((String)taskId));
    }

    public Optional<ArchivingLongRunningTask> getCurrentlyRunningTask() {
        Collection currentlyRunningTasks = this.getTrackedTasks().stream().filter(runningTaskPredicate).collect(Collectors.toList());
        log.debug(String.format("%d running local tasks found", currentlyRunningTasks.size()));
        if (!currentlyRunningTasks.isEmpty()) {
            ArchivingLongRunningTask archivingTask;
            LongTaskStatus taskStatus = (LongTaskStatus)ModelUtils.firstElement(currentlyRunningTasks);
            LongRunningTaskId taskId = LongRunningTaskId.from((LongTaskId)taskStatus.getId());
            LongRunningTask task = this.getTask(taskId);
            try {
                archivingTask = (ArchivingLongRunningTask)task;
            }
            catch (ClassCastException ex) {
                log.debug(String.format("Converting running task \"%s\" (started by a previous app version) to a ghost task", task.getName()));
                String ghostTaskName = String.format("%s (ghost)", task.getName());
                Optional ghostTaskSpace = (Optional)ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod((Class)task.getClass(), (String)"getSpace", null), (Object)task);
                archivingTask = ContentLifecycleLongRunningTaskManager.createGhostTask(taskId, ghostTaskName, ghostTaskSpace);
            }
            log.debug(String.format("Task \"%s\" is running %s with ID <%s>", archivingTask.getName(), archivingTask.getSpace().isPresent() ? "on " + archivingTask.getSpace().get().getKey() : "globally", taskId));
            return Optional.of(archivingTask);
        }
        if (!this.isClusterWideLockAvailable()) {
            String realNodeName;
            LongRunningTaskDescriptor realTaskDescriptor = this.getCurrentlyRunningTaskDescriptor();
            String string = realNodeName = realTaskDescriptor != null ? realTaskDescriptor.getNodeName() : null;
            if (realNodeName != null) {
                String currentNodeName = this.getNodeName();
                if (!currentNodeName.equals(realNodeName)) {
                    ProxyLongRunningTask task = this.createProxyTask();
                    LongRunningTaskId taskId = this.startTask(task);
                    log.debug(String.format("Proxy task started with ID <%s>", taskId));
                    return Optional.of(task);
                }
                log.debug("Proxy task not started as cluster-wide lock is acquired by the current node (real task is possibly shutting down)");
            } else {
                log.debug("Proxy task not started as cluster-wide lock is acquired by an unknown real node");
            }
        }
        log.debug("0 running cluster-wide tasks found");
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongRunningTaskId startTask(AbstractArchivingLongRunningTask task) {
        boolean startable;
        boolean bl = startable = this.isClusterWideLockAvailable() || task instanceof ProxyLongRunningTask;
        if (startable) {
            LongRunningTaskId taskId = this.longRunningTaskManager.startLongRunningTask(this.findActorUser(), (LongRunningTask)task);
            task.setTaskId(taskId.toString());
            Set<LongRunningTaskId> set = this.historicalTaskIds;
            synchronized (set) {
                this.historicalTaskIds.add(taskId);
            }
            return taskId;
        }
        return null;
    }

    public void stopRunningTaskGracefully() {
        LongRunningTaskControl control = this.getCurrentlyRunningTaskControl();
        if (control != null) {
            log.debug("Requesting graceful stop of the currently running task");
            control.requestGracefulStop();
            this.putCurrentlyRunningTaskControl(control);
        } else {
            log.warn("No control for the currently running task found, nothing to stop");
        }
    }

    public void untrackFinishedTasks() {
        Collection finishedTasks = this.getTrackedTasks().stream().filter(Predicates.not(runningTaskPredicate)).collect(Collectors.toList());
        log.debug(String.format("Untracking %d finished tasks", finishedTasks.size()));
        this.untrackTasks(finishedTasks);
        log.debug(String.format("%d finished tasks untracked", finishedTasks.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<LongTaskStatus> getTrackedTasks() {
        Set<LongRunningTaskId> set = this.historicalTaskIds;
        synchronized (set) {
            HashSet<LongTaskStatus> taskStatuses = new HashSet<LongTaskStatus>(this.historicalTaskIds.size());
            for (LongRunningTaskId taskId : this.historicalTaskIds) {
                LongRunningTask task = this.getTask(taskId);
                if (task == null) continue;
                LongTaskStatus taskStatus = ContentLifecycleLongRunningTaskManager.buildStatus(taskId.asLongTaskId(), task);
                taskStatuses.add(taskStatus);
            }
            log.trace(String.format("%s tracked tasks found (%d historical tasks ever started)", taskStatuses.size(), this.historicalTaskIds.size()));
            return taskStatuses;
        }
    }

    private static LongTaskStatus buildStatus(LongTaskId id, LongRunningTask task) {
        String nameKey = task.getNameKey();
        SimpleMessage name = Strings.isNullOrEmpty(nameKey) ? SimpleMessage.withTranslation((String)task.getName()) : SimpleMessage.withKeyAndArgs((String)nameKey, (Object[])new Object[0]);
        SimpleMessage message = SimpleMessage.withTranslation((String)task.getCurrentStatus());
        return LongTaskStatus.builder((LongTaskId)id).name((Message)name).elapsedTime(task.getElapsedTime()).percentageComplete(task.getPercentageComplete()).addMessage((Message)message).successful(task.isSuccessful()).build();
    }

    private void untrackTasks(Collection<LongTaskStatus> tasks) {
        for (LongTaskStatus task : tasks) {
            if (task == null) continue;
            log.debug(String.format("Untracking task <%s>", LongRunningTaskId.from((LongTaskId)task.getId())));
            this.longRunningTaskManager.stopTrackingLongRunningTask(LongRunningTaskId.from((LongTaskId)task.getId()));
        }
    }

    private ConfluenceUser findActorUser() {
        Set<ConfluenceUser> actors = this.contentLifecycleActorHelper.findArchivingActorCandidates();
        if (actors.isEmpty()) {
            throw new IllegalStateException("No archiving actor candidates found");
        }
        return ModelUtils.firstElement(actors);
    }

    private String getNodeName() {
        return this.clusterNodeInformation != null ? String.format("%s (%s)", this.clusterNodeInformation.getAnonymizedNodeIdentifier(), this.clusterNodeInformation.humanReadableNodeName().orElse("")) : "<single node>";
    }

    public boolean isClusterWideLockAvailable() {
        ClusterLock lock = this.getClusterWideLock();
        boolean isLockAvailable = lock.tryLock();
        if (isLockAvailable) {
            lock.unlock();
        }
        return isLockAvailable;
    }

    public ClusterLock getClusterWideLock() {
        ClusterLock lock = this.clusterLockService.getLockForName(CLUSTER_WIDE_LOCK_NAME);
        return lock;
    }

    public LongRunningTaskDescriptor getCurrentlyRunningTaskDescriptor() {
        return this.getFromCache(CLUSTER_WIDE_CURRENT_TASK_DESCRIPTOR_KEY, "task descriptor", LongRunningTaskDescriptor.class);
    }

    public void putCurrentlyRunningTaskDescriptor(LongRunningTaskDescriptor descriptor) {
        this.putToCache(CLUSTER_WIDE_CURRENT_TASK_DESCRIPTOR_KEY, descriptor, "task descriptor");
    }

    public LongRunningTaskControl getCurrentlyRunningTaskControl() {
        return this.getFromCache(CLUSTER_WIDE_CURRENT_TASK_CONTROL_KEY, "task control", LongRunningTaskControl.class);
    }

    public void putCurrentlyRunningTaskControl(LongRunningTaskControl control) {
        this.putToCache(CLUSTER_WIDE_CURRENT_TASK_CONTROL_KEY, control, "task control");
    }

    private <T> T getFromCache(String key, String description, Class<T> entryClass) {
        log.trace("Getting cluster-wide " + description);
        T entry = null;
        try {
            String json = (String)this.clusterWideCache.get((Object)key);
            if (json != null) {
                entry = this.jsonMapper.readValue(json, entryClass);
            }
        }
        catch (IOException e) {
            log.error(String.format("Failed to get cluster-wide %s from the cache", description), (Throwable)e);
        }
        return entry;
    }

    private <T> void putToCache(String key, T entry, String description) {
        log.trace(String.format("Updating cluster-wide %s with: %s", description, entry));
        try {
            String json = this.jsonMapper.writeValueAsString(entry);
            this.clusterWideCache.put((Object)key, (Object)json);
        }
        catch (IOException e) {
            log.error(String.format("Failed to put cluster-wide %s to the cache", description), (Throwable)e);
        }
    }

    public ContentEventIndexerLongRunningTask createGlobalContentEventIndexerLongRunningTask(PageViewInitializationType pageViewInitializationType, Date pageViewInitialDate) {
        return new ContentEventIndexerLongRunningTask(this.pageManager, this.spaceManager, this.transactionTemplate, this, this.contentArchivingManager, this.contentLifecycleActorHelper, this.contentLifecycleStatusHelper, this.contentLifecycleLongRunningTaskResultManager, this.pluginHelper, this.spaceHelper, this.sqlHelper, Optional.empty(), this.getNodeName(), this.contentEventIndexer, pageViewInitializationType, pageViewInitialDate);
    }

    public ContentEventIndexerLongRunningTask createSpaceScopedContentEventIndexerLongRunningTask(Space space, PageViewInitializationType pageViewInitializationType, Date pageViewInitialDate) {
        return new ContentEventIndexerLongRunningTask(this.pageManager, this.spaceManager, this.transactionTemplate, this, this.contentArchivingManager, this.contentLifecycleActorHelper, this.contentLifecycleStatusHelper, this.contentLifecycleLongRunningTaskResultManager, this.pluginHelper, this.spaceHelper, this.sqlHelper, Optional.of(space), this.getNodeName(), this.contentEventIndexer, pageViewInitializationType, pageViewInitialDate);
    }

    public ContentQualityAnalyzerLongRunningTask createGlobalContentQualityAnalyzerLongRunningTask() {
        return new ContentQualityAnalyzerLongRunningTask(this.pageManager, this.spaceManager, this.transactionTemplate, this, this.contentArchivingManager, this.contentLifecycleActorHelper, this.contentLifecycleStatusHelper, this.contentLifecycleLongRunningTaskResultManager, this.pluginHelper, this.spaceHelper, this.sqlHelper, Optional.empty(), this.getNodeName(), this.contentEventDataProvider, this.contentQualityStatsManager);
    }

    public ContentQualityAnalyzerLongRunningTask createSpaceScopedContentQualityAnalyzerLongRunningTask(Space space) {
        return new ContentQualityAnalyzerLongRunningTask(this.pageManager, this.spaceManager, this.transactionTemplate, this, this.contentArchivingManager, this.contentLifecycleActorHelper, this.contentLifecycleStatusHelper, this.contentLifecycleLongRunningTaskResultManager, this.pluginHelper, this.spaceHelper, this.sqlHelper, Optional.of(space), this.getNodeName(), this.contentEventDataProvider, this.contentQualityStatsManager);
    }

    public ContentArchivingLongRunningTask createGlobalContentArchivingLongRunningTask() {
        return new ContentArchivingLongRunningTask(this.pageManager, this.spaceManager, this.transactionTemplate, this, this.contentArchivingManager, this.contentLifecycleActorHelper, this.contentLifecycleStatusHelper, this.contentLifecycleLongRunningTaskResultManager, this.pluginHelper, this.spaceHelper, this.sqlHelper, Optional.empty(), this.getNodeName(), this.contentArchivingConfigurationManager);
    }

    public ContentArchivingLongRunningTask createSpaceScopedContentArchivingLongRunningTask(Space space) {
        return new ContentArchivingLongRunningTask(this.pageManager, this.spaceManager, this.transactionTemplate, this, this.contentArchivingManager, this.contentLifecycleActorHelper, this.contentLifecycleStatusHelper, this.contentLifecycleLongRunningTaskResultManager, this.pluginHelper, this.spaceHelper, this.sqlHelper, Optional.of(space), this.getNodeName(), this.contentArchivingConfigurationManager);
    }

    private static ArchivingLongRunningTask createGhostTask(final LongRunningTaskId taskId, final String name, final Optional<Space> space) {
        return new ArchivingLongRunningTask(){

            @Override
            public String getTaskId() {
                return taskId.toString();
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Optional<Space> getSpace() {
                return space;
            }

            @Override
            public boolean isSpaceScoped() {
                return space.isPresent();
            }
        };
    }

    private ProxyLongRunningTask createProxyTask() {
        return new ProxyLongRunningTask(this.pageManager, this.spaceManager, this.transactionTemplate, this, this.contentArchivingManager, this.contentLifecycleActorHelper, this.contentLifecycleStatusHelper, this.contentLifecycleLongRunningTaskResultManager, this.pluginHelper, this.spaceHelper, this.sqlHelper, this.getNodeName());
    }
}

