/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support.reduce;

import com.atlassian.confluence.pages.Page;
import com.google.common.collect.Multimap;
import com.midori.confluence.plugin.archiving.model.PageArchiving;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.support.DateTimeProvider;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPage;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPageArchiving;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightSpace;
import com.midori.confluence.plugin.archiving.util.limited.LimitedList;
import com.midori.confluence.plugin.archiving.util.limited.LimitedMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataReducer {
    private static Logger log = LoggerFactory.getLogger(DataReducer.class);
    private static final Comparator<LightSpace> SPACE_COMPARATOR = new LightSpaceByNameComparator();
    private static final Comparator<LightPage> PAGE_COMPARATOR = new LightPageByNameComparator();

    public static <T> LimitedMap<LightSpace, LimitedMap<LightPage, T>> limitSpaceKeyedPageKeyedMap(Map<LightSpace, Map<LightPage, T>> spacesToPageKeyedMaps, int maxSpaces, int maxPagesPerSpace) {
        LimitedMap<LightSpace, LimitedMap<LightPage, T>> limitedSpacesToPageKeyedMaps = new LimitedMap<LightSpace, LimitedMap<LightPage, T>>(new LinkedHashMap(maxSpaces), maxSpaces);
        int totalCount = ModelUtils.getMapValuedMapSize(spacesToPageKeyedMaps);
        int limitedTotalCount = 0;
        long start = DateTimeProvider.currentTimeMillis();
        TreeSet<LightSpace> sortedSpaces = new TreeSet<LightSpace>(SPACE_COMPARATOR);
        sortedSpaces.addAll(spacesToPageKeyedMaps.keySet());
        for (LightSpace space : sortedSpaces) {
            Map<LightPage, T> pageKeyedMap = spacesToPageKeyedMaps.get(space);
            TreeSet<LightPage> sortedPages = new TreeSet<LightPage>(PAGE_COMPARATOR);
            sortedPages.addAll(pageKeyedMap.keySet());
            LimitedMap<LightPage, T> limitedPageKeyedMap = new LimitedMap<LightPage, T>(new LinkedHashMap(maxPagesPerSpace), maxPagesPerSpace);
            limitedSpacesToPageKeyedMaps.put(space, limitedPageKeyedMap);
            for (LightPage page : sortedPages) {
                limitedPageKeyedMap.put(page, pageKeyedMap.get(page));
            }
            limitedTotalCount += limitedPageKeyedMap.size();
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("%d pages limited to %d in %d s (limits: %d/%d, remaining spaces: %d)", totalCount, limitedTotalCount, (DateTimeProvider.currentTimeMillis() - start) / 1000L, maxSpaces, maxPagesPerSpace, limitedSpacesToPageKeyedMaps.getRemainingCount()));
        }
        return limitedSpacesToPageKeyedMaps;
    }

    public static <T> LimitedMap<LightSpace, LimitedList<Long>> limitFlattenSpaceKeyedPageKeyedMap(Map<LightSpace, Map<LightPage, T>> spacesToPageKeyedMaps, int maxSpaces, int maxPagesPerSpace) {
        LimitedMap<LightSpace, LimitedList<Long>> limitedSpacesToPageIds = new LimitedMap<LightSpace, LimitedList<Long>>(new LinkedHashMap(maxSpaces), maxSpaces);
        int totalCount = ModelUtils.getMapValuedMapSize(spacesToPageKeyedMaps);
        int limitedTotalCount = 0;
        long start = DateTimeProvider.currentTimeMillis();
        TreeSet<LightSpace> sortedSpaces = new TreeSet<LightSpace>(SPACE_COMPARATOR);
        sortedSpaces.addAll(spacesToPageKeyedMaps.keySet());
        for (LightSpace space : sortedSpaces) {
            TreeSet<LightPage> sortedPages = new TreeSet<LightPage>(PAGE_COMPARATOR);
            sortedPages.addAll(spacesToPageKeyedMaps.get(space).keySet());
            LimitedList<Long> limitedPageIds = new LimitedList<Long>(new ArrayList(maxPagesPerSpace), maxPagesPerSpace);
            limitedSpacesToPageIds.put(space, limitedPageIds);
            for (LightPage page : sortedPages) {
                limitedPageIds.add(page.getId());
            }
            limitedTotalCount += limitedPageIds.size();
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("%d page IDs limited to %d in %d s (limits: %d/%d, remaining spaces: %d)", totalCount, limitedTotalCount, (DateTimeProvider.currentTimeMillis() - start) / 1000L, maxSpaces, maxPagesPerSpace, limitedSpacesToPageIds.getRemainingCount()));
        }
        return limitedSpacesToPageIds;
    }

    public static LimitedMap<LightSpace, LimitedList<LightPage>> limitSpaceKeyedPageMultimap(Multimap<LightSpace, LightPage> spacesToPagesMultimap, int maxSpaces, int maxPagesPerSpace) {
        LimitedMap<LightSpace, LimitedList<LightPage>> limitedSpacesToPages = new LimitedMap<LightSpace, LimitedList<LightPage>>(new LinkedHashMap(maxSpaces), maxSpaces);
        int totalCount = spacesToPagesMultimap.entries().size();
        int limitedTotalCount = 0;
        long start = DateTimeProvider.currentTimeMillis();
        TreeSet<LightSpace> sortedSpaces = new TreeSet<LightSpace>(SPACE_COMPARATOR);
        sortedSpaces.addAll(spacesToPagesMultimap.keySet());
        for (LightSpace space : sortedSpaces) {
            TreeSet<LightPage> sortedPages = new TreeSet<LightPage>(PAGE_COMPARATOR);
            sortedPages.addAll(spacesToPagesMultimap.get(space));
            LimitedList<LightPage> limitedPages = new LimitedList<LightPage>(new ArrayList(maxPagesPerSpace), maxPagesPerSpace);
            limitedSpacesToPages.put(space, limitedPages);
            limitedPages.addAll(sortedPages);
            limitedTotalCount += limitedPages.size();
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("%d pages limited to %d in %d s (limits: %d/%d, remaining spaces: %d)", totalCount, limitedTotalCount, (DateTimeProvider.currentTimeMillis() - start) / 1000L, maxSpaces, maxPagesPerSpace, limitedSpacesToPages.getRemainingCount()));
        }
        return limitedSpacesToPages;
    }

    public static <T> Map<LightPage, T> lightenPageKeyedMap(Map<Page, T> pageKeyedPageArchivingMap) {
        LinkedHashMap<LightPage, T> lightPageKeyedPageArchivingMap = new LinkedHashMap<LightPage, T>(pageKeyedPageArchivingMap.size());
        for (Map.Entry<Page, T> entry : pageKeyedPageArchivingMap.entrySet()) {
            lightPageKeyedPageArchivingMap.put(LightPage.fromPage(entry.getKey()), entry.getValue());
        }
        return lightPageKeyedPageArchivingMap;
    }

    public static Map<LightPage, LightPageArchiving> lightenPageKeyedPageArchivingMap(Map<Page, PageArchiving> pageKeyedPageArchivingMap) {
        LinkedHashMap<LightPage, LightPageArchiving> lightPageKeyedPageArchivingMap = new LinkedHashMap<LightPage, LightPageArchiving>(pageKeyedPageArchivingMap.size());
        for (Map.Entry<Page, PageArchiving> entry : pageKeyedPageArchivingMap.entrySet()) {
            lightPageKeyedPageArchivingMap.put(LightPage.fromPage(entry.getKey()), LightPageArchiving.fromPageArchiving(entry.getValue()));
        }
        return lightPageKeyedPageArchivingMap;
    }

    private static class LightSpaceByNameComparator
    implements Comparator<LightSpace> {
        private LightSpaceByNameComparator() {
        }

        @Override
        public int compare(LightSpace o1, LightSpace o2) {
            int result = ModelUtils.safeCompareStrings(o1.getName(), o2.getName());
            if (result != 0) {
                return result;
            }
            return ModelUtils.safeCompareStrings(o1.getKey(), o2.getKey());
        }
    }

    private static class LightPageByNameComparator
    implements Comparator<LightPage> {
        private LightPageByNameComparator() {
        }

        @Override
        public int compare(LightPage o1, LightPage o2) {
            int result = ModelUtils.safeCompareStrings(o1.getTitle(), o2.getTitle());
            if (result != 0) {
                return result;
            }
            return Long.compare(o1.getId(), o2.getId());
        }
    }
}

