/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support;

import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class SqlHelper {
    private static Logger log = LoggerFactory.getLogger(SqlHelper.class);
    private final TransactionalExecutorFactory transactionalExecutorFactory = (TransactionalExecutorFactory)ComponentLocator.getComponent(TransactionalExecutorFactory.class);
    private Object pluginHibernateSessionFactory;
    private TransactionTemplate transactionTemplate;

    public SqlHelper(TransactionTemplate transactionTemplate) throws ClassNotFoundException {
        if (this.transactionalExecutorFactory == null) {
            Class<?> pluginHibernateSessionFactoryClass = Class.forName("com.atlassian.hibernate.PluginHibernateSessionFactory");
            this.pluginHibernateSessionFactory = ComponentLocator.getComponent(pluginHibernateSessionFactoryClass);
            this.transactionTemplate = transactionTemplate;
        }
        if (this.transactionalExecutorFactory == null && (this.transactionTemplate == null || this.pluginHibernateSessionFactory == null)) {
            throw new RuntimeException("Failed to resolve SqlHelper dependencies");
        }
    }

    public int executeCountQuery(String query) {
        if (this.transactionalExecutorFactory != null) {
            return (Integer)this.transactionalExecutorFactory.createExecutor().readOnly().execute(connection -> SqlHelper.getCountForQuery(connection, query));
        }
        return (Integer)this.transactionTemplate.execute(() -> {
            try {
                Connection connection = this.getConnection();
                return SqlHelper.getCountForQuery(connection, query);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to execute SQL query", e);
            }
        });
    }

    @Deprecated
    private Connection getConnection() {
        Method getSessionMethod = ReflectionUtils.findMethod(this.pluginHibernateSessionFactory.getClass(), (String)"getSession", null);
        Object session = ReflectionUtils.invokeMethod((Method)getSessionMethod, (Object)this.pluginHibernateSessionFactory);
        Method connectionMethod = ReflectionUtils.findMethod(session.getClass(), (String)"connection", null);
        return (Connection)ReflectionUtils.invokeMethod((Method)connectionMethod, (Object)session);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static int getCountForQuery(Connection connection, String query) {
        try (Statement st = connection.createStatement();){
            int n;
            block18: {
                ResultSet rs;
                block16: {
                    int n2;
                    block17: {
                        rs = st.executeQuery(query);
                        try {
                            if (rs.next()) break block16;
                            log.warn("Unable to execute usage info query: no data returned.");
                            n2 = -1;
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return n2;
                }
                n = rs.getInt(1);
                if (rs == null) break block18;
                rs.close();
            }
            return n;
        }
        catch (SQLException e) {
            log.warn("Unable to execute usage info query: " + query + " - " + e.getMessage(), (Throwable)e);
            return -1;
        }
    }
}

