/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.midori.confluence.plugin.archiving.service.persistence.GlobalSettingsManager_;
import com.midori.confluence.plugin.archiving.service.task.base.ArchivingLongRunningTask;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentLifecyclePermissionHelper {
    private static Logger log = LoggerFactory.getLogger(ContentLifecyclePermissionHelper.class);
    private GlobalSettingsManager_ globalSettingsManager;
    private GroupManager groupManager;
    private PermissionManager permissionManager;

    public ContentLifecyclePermissionHelper(GlobalSettingsManager_ globalSettingsManager, GroupManager groupManager, PermissionManager permissionManager) {
        this.globalSettingsManager = globalSettingsManager;
        this.groupManager = groupManager;
        this.permissionManager = permissionManager;
    }

    public boolean canAdministerConfluence(ConfluenceUser user) {
        return this.permissionManager.isConfluenceAdministrator(user);
    }

    public boolean canAdministerConfluence() {
        return this.canAdministerConfluence(this.getAuthenticatedUser());
    }

    public boolean canBuildContentUpdateIndex() {
        return this.canAdministerConfluence();
    }

    public boolean canBuildContentUpdateIndex(Space space) {
        return this.canViewSpaceAdministration(space);
    }

    public boolean canManageGlobalConfigurations() {
        return this.canAdministerConfluence();
    }

    public boolean canViewSpaceAdministration(Space space) {
        ConfluenceUser user = this.getAuthenticatedUser();
        return this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)space);
    }

    public boolean canAdministerSpace(Space space) {
        ConfluenceUser user = this.getAuthenticatedUser();
        Group trustedGroup = this.getTrustedGroup();
        try {
            boolean isTrusted = trustedGroup == null || this.groupManager.hasMembership(trustedGroup, (User)user);
            return this.canViewSpaceAdministration(space) && isTrusted;
        }
        catch (EntityException ex) {
            log.error(String.format("Failed to check the membership of <%s> in trusted group <%s>", user.getName(), trustedGroup.getName()), (Throwable)ex);
            return false;
        }
    }

    public boolean canStopTask(ArchivingLongRunningTask task) {
        return task.isSpaceScoped() ? this.canAdministerSpace(task.getSpace().get()) : this.canAdministerConfluence();
    }

    private ConfluenceUser getAuthenticatedUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    private Group getTrustedGroup() {
        String trustedGroup = this.globalSettingsManager.getGlobalSettings().getTrustedGroup();
        if (StringUtils.isBlank((CharSequence)trustedGroup)) {
            return null;
        }
        try {
            Group group = this.groupManager.getGroup(trustedGroup);
            if (group == null) {
                log.warn(String.format("Trusted group <%s> not found, ignoring it. Check your global settings.", trustedGroup));
            }
            return group;
        }
        catch (EntityException ex) {
            log.error(String.format("Failed to find trusted group <%s>", trustedGroup), (Throwable)ex);
            return null;
        }
    }
}

