/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.strategy.replication;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.google.common.collect.ImmutableSet;
import com.midori.confluence.plugin.archiving.service.strategy.replication.PageReplicator;
import com.midori.confluence.plugin.archiving.service.strategy.replication.ReplicationUtils;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SpaceReplicator {
    private SpaceManager spaceManager;
    private SpacePermissionManager spacePermissionManager;
    private PageReplicator pageReplicator;
    private static Set<String> READ_PERMISSION_TYPES = ImmutableSet.of("VIEWSPACE", "EXPORTSPACE", "SETSPACEPERMISSIONS");

    public SpaceReplicator(SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, PageReplicator pageReplicator) {
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
        this.pageReplicator = pageReplicator;
    }

    public Space replicate(String spaceKey, String newSpaceKey, String newSpaceName) {
        Space space = this.spaceManager.getSpace(spaceKey);
        Space newSpace = this.spaceManager.createSpace(newSpaceKey, newSpaceName, space.getDescription().getBodyAsString(), AuthenticatedUserThreadLocal.get());
        if (newSpace == null || newSpace.getId() <= 0L || StringUtils.isBlank((CharSequence)newSpace.getKey())) {
            throw new IllegalStateException(String.format("Archive space created for <%s> is NULL or has zero ID or has blank key", spaceKey));
        }
        ReplicationUtils.copyConfluenceEntityObjectProperties((ConfluenceEntityObject)space, (ConfluenceEntityObject)newSpace);
        this.spaceManager.saveSpace(newSpace);
        Page homePage = newSpace.getHomePage();
        if (homePage != null) {
            this.pageReplicator.silentlyRemove(homePage);
        }
        this.copyReadPermissions(space, newSpace);
        return newSpace;
    }

    public void hide(Space archiveSpace) {
        this.spaceManager.archiveSpace(archiveSpace);
    }

    private void copyReadPermissions(Space fromSpace, Space toSpace) {
        this.spacePermissionManager.removeAllPermissions(toSpace);
        this.setPermissionsForSpace(toSpace, this.getCopiableReadPermissionsBySpace(fromSpace));
    }

    private Collection<SpacePermission> getCopiableReadPermissionsBySpace(Space fromSpace) {
        return fromSpace.getPermissions().stream().filter(spacePermission -> {
            boolean isReadPermission = READ_PERMISSION_TYPES.contains(spacePermission.getType());
            return !spacePermission.isAnonymousPermission() && !spacePermission.isAuthenticatedUsersPermission() && isReadPermission;
        }).collect(Collectors.toList());
    }

    private void setPermissionsForSpace(Space toSpace, Collection<SpacePermission> permissions) {
        for (SpacePermission permission : permissions) {
            SpacePermission newPermission = new SpacePermission(permission);
            newPermission.setSpace(toSpace);
            ReplicationUtils.copyConfluenceEntityObjectProperties((ConfluenceEntityObject)permission, (ConfluenceEntityObject)newPermission);
            this.spacePermissionManager.savePermission(newPermission);
        }
    }
}

