/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.strategy.replication;

import com.atlassian.confluence.content.ContentProperties;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Comment;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

abstract class ReplicationUtils {
    private static Logger log = LoggerFactory.getLogger(ReplicationUtils.class);

    ReplicationUtils() {
    }

    static void copyConfluenceEntityObjectProperties(ConfluenceEntityObject from, ConfluenceEntityObject to) {
        to.setCreationDate(from.getCreationDate());
        to.setLastModificationDate(from.getLastModificationDate());
        to.setCreator(from.getCreator());
        to.setLastModifier(from.getLastModifier());
        if (from instanceof Comment && to instanceof Comment) {
            ReplicationUtils.setContentPropertiesFrom((ContentEntityObject)((Comment)from), (ContentEntityObject)((Comment)to));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countInputStreamBytes(InputStream in) {
        NullOutputStream out = new NullOutputStream();
        try {
            int copied = FileCopyUtils.copy((InputStream)in, (OutputStream)out);
            long l = copied;
            return l;
        }
        catch (IOException ex) {
            log.error("Failed to count input stream bytes", (Throwable)ex);
            long l = -1L;
            return l;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    static void setContentPropertiesFrom(ContentEntityObject from, ContentEntityObject to) {
        List savedProperties = to.getProperties().asList();
        savedProperties.clear();
        savedProperties.addAll(ContentProperties.deepClone((ContentProperties)from.getProperties()).asList());
    }
}

