/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.strategy.impl;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.midori.confluence.plugin.archiving.model.PageArchiving;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingExecutionContext;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingExecutionSpecification;
import com.midori.confluence.plugin.archiving.service.strategy.impl.AbstractReplicatingArchivingStrategy;
import com.midori.confluence.plugin.archiving.service.strategy.replication.PageReplicator;
import com.midori.confluence.plugin.archiving.service.strategy.replication.SpaceReplicator;
import com.midori.confluence.plugin.archiving.service.support.ContentTraversalHelper;
import com.midori.confluence.plugin.archiving.service.support.SpaceHelper;
import com.midori.confluence.plugin.archiving.service.task.control.TaskControlTracker;
import com.midori.confluence.plugin.archiving.service.task.progress.ProgressTracker;
import java.util.List;
import java.util.Map;

public class CopyAndTrashArchivingStrategy
extends AbstractReplicatingArchivingStrategy {
    public CopyAndTrashArchivingStrategy(SpaceManager spaceManager, PageManager pageManager, ContentTraversalHelper contentTraversalHelper, PageReplicator pageReplicator, SpaceReplicator spaceReplicator, SpaceHelper spaceHelper, ProgressTracker progressTracker, TaskControlTracker taskControlTracker) {
        super(spaceManager, pageManager, contentTraversalHelper, pageReplicator, spaceReplicator, spaceHelper, progressTracker, taskControlTracker);
    }

    @Override
    public boolean requiresSortedFreshPages(int pagesToArchiveCount) {
        return pagesToArchiveCount >= 100;
    }

    @Override
    protected void beforePageReplication(ContentArchivingExecutionSpecification specification, ContentArchivingExecutionContext context) {
    }

    @Override
    protected void replicatePage(ContentArchivingExecutionContext context, Page freshPageToArchive, Map<Page, PageArchiving> freshPagesToArchive, Space archiveSpace) {
        List<Page> freshBranch = this.contentTraversalHelper.findBranch(freshPageToArchive);
        this.replicateBranch(context, freshPageToArchive, freshBranch, freshPagesToArchive, archiveSpace.getKey(), null);
    }

    @Override
    protected void afterPageReplication(ContentArchivingExecutionSpecification specification, ContentArchivingExecutionContext context) {
        this.trashPages(context, context.getFreshPagesArchived());
    }
}

