/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.strategy.impl;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.PageArchiving;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingExecutionContext;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingExecutionSpecification;
import com.midori.confluence.plugin.archiving.service.strategy.impl.AbstractArchivingStrategy;
import com.midori.confluence.plugin.archiving.service.strategy.replication.PageReplicator;
import com.midori.confluence.plugin.archiving.service.strategy.replication.SpaceReplicator;
import com.midori.confluence.plugin.archiving.service.support.ContentTraversalHelper;
import com.midori.confluence.plugin.archiving.service.support.SpaceHelper;
import com.midori.confluence.plugin.archiving.service.task.control.TaskControlTracker;
import com.midori.confluence.plugin.archiving.service.task.progress.ProgressTracker;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReplicatingArchivingStrategy
extends AbstractArchivingStrategy {
    private static Logger log = LoggerFactory.getLogger(AbstractReplicatingArchivingStrategy.class);
    private SpaceHelper spaceHelper;

    public AbstractReplicatingArchivingStrategy(SpaceManager spaceManager, PageManager pageManager, ContentTraversalHelper contentTraversalHelper, PageReplicator pageReplicator, SpaceReplicator spaceReplicator, SpaceHelper spaceHelper, ProgressTracker progressTracker, TaskControlTracker taskControlTracker) {
        super(spaceManager, pageManager, contentTraversalHelper, pageReplicator, spaceReplicator, progressTracker, taskControlTracker);
        this.spaceHelper = spaceHelper;
    }

    @Override
    public void executeInternal(ContentArchivingExecutionSpecification specification, ContentArchivingExecutionContext context) {
        Optional<Space> archiveSpace = this.findOrCreateArchiveSpace(context, specification.getSpace(), specification.getConfiguration());
        if (!archiveSpace.isPresent()) {
            this.logError(context, String.format("Failed to find the archive space for <%s>", specification.getSpace().getKey()));
            return;
        }
        context.setArchiveSpace(archiveSpace.get());
        log.debug(String.format("Archive space found: <%s>", archiveSpace.get().getKey()));
        this.beforePageReplication(specification, context);
        Map<Page, PageArchiving> freshPagesToArchive = specification.getFreshPagesToArchive();
        this.progressTracker.setTotalObjects(freshPagesToArchive.size());
        int index = 0;
        for (Page freshPageToArchive : freshPagesToArchive.keySet()) {
            log.debug(String.format("Replicating fresh page <%s> (ID: %d)", freshPageToArchive.getTitle(), freshPageToArchive.getId()));
            this.replicatePage(context, freshPageToArchive, freshPagesToArchive, archiveSpace.get());
            this.progressTracker.setCurrentCount(++index);
            this.taskControlTracker.gracefulStopCheckpoint();
        }
        this.afterPageReplication(specification, context);
    }

    private Optional<Space> findOrCreateArchiveSpace(ContentArchivingExecutionContext context, Space freshSpace, ContentArchivingConfiguration configuration) {
        String archiveSpaceKey = SpaceHelper.getArchiveSpaceKeyBySpaceKey(freshSpace.getKey());
        Space archiveSpace = this.spaceHelper.findArchiveSpaceByFreshSpace(freshSpace.getKey());
        if (archiveSpace == null) {
            log.info(String.format("Creating archive space <%s> (for <%s>)", archiveSpaceKey, freshSpace.getKey()));
            String archiveSpaceName = SpaceHelper.getArchiveSpaceNameBySpaceName(freshSpace.getName());
            try {
                archiveSpace = this.spaceReplicator.replicate(freshSpace.getKey(), archiveSpaceKey, archiveSpaceName);
            }
            catch (Throwable t2) {
                this.logError(context, String.format("Failed to create archive space <%s> (for <%s>)", archiveSpaceKey, freshSpace.getKey()));
                return Optional.empty();
            }
        }
        if (configuration.isArchiveSpaceHidden() && !archiveSpace.isArchived()) {
            this.spaceReplicator.hide(archiveSpace);
        }
        return Optional.of(archiveSpace);
    }

    protected abstract void beforePageReplication(ContentArchivingExecutionSpecification var1, ContentArchivingExecutionContext var2);

    protected abstract void replicatePage(ContentArchivingExecutionContext var1, Page var2, Map<Page, PageArchiving> var3, Space var4);

    protected abstract void afterPageReplication(ContentArchivingExecutionSpecification var1, ContentArchivingExecutionContext var2);
}

