/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.persistence;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.midori.confluence.plugin.archiving.model.GlobalSettings;
import com.midori.confluence.plugin.archiving.model.ao.GlobalSettingsAo;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.java.ao.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalSettingsManager_ {
    private static Logger log = LoggerFactory.getLogger(GlobalSettingsManager_.class);
    private ActiveObjects ao;
    private static Comparator<GlobalSettingsAo> SETTINGS_AO_BY_ID_ASC_COMPARATOR = Comparator.comparingInt(Entity::getID);

    public GlobalSettingsManager_(ActiveObjects ao) {
        this.ao = ao;
    }

    public GlobalSettings getGlobalSettings() {
        return (GlobalSettings)this.ao.executeInTransaction(() -> {
            Optional<GlobalSettingsAo> globalSettingsAoOption = this.findGlobalSettingsAo();
            if (!globalSettingsAoOption.isPresent()) {
                GlobalSettings globalSettings = GlobalSettings.createDefault();
                this.save(globalSettings);
                return globalSettings;
            }
            return GlobalSettings.fromAo(globalSettingsAoOption.get());
        });
    }

    public int save(GlobalSettings settings) {
        return (Integer)this.ao.executeInTransaction(() -> {
            GlobalSettingsAo globalSettingsAo;
            Optional<GlobalSettingsAo> globalSettingsAoOption = this.findGlobalSettingsAo();
            if (!globalSettingsAoOption.isPresent()) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("TRUSTED_GROUP", settings.getTrustedGroup());
                params.put("DEFAULT_GLOBAL_CONFIG_ID", settings.getDefaultGlobalConfigurationId());
                globalSettingsAo = (GlobalSettingsAo)this.ao.create(GlobalSettingsAo.class, params);
            } else {
                globalSettingsAo = globalSettingsAoOption.get();
                globalSettingsAo.setTrustedGroup(settings.getTrustedGroup());
                globalSettingsAo.setDefaultGlobalConfigurationId(settings.getDefaultGlobalConfigurationId());
                globalSettingsAo.save();
            }
            return globalSettingsAo.getID();
        });
    }

    private Optional<GlobalSettingsAo> findGlobalSettingsAo() {
        List<GlobalSettingsAo> globalSettingsAos = Arrays.asList((GlobalSettingsAo[])this.ao.find(GlobalSettingsAo.class));
        if (globalSettingsAos.isEmpty()) {
            return Optional.empty();
        }
        if (globalSettingsAos.size() > 1) {
            globalSettingsAos.sort(SETTINGS_AO_BY_ID_ASC_COMPARATOR);
            log.warn(String.format("%d global settings found, using the oldest one. Open a support ticket at: https://bit.ly/1HebM1v", globalSettingsAos.size()));
        }
        return Optional.ofNullable(globalSettingsAos.get(0));
    }
}

