/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.eventindex.support;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.midori.confluence.plugin.archiving.model.ContentUpdate;
import com.midori.confluence.plugin.archiving.model.ContentView;
import com.midori.confluence.plugin.archiving.model.type.PageViewInitializationType;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentUpdateTracker;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentViewTracker;
import com.midori.confluence.plugin.archiving.service.task.control.TaskControlTracker;
import com.midori.confluence.plugin.archiving.service.task.progress.ProgressTracker;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentEventIndexInitializerVisitor {
    private static Logger log = LoggerFactory.getLogger(ContentEventIndexInitializerVisitor.class);
    private static final Date UNKNOWN_DATE = new Date(0L);
    private PageManager pageManager;
    private ContentUpdateTracker contentUpdateTracker;
    private ContentViewTracker contentViewTracker;
    private ProgressTracker progressTracker;
    private TaskControlTracker taskControlTracker;
    private Map<Page, ContentUpdate> pagesAndLastUpdates = new LinkedHashMap<Page, ContentUpdate>();

    public ContentEventIndexInitializerVisitor(PageManager pageManager, ContentUpdateTracker contentUpdateTracker, ContentViewTracker contentViewTracker, ProgressTracker progressTracker, TaskControlTracker taskControlTracker) {
        this.pageManager = pageManager;
        this.contentUpdateTracker = contentUpdateTracker;
        this.contentViewTracker = contentViewTracker;
        this.progressTracker = progressTracker;
        this.taskControlTracker = taskControlTracker;
    }

    public void visit(Space space, PageViewInitializationType pageViewInitializationType, Date pageViewInitialDate) {
        log.trace(String.format("Starting traversal on <%s> (page view initialization <%s> with date: %s)", new Object[]{space.getKey(), pageViewInitializationType, pageViewInitialDate}));
        List topLevelPages = this.pageManager.getTopLevelPages(space);
        for (Page topLevelPage : topLevelPages) {
            this.visitPage(topLevelPage, pageViewInitializationType, pageViewInitialDate);
        }
    }

    private Date visitPage(Page page, PageViewInitializationType pageViewInitializationType, Date pageViewInitialDate) {
        Date lastAttachmentUpdateDate;
        long pageId = page.getId();
        log.trace(String.format("Traversing page #%d \"%s\" (%s)", pageId, page.getTitle(), page.getLastModificationDate()));
        ContentUpdate lastUpdate = ContentUpdate.newPageEdited(page.getLastModifierName(), ContentEventIndexInitializerVisitor.getPageLastModificationDate(page));
        Optional<Pair<Attachment, Date>> lastAttachmentWithDate = ContentEventIndexInitializerVisitor.findLastAttachmentWithUpdateDate(page);
        if (lastAttachmentWithDate.isPresent() && (lastAttachmentUpdateDate = (Date)lastAttachmentWithDate.get().getRight()).after(lastUpdate.getUpdateDate())) {
            Attachment lastAttachment = (Attachment)lastAttachmentWithDate.get().getLeft();
            lastUpdate = ContentUpdate.newAttachmentAdded(lastAttachment.getLastModifierName(), lastAttachmentUpdateDate);
        }
        this.pagesAndLastUpdates.put(page, lastUpdate);
        List children = page.getSortedChildren();
        for (Object child : children) {
            Date lastChildUpdateDate = this.visitPage((Page)child, pageViewInitializationType, pageViewInitialDate);
            if (!lastChildUpdateDate.after(lastUpdate.getUpdateDate())) continue;
            ContentUpdate childUpdate = this.pagesAndLastUpdates.get(child);
            lastUpdate = ContentUpdate.newChildUpdated(childUpdate);
            this.pagesAndLastUpdates.put(page, lastUpdate);
        }
        boolean lastUpdateIsUnknown = UNKNOWN_DATE.equals(lastUpdate.getUpdateDate());
        if (lastUpdateIsUnknown) {
            log.warn(String.format("Last update date cannot be determined for page: #%d \"%s\"", pageId, page.getTitle()));
            this.pagesAndLastUpdates.remove(page);
        } else {
            this.contentUpdateTracker.persistContentEvent(pageId, lastUpdate);
            for (Page child : children) {
                this.pagesAndLastUpdates.remove(child);
            }
        }
        if (pageViewInitializationType != PageViewInitializationType.NONE) {
            ContentView lastView = null;
            if (pageViewInitializationType == PageViewInitializationType.LAST_UPDATE && !lastUpdateIsUnknown) {
                lastView = ContentView.copyFromContentUpdate(lastUpdate);
            } else if (pageViewInitializationType == PageViewInitializationType.FIXED) {
                lastView = ContentView.newGeneric(lastUpdate.getUpdaterName(), pageViewInitialDate);
            }
            if (lastView != null) {
                this.contentViewTracker.persistContentEventIfNotExisting(pageId, lastView);
            }
        }
        this.progressTracker.incrementCurrentCount();
        this.taskControlTracker.gracefulStopCheckpoint();
        return lastUpdate.getUpdateDate();
    }

    private static Date getPageLastModificationDate(Page page) {
        if (page.getLastModificationDate() != null) {
            return page.getLastModificationDate();
        }
        log.warn(String.format("Page without last modification date found: #%d \"%s\"", page.getId(), page.getTitle()));
        return UNKNOWN_DATE;
    }

    private static Optional<Pair<Attachment, Date>> findLastAttachmentWithUpdateDate(Page page) {
        ImmutablePair lastAttachment = null;
        Date latestDateSoFar = UNKNOWN_DATE;
        for (Attachment attachment : page.getAttachments()) {
            log.trace(String.format("Traversing attachment #%d \"%s\" (%s)", attachment.getId(), attachment.getFileName(), attachment.getLastModificationDate()));
            Optional<Date> latestUpdateDate = ContentEventIndexInitializerVisitor.getAttachmentLastUpdateDate(attachment);
            if (!latestUpdateDate.isPresent() || !latestUpdateDate.get().after(latestDateSoFar)) continue;
            latestDateSoFar = latestUpdateDate.get();
            lastAttachment = ImmutablePair.of((Object)attachment, (Object)latestDateSoFar);
        }
        return Optional.ofNullable(lastAttachment);
    }

    private static Optional<Date> getAttachmentLastUpdateDate(Attachment attachment) {
        boolean hasLastModificationDate;
        boolean hasLatestVersionLastModificationDate;
        ConfluenceEntityObject latestVersion = !attachment.isLatestVersion() ? (ConfluenceEntityObject)attachment.getLatestVersion() : null;
        boolean bl = hasLatestVersionLastModificationDate = latestVersion != null && latestVersion.getLastModificationDate() != null;
        if (hasLatestVersionLastModificationDate) {
            return Optional.of(latestVersion.getLastModificationDate());
        }
        boolean bl2 = hasLastModificationDate = attachment.getLastModificationDate() != null;
        if (hasLastModificationDate) {
            log.trace(String.format("Falling back to version-independent last modification date for attachment: #%d \"%s\"", attachment.getId(), attachment.getFileName()));
            return Optional.of(attachment.getLastModificationDate());
        }
        log.warn(String.format("Attachment without last modification date found: #%d \"%s\"", attachment.getId(), attachment.getFileName()));
        return Optional.empty();
    }
}

