/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web.rest;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.midori.confluence.plugin.archiving.listener.ContentEventListener;
import com.midori.confluence.plugin.archiving.service.ContentStatusCalculator;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentViewTracker;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleStatusHelper;
import com.midori.confluence.plugin.archiving.web.rest.model.ContentStatus;
import com.midori.confluence.plugin.archiving.web.rest.model.ContentStatusNode;
import com.midori.confluence.plugin.archiving.web.rest.model.ContentStatusWithMeta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/content-status")
@Produces(value={"application/json"})
public class ContentStatusResource {
    private PageManager pageManager;
    private PermissionManager permissionManager;
    private SpaceManager spaceManager;
    private ContentLifecycleStatusHelper contentLifecycleStatusHelper;
    private ContentStatusCalculator contentStatusCalculator;
    private ContentViewTracker contentViewTracker;

    @Inject
    public ContentStatusResource(PageManager pageManager, PermissionManager permissionManager, SpaceManager spaceManager, ContentLifecycleStatusHelper contentLifecycleStatusHelper, ContentStatusCalculator contentStatusCalculator, ContentViewTracker contentViewTracker) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.contentLifecycleStatusHelper = contentLifecycleStatusHelper;
        this.contentStatusCalculator = contentStatusCalculator;
        this.contentViewTracker = contentViewTracker;
    }

    @GET
    @Path(value="/{pageId}")
    public Response getContentStatus(@Context HttpServletRequest request, @PathParam(value="pageId") long pageId) {
        Page page = this.pageManager.getPage(pageId);
        if (page == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.canViewSpace(page.getSpace())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ContentStatus contentStatus = this.contentStatusCalculator.calculateContentStatus(page);
        boolean isDraft = this.contentLifecycleStatusHelper.isDraft();
        if (ContentEventListener.isRequestViewTrackable(request)) {
            this.contentViewTracker.onContentEvent(AuthenticatedUserThreadLocal.getUsername(), (ContentEntityObject)page);
        }
        return Response.ok((Object)new ContentStatusWithMeta(contentStatus, isDraft)).build();
    }

    @GET
    @Path(value="/space/{spaceKey}/children")
    public Response getContentStatuses(@PathParam(value="spaceKey") String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.canViewSpace(space)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List pages = this.pageManager.getTopLevelPages(space);
        if (pages == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List<ContentStatusNode> contentStatusNodes = this.getContentStatusNodes(new LinkedHashSet<Page>(pages));
        return Response.ok(contentStatusNodes).build();
    }

    @GET
    @Path(value="/{pageId}/children")
    public Response getContentStatuses(@PathParam(value="pageId") long pageId) {
        Page page = this.pageManager.getPage(pageId);
        if (page == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.canViewSpace(page.getSpace())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List pages = page.getSortedChildren();
        if (pages == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List<ContentStatusNode> contentStatusNodes = this.getContentStatusNodes(new LinkedHashSet<Page>(pages));
        return Response.ok(contentStatusNodes).build();
    }

    private boolean canViewSpace(Space space) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)space);
    }

    private List<ContentStatusNode> getContentStatusNodes(Set<Page> pages) {
        if (pages.isEmpty()) {
            return Collections.emptyList();
        }
        Map<Page, ContentStatus> pageStatusMap = this.contentStatusCalculator.calculateContentStatus(pages);
        return ContentStatusResource.contentStatusesToContentStatusNodes(pageStatusMap);
    }

    private static List<ContentStatusNode> contentStatusesToContentStatusNodes(Map<Page, ContentStatus> pageStatusMap) {
        ArrayList<ContentStatusNode> contentStatusNodes = new ArrayList<ContentStatusNode>(pageStatusMap.size());
        for (Map.Entry<Page, ContentStatus> entry : pageStatusMap.entrySet()) {
            Page page = entry.getKey();
            ContentStatus contentStatus = entry.getValue();
            contentStatusNodes.add(new ContentStatusNode(page, contentStatus));
        }
        return contentStatusNodes;
    }
}

