/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.midori.confluence.plugin.archiving.service.task.base.ArchivingLongRunningTask;
import com.midori.confluence.plugin.archiving.web.base.AbstractArchivingAction;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopLongRunningTasksAction
extends AbstractArchivingAction {
    private static final Logger log = LoggerFactory.getLogger(StopLongRunningTasksAction.class);
    private static final String CONTENT_QUALITY_SPACE = "content-quality-space";
    private static final String CONTENT_QUALITY_GLOBAL = "content-quality-global";

    public String execute() throws IOException {
        Optional<ArchivingLongRunningTask> task = this.contentLifecycleLongRunningTaskManager.getCurrentlyRunningTask();
        if (task.isPresent() && this.contentLifecyclePermissionHelper.canStopTask(task.get())) {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            log.info(String.format("User \"%s\" requested stopping the currently running task", user.getName()));
            this.contentLifecycleLongRunningTaskManager.stopRunningTaskGracefully();
        } else {
            log.info("No running task to stop or insufficient permissions");
        }
        String referrer = this.servletActionContextCompatManager.getRequest().getHeader("referer");
        if (StringUtils.isNotBlank((CharSequence)referrer)) {
            this.servletActionContextCompatManager.getResponse().sendRedirect(referrer);
            return "none";
        }
        return this.isGlobal() ? CONTENT_QUALITY_GLOBAL : CONTENT_QUALITY_SPACE;
    }
}

