/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.task;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.midori.confluence.plugin.archiving.service.ContentArchivingManager;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleStatusHelper;
import com.midori.confluence.plugin.archiving.service.support.DateTimeProvider;
import com.midori.confluence.plugin.archiving.service.support.PluginHelper;
import com.midori.confluence.plugin.archiving.service.support.SpaceHelper;
import com.midori.confluence.plugin.archiving.service.support.SqlHelper;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskManager;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskResultManager;
import com.midori.confluence.plugin.archiving.service.task.base.AbstractArchivingLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.model.LongRunningTaskDescriptor;
import com.midori.confluence.plugin.archiving.service.task.progress.SmartProgressMeter;
import com.midori.confluence.plugin.archiving.service.task.result.LongRunningTaskResult;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyLongRunningTask
extends AbstractArchivingLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(ProxyLongRunningTask.class);
    private static final String UNKNOWN_NAME = "UNKNOWN_NAME";
    private static final int STATE_REFRESH_INTERVAL_IN_MILLIS = 500;
    private static final int CLUSTER_WIDE_LOCK_AVAILABILITY_CHECK_ITERATIONS = 4;

    public ProxyLongRunningTask(PageManager pageManager, SpaceManager spaceManager, TransactionTemplate transactionTemplate, ContentLifecycleLongRunningTaskManager contentLifecycleLongRunningTaskManager, ContentArchivingManager contentArchivingManager, ContentLifecycleActorHelper contentLifecycleActorHelper, ContentLifecycleStatusHelper contentLifecycleStatusHelper, ContentLifecycleLongRunningTaskResultManager contentLifecycleLongRunningTaskResultManager, PluginHelper pluginHelper, SpaceHelper spaceHelper, SqlHelper sqlHelper, String nodeName) {
        super(pageManager, spaceManager, transactionTemplate, contentLifecycleLongRunningTaskManager, contentArchivingManager, contentLifecycleActorHelper, contentLifecycleStatusHelper, contentLifecycleLongRunningTaskResultManager, pluginHelper, spaceHelper, sqlHelper, Optional.empty(), nodeName);
        this.refreshSpaceByRealSpaceKey();
    }

    @Override
    public boolean isReal() {
        return false;
    }

    @Override
    protected void runInternal() {
        try {
            LongRunningTaskDescriptor realTaskDescriptor = this.getRealTaskDescriptor();
            log.debug(String.format("Proxy task started for real task <%s> on node <%s> (version %s)", realTaskDescriptor.getName(), realTaskDescriptor.getNodeName(), this.pluginHelper.getPluginVersion()));
            int iteration = 0;
            boolean realTaskHoldingClusterWideLock = true;
            do {
                boolean checkClusterWideLockAvailability;
                SmartProgressMeter realProgressMeter;
                if ((realProgressMeter = this.getRealTaskDescriptor().getProgressMeter()) != null) {
                    log.debug(String.format("Updating proxy task progress from real progress: %s", realProgressMeter));
                    this.replaceProgressWith(realProgressMeter);
                } else {
                    log.debug("Failed to find real progress yet");
                }
                boolean bl = checkClusterWideLockAvailability = ++iteration % 4 == 0;
                if (checkClusterWideLockAvailability) {
                    boolean bl2 = realTaskHoldingClusterWideLock = !this.contentLifecycleLongRunningTaskManager.isClusterWideLockAvailable();
                    if (!realTaskHoldingClusterWideLock) {
                        log.debug("Stopping proxy task as real task not holding the lock any longer");
                    }
                }
                if (!realTaskHoldingClusterWideLock) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (realTaskHoldingClusterWideLock && !((SmartProgressMeter)this.progress).isCompleted() && !((SmartProgressMeter)this.progress).isFailed());
            if (!((SmartProgressMeter)this.progress).isFailed()) {
                this.getClusterWideProgressTracker().markCompleted();
                log.debug("Copying result from real task to proxy task");
                String realTaskId = this.getRealTaskDescriptor().getTaskId();
                LongRunningTaskResult result = this.contentLifecycleLongRunningTaskResultManager.getResult(realTaskId);
                this.contentLifecycleLongRunningTaskResultManager.putResult(this.getTaskId(), result);
                log.debug(String.format("Proxy task completed in %s (%ds)", StringUtils.uncapitalize((String)this.getPrettyElapsedTime()), this.getElapsedTime() / 1000L));
            } else {
                log.error(String.format("Proxy task stopped due to the real task <%s> failure on node <%s>: \"%s\"", realTaskDescriptor.getName(), realTaskDescriptor.getNodeName(), this.progress.getStatus()));
            }
        }
        catch (ThreadDeath ex) {
            log.warn(String.format("Proxy task has been forcibly stopped (via its thread <%s>)", Thread.currentThread().getName()));
        }
    }

    @Override
    protected void execute() {
        throw new NotImplementedException();
    }

    @Override
    public String getName() {
        return this.getRealTaskDescriptor().getName();
    }

    @Override
    protected SmartProgressMeter createProgressMeter() {
        throw new NotImplementedException();
    }

    @Override
    protected String getStartStatusHtml() {
        throw new NotImplementedException();
    }

    @Override
    protected String getCompletedStatusHtml() {
        throw new NotImplementedException();
    }

    @Override
    protected String getErrorStatusHtml(Exception cause) {
        throw new NotImplementedException();
    }

    @Override
    protected String getErrorLogText() {
        throw new NotImplementedException();
    }

    public long getElapsedTime() {
        return DateTimeProvider.currentTimeMillis() - this.getRealTaskDescriptor().getStartTime();
    }

    public String getRealNodeName() {
        return this.getRealTaskDescriptor().getNodeName();
    }

    private LongRunningTaskDescriptor getRealTaskDescriptor() {
        LongRunningTaskDescriptor descriptor = this.contentLifecycleLongRunningTaskManager.getCurrentlyRunningTaskDescriptor();
        return descriptor != null ? descriptor : new LongRunningTaskDescriptor(UNKNOWN_NAME, null, null, UNKNOWN_NAME, DateTimeProvider.currentTimeMillis(), null);
    }

    private void refreshSpaceByRealSpaceKey() {
        String realSpaceKey = this.getRealTaskDescriptor().getSpaceKey();
        if (realSpaceKey != null) {
            this.space = Optional.ofNullable(this.spaceManager.getSpace(realSpaceKey));
        }
    }
}

