/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.task;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.midori.confluence.plugin.archiving.service.task.result.LongRunningTaskResult;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentLifecycleLongRunningTaskResultManager {
    private static final Logger log = LoggerFactory.getLogger(ContentLifecycleLongRunningTaskResultManager.class);
    private static final String CACHE_NAME = "Archiving Plugin: Long Running Task Results";
    private ObjectMapper jsonMapper = new ObjectMapper();
    private final Cache<String, String> cache;

    public ContentLifecycleLongRunningTaskResultManager(CacheManager cacheManager) {
        this.cache = cacheManager.getCache(CACHE_NAME, null, new CacheSettingsBuilder().expireAfterAccess(24L, TimeUnit.HOURS).build());
    }

    public LongRunningTaskResult getResult(String taskId) {
        log.debug(String.format("Getting task result <%s> from cache", taskId));
        try {
            String resultJson = (String)this.cache.get((Object)taskId);
            if (resultJson != null) {
                return this.jsonMapper.readValue(resultJson, LongRunningTaskResult.class);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get task result from cache", e);
        }
        return null;
    }

    public void putResult(String taskId, LongRunningTaskResult result) {
        log.debug(String.format("Putting task result <%s> to cache: %s", taskId, result));
        try {
            String resultJson = this.jsonMapper.writeValueAsString(result);
            this.cache.put((Object)taskId, (Object)resultJson);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to put task result to cache", e);
        }
    }
}

