/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.strategy.impl;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.midori.confluence.plugin.archiving.model.PageArchiving;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingExecutionContext;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingExecutionSpecification;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingStrategy;
import com.midori.confluence.plugin.archiving.service.strategy.replication.PageReplicator;
import com.midori.confluence.plugin.archiving.service.strategy.replication.SpaceReplicator;
import com.midori.confluence.plugin.archiving.service.support.ContentTraversalHelper;
import com.midori.confluence.plugin.archiving.service.task.control.TaskControlTracker;
import com.midori.confluence.plugin.archiving.service.task.progress.ProgressTracker;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArchivingStrategy
implements ContentArchivingStrategy {
    private static Logger log = LoggerFactory.getLogger(AbstractArchivingStrategy.class);
    protected static final int MINIMUM_PAGE_COUNT_FOR_PRESORTING = 100;
    protected PageManager pageManager;
    protected SpaceManager spaceManager;
    protected ContentTraversalHelper contentTraversalHelper;
    protected PageReplicator pageReplicator;
    protected SpaceReplicator spaceReplicator;
    protected ProgressTracker progressTracker;
    protected TaskControlTracker taskControlTracker;

    public AbstractArchivingStrategy(SpaceManager spaceManager, PageManager pageManager, ContentTraversalHelper contentTraversalHelper, PageReplicator pageReplicator, SpaceReplicator spaceReplicator, ProgressTracker progressTracker, TaskControlTracker taskControlTracker) {
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.contentTraversalHelper = contentTraversalHelper;
        this.pageReplicator = pageReplicator;
        this.spaceReplicator = spaceReplicator;
        this.progressTracker = progressTracker;
        this.taskControlTracker = taskControlTracker;
    }

    @Override
    public void execute(ContentArchivingExecutionSpecification specification, ContentArchivingExecutionContext context) {
        if (specification.hasNoPagesToArchive()) {
            log.warn(String.format("No pages to archive passed in <%s>", specification.getSpace().getKey()));
        } else {
            this.executeInternal(specification, context);
        }
    }

    protected abstract void executeInternal(ContentArchivingExecutionSpecification var1, ContentArchivingExecutionContext var2);

    protected Page replicateBranch(ContentArchivingExecutionContext context, Page freshPageToArchive, List<Page> freshBranch, Map<Page, PageArchiving> freshPagesToArchive, String archiveSpaceKey, Page archiveParent) {
        log.debug(String.format("Replicating branch (top to bottom): %s", freshBranch));
        for (Page page : freshBranch) {
            Page archivePage;
            block16: {
                boolean isArchivePageExisting;
                log.debug(String.format("Replicating <%s> (ID: %d)", page.getTitle(), page.getId()));
                boolean isPageToArchive = freshPagesToArchive.containsKey(page);
                archivePage = this.pageManager.getPage(archiveSpaceKey, page.getTitle());
                boolean bl = isArchivePageExisting = archivePage != null;
                if (!isArchivePageExisting) {
                    if (isPageToArchive) {
                        log.debug(String.format("Creating archive for <%s> (ID: %d, %d of %d)", page.getTitle(), page.getId(), 1 + context.getFreshPagesArchived().size(), freshPagesToArchive.size()));
                    } else {
                        log.debug(String.format("Creating archive for <%s> (ID: %d, parent)", page.getTitle(), page.getId()));
                    }
                    long targetParentPageId = archiveParent != null ? archiveParent.getId() : 0L;
                    try {
                        archivePage = this.pageReplicator.replicate(page.getId(), archiveSpaceKey, targetParentPageId);
                        context.addArchivePageAsProcessed(archivePage);
                        if (isPageToArchive) {
                            this.afterArchivePageCreated(context, freshPageToArchive, page, archivePage, freshPagesToArchive);
                            break block16;
                        }
                        context.addArchiveParentCreated(archivePage);
                    }
                    catch (Throwable t2) {
                        String errorMessage = String.format("Failed to create archive for <%s>", page.getTitle());
                        this.logError(context, errorMessage, t2);
                        archivePage = this.createErrorProxyPage(context, page, targetParentPageId, archiveSpaceKey, t2).orElse(archivePage);
                    }
                } else {
                    this.relocateArchiveBranchPageIfNecessary(context, page, archivePage, archiveParent);
                    if (!context.isArchivePageProcessed(archivePage)) {
                        if (isPageToArchive) {
                            log.debug(String.format("Updating archive for <%s> (%d of %d)", page.getTitle(), 1 + context.getFreshPagesArchived().size(), freshPagesToArchive.size()));
                        } else {
                            log.debug(String.format("Updating archive for <%s> (parent)", page.getTitle()));
                        }
                        try {
                            archivePage = this.pageReplicator.replicate(page.getId(), archivePage.getId());
                            context.addArchivePageAsProcessed(archivePage);
                            if (isPageToArchive) {
                                this.afterArchivePageUpdated(context, freshPageToArchive, page, archivePage, freshPagesToArchive);
                                break block16;
                            }
                            context.addArchiveParentSynched(archivePage);
                        }
                        catch (Throwable t3) {
                            String errorMessage = String.format("Failed to update archive for <%s>, skipping", page.getTitle());
                            this.logError(context, errorMessage, t3);
                        }
                    } else {
                        log.debug("Skipping already processed <" + page.getTitle() + ">");
                    }
                }
            }
            if (archivePage == null) {
                String errorMessage = "Terminating branch as archive branch page is unavailable";
                this.logError(context, errorMessage);
                break;
            }
            archiveParent = archivePage;
        }
        return archiveParent;
    }

    private Optional<Page> createErrorProxyPage(ContentArchivingExecutionContext context, Page page, long targetParentPageId, String archiveSpaceKey, Throwable error) {
        Page errorPage = null;
        try {
            String content = this.createErrorPageMarkup(error);
            errorPage = this.pageReplicator.createProxy(page.getId(), archiveSpaceKey, targetParentPageId, content);
        }
        catch (Throwable t2) {
            String errorMessage = String.format("Failed to create archive error page for <%s>", page.getTitle());
            this.logError(context, errorMessage, error);
        }
        return Optional.ofNullable(errorPage);
    }

    private String createErrorPageMarkup(Throwable t2) {
        StringWriter writer = new StringWriter();
        t2.printStackTrace(new PrintWriter(writer));
        String markup = String.format("<ac:structured-macro ac:name=\"warning\"><ac:parameter ac:name=\"title\">%s</ac:parameter><ac:rich-text-body><p>%s</p></ac:rich-text-body></ac:structured-macro><ac:structured-macro ac:name=\"noformat\"><ac:plain-text-body><![CDATA[%s]]></ac:plain-text-body></ac:structured-macro>", "Better Content Archiving has failed to create this page.", "Please report the error below to <a href=\"https://www.midori-global.com/support/customer-support\">https://www.midori-global.com/support/customer-support</a>", writer.toString());
        return markup;
    }

    protected void relocateArchiveBranchPageIfNecessary(ContentArchivingExecutionContext context, Page page, Page archivePage, Page archiveParent) {
        boolean isCorrectLocation;
        boolean haveNoParents = archiveParent == null && archivePage.getParent() == null;
        boolean haveMatchingParents = archiveParent != null && archiveParent.equals((Object)archivePage.getParent());
        boolean bl = isCorrectLocation = haveNoParents || haveMatchingParents;
        if (!isCorrectLocation) {
            log.debug("Moving existing archive for <" + page.getTitle() + "> to " + (archiveParent != null ? "a child of <" + archiveParent.getTitle() + ">" : "top level"));
            try {
                this.pageReplicator.move(archivePage, archiveParent);
            }
            catch (Throwable t2) {
                String errorMessage = String.format("Failed to move existing archive for <%s>", page.getTitle());
                this.logError(context, errorMessage, t2);
            }
        }
    }

    protected void trashPages(ContentArchivingExecutionContext context, Set<Page> pages) {
        ArrayList<Page> pagesInReverseOrder = new ArrayList<Page>(pages);
        Collections.reverse(pagesInReverseOrder);
        for (Page page : pagesInReverseOrder) {
            log.debug(String.format("Trashing fresh of <%s> (%d of %d)", page.getTitle(), 1 + context.getFreshPagesTrashed().size(), pages.size()));
            try {
                this.pageReplicator.silentlyRemove(page);
                context.addFreshPageTrashed(page);
            }
            catch (Throwable t2) {
                String errorMessage = String.format("Failed to trash <%s>", page.getTitle());
                this.logError(context, errorMessage, t2);
            }
            this.taskControlTracker.gracefulStopCheckpoint();
        }
    }

    protected final void afterArchivePageCreated(ContentArchivingExecutionContext context, Page pageToArchive, Page freshBranchPage, Page archiveBranchPage, Map<Page, PageArchiving> freshPagesToArchive) {
        context.addArchivePageCreated(archiveBranchPage);
        this.updateResultMaps(context, pageToArchive, freshBranchPage, archiveBranchPage, freshPagesToArchive);
    }

    protected final void afterArchivePageUpdated(ContentArchivingExecutionContext context, Page pageToArchive, Page freshBranchPage, Page archiveBranchPage, Map<Page, PageArchiving> freshPagesToArchive) {
        context.addArchivePageSynched(archiveBranchPage);
        this.updateResultMaps(context, pageToArchive, freshBranchPage, archiveBranchPage, freshPagesToArchive);
    }

    private void updateResultMaps(ContentArchivingExecutionContext context, Page pageToArchive, Page freshBranchPage, Page archiveBranchPage, Map<Page, PageArchiving> freshPagesToArchive) {
        context.getFreshPagesArchived().add(freshBranchPage);
        context.addArchivePageResulted(archiveBranchPage, freshPagesToArchive.get(pageToArchive));
    }

    protected void logError(ContentArchivingExecutionContext context, String errorMessage) {
        this.logError(context, errorMessage, null);
    }

    protected void logError(ContentArchivingExecutionContext context, String errorMessage, Throwable t2) {
        context.addError(errorMessage);
        if (t2 != null) {
            log.error(errorMessage, t2);
        } else {
            log.error(errorMessage);
        }
    }
}

