/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.persistence;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.Space;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.midori.confluence.plugin.archiving.model.ContentArchivingEvent;
import com.midori.confluence.plugin.archiving.model.ao.ContentArchivingEventAo;
import com.midori.confluence.plugin.archiving.model.type.ArchivingEventType;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentArchivingEventManager {
    private static Logger log = LoggerFactory.getLogger(ContentArchivingEventManager.class);
    private ActiveObjects ao;

    public ContentArchivingEventManager(ActiveObjects ao) {
        this.ao = ao;
    }

    public List<ContentArchivingEvent> findEvents(Set<ArchivingEventType> types, Optional<Space> spaceOption, Optional<Integer> idToStartOption, int limit) {
        Query query = ContentArchivingEventManager.createEventsQuery(types, spaceOption, idToStartOption).order("ID DESC").limit(limit);
        List<ContentArchivingEvent> events = ContentArchivingEvent.fromAo((ContentArchivingEventAo[])this.ao.find(ContentArchivingEventAo.class, query));
        log.trace(String.format("%d events found for space %s, types %s, before ID %s using limit %d", events.size(), spaceOption, types, idToStartOption, limit));
        return events;
    }

    public int countEvents(Set<ArchivingEventType> types, Optional<Space> spaceOption, Optional<Integer> idToStartOption) {
        Query query = ContentArchivingEventManager.createEventsQuery(types, spaceOption, idToStartOption);
        int count = this.ao.count(ContentArchivingEventAo.class, query);
        log.trace(String.format("%d events counted for space %s, types %s, before ID %s", count, spaceOption, types, idToStartOption));
        return count;
    }

    public Optional<ContentArchivingEvent> findEventById(int id) {
        ContentArchivingEventAo eventAo = (ContentArchivingEventAo)this.ao.get(ContentArchivingEventAo.class, (Object)id);
        return eventAo != null ? Optional.of(ContentArchivingEvent.fromAo(eventAo)) : Optional.empty();
    }

    public Optional<ContentArchivingEvent> getLatestEventOfType(Space space, ArchivingEventType eventType) {
        List<ContentArchivingEvent> events = ContentArchivingEvent.fromAo((ContentArchivingEventAo[])this.ao.find(ContentArchivingEventAo.class, Query.select().where("SPACE_KEY = ? AND EVENT_TYPE = ?", new Object[]{space.getKey(), eventType}).order("ID DESC").limit(1)));
        log.trace(String.format("%d events found for space <%s> and type %s", new Object[]{events.size(), space.getKey(), eventType}));
        return !events.isEmpty() ? Optional.of(ModelUtils.firstElement(events)) : Optional.empty();
    }

    public void createEvent(ContentArchivingEvent event) {
        log.debug(String.format("Creating event for <%s>: %s for %d+%d pages", new Object[]{event.getSpaceKey(), event.getType(), event.getPageIds().size(), event.getRemainingPageCount()}));
        this.ao.create(ContentArchivingEventAo.class, ContentArchivingEventManager.toParameterMap(event));
    }

    public void createEvents(Collection<ContentArchivingEvent> events) {
        for (ContentArchivingEvent event : events) {
            this.createEvent(event);
        }
    }

    public static Map<Date, Multimap<String, ContentArchivingEvent>> groupEventsByDateAndSpaceKey(Collection<ContentArchivingEvent> events) {
        LinkedHashMap<Date, Multimap<String, ContentArchivingEvent>> datesToSpaceKeysToEvents = new LinkedHashMap<Date, Multimap<String, ContentArchivingEvent>>();
        for (ContentArchivingEvent event : events) {
            Date date = event.getDate();
            String spaceKey = event.getSpaceKey();
            if (!datesToSpaceKeysToEvents.containsKey(date)) {
                datesToSpaceKeysToEvents.put(date, LinkedListMultimap.create());
            }
            Multimap spaceKeysToEvents = (Multimap)datesToSpaceKeysToEvents.get(date);
            spaceKeysToEvents.put(spaceKey, event);
        }
        return datesToSpaceKeysToEvents;
    }

    private static Map<String, Object> toParameterMap(ContentArchivingEvent event) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("DATE", event.getDate());
        params.put("SPACE_KEY", event.getSpaceKey());
        params.put("EVENT_TYPE", (Object)event.getType());
        params.put("USER", event.getUser());
        params.put("PAGE_IDS", ModelUtils.serializeObjectSet(event.getPageIds()));
        params.put("REMAINING_PAGE_COUNT", event.getRemainingPageCount());
        return params;
    }

    private static Query createEventsQuery(Set<ArchivingEventType> types, Optional<Space> spaceOption, Optional<Integer> idToStartOption) {
        String clause = "";
        ArrayList<Object> params = new ArrayList<Object>();
        if (!types.isEmpty()) {
            clause = clause + "(EVENT_TYPE = ?" + StringUtils.repeat((String)" OR EVENT_TYPE = ?", (int)(types.size() - 1)) + ")";
            params.addAll(types);
        }
        if (spaceOption.isPresent()) {
            clause = clause + (StringUtils.isNotBlank((CharSequence)clause) ? " AND " : "") + "SPACE_KEY = ?";
            params.add(spaceOption.get().getKey());
        }
        if (idToStartOption.isPresent()) {
            clause = clause + (StringUtils.isNotBlank((CharSequence)clause) ? " AND " : "") + "ID < ?";
            params.add(idToStartOption.get());
        }
        Query query = Query.select();
        if (!params.isEmpty()) {
            query.where(clause, params.toArray());
        }
        return query;
    }
}

