/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web.base;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.midori.confluence.plugin.archiving.service.support.PluginHelper;
import com.midori.confluence.plugin.archiving.service.task.base.AbstractArchivingLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.base.ArchivingLongRunningTask;
import com.midori.confluence.plugin.archiving.web.base.AbstractNonBlacklistedArchivingAction;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLongRunningArchivingTaskLauncherAction<T extends AbstractArchivingLongRunningTask>
extends AbstractNonBlacklistedArchivingAction {
    private static Logger log = LoggerFactory.getLogger(AbstractLongRunningArchivingTaskLauncherAction.class);
    public static final String CONFLICT = "conflict";
    public static final String PRECONDITION_ERROR = "precondition-error";
    protected PageManager pageManager;
    private LongRunningTaskId taskId;

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public String getTaskId() {
        return this.taskId.toString();
    }

    public String execute() {
        if (!this.isPost()) {
            return "error";
        }
        T task = this.createTask();
        this.contentLifecycleLongRunningTaskManager.untrackFinishedTasks();
        Optional<String> preconditionError = this.getLaunchPreconditionErrors();
        if (!preconditionError.isPresent()) {
            Optional<ArchivingLongRunningTask> currentlyRunningTask = this.contentLifecycleLongRunningTaskManager.getCurrentlyRunningTask();
            if (currentlyRunningTask.isPresent()) {
                log.warn(String.format("Failed to start the %s task as %s is already running", task.getName(), currentlyRunningTask.get().getName()));
                return CONFLICT;
            }
            this.taskId = this.contentLifecycleLongRunningTaskManager.startTask((AbstractArchivingLongRunningTask)task);
            if (this.taskId == null) {
                return CONFLICT;
            }
        } else {
            return PRECONDITION_ERROR;
        }
        return "success";
    }

    protected abstract T createTask();

    public String getPreconditionError() {
        return this.getLaunchPreconditionErrors().orElse(null);
    }

    protected Optional<String> getLaunchPreconditionErrors() {
        if (PluginHelper.isReadOnlyAccessModeEnabled()) {
            return Optional.of("You cannot start this task in read-only mode.");
        }
        if (!this.isPermitted()) {
            return Optional.of("You do not have enough permissions to start this task.");
        }
        return Optional.empty();
    }

    private boolean isPost() {
        return "POST".equals(this.servletActionContextCompatManager.getRequest().getMethod());
    }
}

