/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.atlassian.confluence.spaces.Space;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleLabelHelper;
import com.midori.confluence.plugin.archiving.web.base.AbstractArchivingAction;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class ManageSpaceBlacklistAction
extends AbstractArchivingAction {
    private Map<Space, Boolean> spaceToBlacklistStatusMapping;
    private List<String> selectedSpaceKeys;

    public Map<Space, Boolean> getSpaceToBlacklistStatusMapping() {
        return this.spaceToBlacklistStatusMapping;
    }

    @StrutsParameter
    public void setSelectedSpaceKeys(List<String> selectedSpaceKeys) {
        this.selectedSpaceKeys = selectedSpaceKeys;
    }

    public String view() {
        this.spaceToBlacklistStatusMapping = new LinkedHashMap<Space, Boolean>();
        for (Space space : this.spaceHelper.findGlobalFreshSpaces()) {
            this.spaceToBlacklistStatusMapping.put(space, ContentLifecycleLabelHelper.isBlacklistedSpace(space));
        }
        return "input";
    }

    public String save() {
        if (this.isSessionExpired()) {
            return "error";
        }
        if (this.selectedSpaceKeys == null) {
            this.selectedSpaceKeys = Collections.emptyList();
        }
        for (Space space : this.spaceHelper.findGlobalFreshSpaces()) {
            boolean shouldBeBlacklisted = this.selectedSpaceKeys.contains(space.getKey());
            this.contentLifecycleLabelHelper.setSpaceBlacklistState(space, shouldBeBlacklisted);
        }
        return "success";
    }
}

