/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support;

import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.Entity;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.exception.ArchivingActorException;
import com.midori.confluence.plugin.archiving.service.exception.ArchivingActorInvalidException;
import com.midori.confluence.plugin.archiving.service.exception.ArchivingActorNotFoundException;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.service.support.ContentTraversalHelper;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPage;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightSpace;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentLifecycleActorHelper {
    private static Logger log = LoggerFactory.getLogger(ContentLifecycleActorHelper.class);
    private static final String ANONYMOUS_NAME_I18N_KEY = "anonymous.name";
    private ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private ContentTraversalHelper contentTraversalHelper;
    private I18nResolver i18nResolver;
    private SpaceManager spaceManager;
    private SpacePermissionManager spacePermissionManager;
    private UserAccessor userAccessor;

    public ContentLifecycleActorHelper(ContentArchivingConfigurationManager contentArchivingConfigurationManager, ContentTraversalHelper contentTraversalHelper, I18nResolver i18nResolver, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, UserAccessor userAccessor) {
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
        this.contentTraversalHelper = contentTraversalHelper;
        this.i18nResolver = i18nResolver;
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
        this.userAccessor = userAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withArchivingActor(Space space, Function<Space, Void> doWhileAuthenticated) throws ArchivingActorException {
        String string;
        ConfluenceUser previousUser = null;
        try {
            ContentArchivingConfiguration config = this.contentArchivingConfigurationManager.findResolvedConfiguration(space.getKey());
            String archivingActor = this.selectArchivingActor(config);
            previousUser = this.authenticateUser(archivingActor, String.format("for starting on <%s>", space.getKey()));
            doWhileAuthenticated.apply(space);
            string = previousUser != null ? previousUser.getName() : null;
        }
        catch (Throwable throwable) {
            this.authenticateUser(previousUser != null ? previousUser.getName() : null, String.format("after completed on <%s>", space.getKey()));
            throw throwable;
        }
        this.authenticateUser(string, String.format("after completed on <%s>", space.getKey()));
    }

    private ConfluenceUser authenticateUser(String userName, String explanation) {
        log.trace(String.format("Authenticating as %s (%s)", userName != null ? "<" + userName + ">" : "NULL", explanation));
        ConfluenceUser user = null;
        if (userName != null && (user = this.findUserIfAvailable(userName)) == null) {
            throw new IllegalArgumentException(String.format("Actor <%s> is not available (deleted, disabled or permissions removed)", userName));
        }
        ConfluenceUser previousUser = AuthenticatedUserThreadLocal.get();
        AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
        log.debug(String.format("Successfully authenticated as %s (%s), previously was %s", userName != null ? "<" + userName + ">" : "NULL", explanation, previousUser != null ? "<" + previousUser.getName() + ">" : "NULL"));
        return previousUser;
    }

    public String selectArchivingActor(ContentArchivingConfiguration configuration) throws ArchivingActorException {
        String userName = StringUtils.trimToNull((String)configuration.getPageArchivingActor());
        Set<String> archivingActorCandidates = this.findArchivingActorCandidateNames();
        if (StringUtils.isBlank((CharSequence)userName)) {
            if (!archivingActorCandidates.isEmpty()) {
                userName = ModelUtils.firstElement(archivingActorCandidates);
            } else {
                throw new ArchivingActorNotFoundException(userName);
            }
        }
        if (!archivingActorCandidates.contains(userName)) {
            throw new ArchivingActorInvalidException(userName);
        }
        return userName;
    }

    public Set<ConfluenceUser> findArchivingActorCandidates() {
        LinkedHashSet<ConfluenceUser> actorCandidates = new LinkedHashSet<ConfluenceUser>();
        Group confluenceAdminsGroup = this.userAccessor.getGroup("confluence-administrators");
        List confluenceAdminNames = confluenceAdminsGroup != null ? this.userAccessor.getMemberNamesAsList(confluenceAdminsGroup) : Collections.emptyList();
        for (String confluenceAdminName : confluenceAdminNames) {
            ConfluenceUser confluenceAdmin = this.findUserIfAvailable(confluenceAdminName);
            if (confluenceAdmin == null) continue;
            actorCandidates.add(confluenceAdmin);
        }
        return actorCandidates;
    }

    public Set<String> findArchivingActorCandidateNames() {
        return this.findArchivingActorCandidates().stream().map(Entity::getName).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Multimap<String, LightPage> findAuthorsByPages(Collection<LightPage> pages, Function<LightPage, LightPage> mapper) {
        ArrayListMultimap<String, LightPage> authors = ArrayListMultimap.create();
        for (LightPage page : pages) {
            LightPage mappedPage = mapper.apply(page);
            if (!StringUtils.isNotBlank((CharSequence)mappedPage.getCreatorName())) continue;
            authors.put(mappedPage.getCreatorName(), page);
        }
        return authors;
    }

    public Multimap<String, LightPage> findLastModifiersByPages(Collection<LightPage> pages, Function<LightPage, LightPage> mapper) {
        ArrayListMultimap<String, LightPage> lastModifiers = ArrayListMultimap.create();
        for (LightPage page : pages) {
            LightPage mappedPage = mapper.apply(page);
            if (!StringUtils.isNotBlank((CharSequence)mappedPage.getLastModifierName())) continue;
            lastModifiers.put(mappedPage.getLastModifierName(), page);
        }
        return lastModifiers;
    }

    public Multimap<String, LightPage> findOwnersByPages(Collection<LightPage> pages) {
        ArrayListMultimap<String, LightPage> owners = ArrayListMultimap.create();
        Space space = this.spaceManager.getSpace(pages.iterator().next().getSpaceKey());
        HashMultimap<Long, String> ownedPages = this.contentTraversalHelper.findPagesLabelledWithUserName(space, "owned-single-by-", "owned-by-", "owned-by-user-type labels");
        if (!ownedPages.isEmpty()) {
            for (LightPage page : pages) {
                if (!ownedPages.containsKey(page.getId())) continue;
                for (String owner : ownedPages.get((Object)page.getId())) {
                    owners.put(owner, page);
                }
            }
        }
        return owners;
    }

    public Multimap<String, LightPage> findSpaceAdminsByPages(Collection<LightPage> pages, LightSpace space) {
        ArrayListMultimap<String, LightPage> spaceAdmins = ArrayListMultimap.create();
        Set<String> spaceAdminNames = this.findSpaceAdminNames(space.getKey());
        for (String spaceAdmin : spaceAdminNames) {
            for (LightPage page : pages) {
                spaceAdmins.put(spaceAdmin, page);
            }
        }
        return spaceAdmins;
    }

    public Multimap<String, LightPage> findSpaceCreatorsByPages(Collection<LightPage> pages, LightSpace space) {
        ArrayListMultimap<String, LightPage> spaceCreators = ArrayListMultimap.create();
        if (space.getCreatorName() != null && StringUtils.isNotBlank((CharSequence)space.getCreatorName())) {
            for (LightPage page : pages) {
                spaceCreators.put(space.getCreatorName(), page);
            }
        }
        return spaceCreators;
    }

    public ConfluenceUser findUserIfAvailable(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return null;
        }
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        if (user == null) {
            log.trace(String.format("User <%s> not found", userName));
            return null;
        }
        if (this.userAccessor.isDeactivated((User)user)) {
            log.trace(String.format("User <%s> is disabled", userName));
            return null;
        }
        return user;
    }

    private Set<String> findSpaceAdminNames(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        HashSet<String> spaceAdminNames = new HashSet<String>();
        Map spaceAdministrators = this.spacePermissionManager.getUsersForPermissionType("SETSPACEPERMISSIONS", space);
        for (String spaceAdminName : spaceAdministrators.keySet()) {
            if (!StringUtils.isNotBlank((CharSequence)spaceAdminName)) continue;
            spaceAdminNames.add(spaceAdminName);
        }
        Map spaceAdministratorGroups = this.spacePermissionManager.getGroupsForPermissionType("SETSPACEPERMISSIONS", space);
        for (String administratorGroupName : spaceAdministratorGroups.keySet()) {
            Group administratorGroup;
            if (!StringUtils.isNotBlank((CharSequence)administratorGroupName) || (administratorGroup = this.userAccessor.getGroup(administratorGroupName)) == null) continue;
            List members = this.userAccessor.getMemberNamesAsList(administratorGroup);
            for (String spaceAdminName : members) {
                if (!StringUtils.isNotBlank((CharSequence)spaceAdminName)) continue;
                spaceAdminNames.add(spaceAdminName);
            }
        }
        return spaceAdminNames;
    }

    public String getUserName(ConfluenceUser user) {
        return user != null ? user.getName() : this.i18nResolver.getText(ANONYMOUS_NAME_I18N_KEY);
    }

    public String getUserDisplayName(String userName) {
        if (userName == null) {
            return this.i18nResolver.getText(ANONYMOUS_NAME_I18N_KEY);
        }
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        return user != null ? user.getFullName() : userName;
    }
}

