/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.persistence;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.SpaceManager;
import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.ao.ContentArchivingConfigurationAo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentArchivingConfigurationManager {
    private static Logger log = LoggerFactory.getLogger(ContentArchivingConfigurationManager.class);
    private ActiveObjects ao;
    private SpaceManager spaceManager;

    public ContentArchivingConfigurationManager(ActiveObjects ao, SpaceManager spaceManager) {
        this.ao = ao;
        this.spaceManager = spaceManager;
    }

    public List<ContentArchivingConfiguration> findAllConfigurations() {
        return (List)this.ao.executeInTransaction(() -> {
            ContentArchivingConfigurationAo[] contentArchivingConfigurationAos = (ContentArchivingConfigurationAo[])this.ao.find(ContentArchivingConfigurationAo.class);
            return ContentArchivingConfiguration.fromAo(contentArchivingConfigurationAos);
        });
    }

    public Map<Integer, Set<String>> getGlobalConfigurationToSpaceMapping() {
        log.trace("Loading global configuration to space mapping");
        HashMap<Integer, Set<String>> configToSpaceMapping = new HashMap<Integer, Set<String>>();
        List<ContentArchivingConfiguration> configs = this.findAllConfigurations();
        for (ContentArchivingConfiguration config : configs) {
            if (!config.isGlobal()) continue;
            configToSpaceMapping.put(config.getId(), new HashSet());
        }
        for (ContentArchivingConfiguration config : configs) {
            if (!config.isSpaceScoped() || !config.hasOverridingGlobalConfiguration()) continue;
            int globalConfigId = config.getGlobalConfigurationId();
            Set spaceKeys = (Set)configToSpaceMapping.get(globalConfigId);
            if (spaceKeys != null) {
                spaceKeys.add(config.getSpaceKey());
                continue;
            }
            log.warn(String.format("Global configuration #%d (used by space <%s>) not found", globalConfigId, config.getSpaceKey()));
        }
        return configToSpaceMapping;
    }

    public List<ContentArchivingConfiguration> findGlobalConfigurations() {
        return (List)this.ao.executeInTransaction(() -> {
            Query query = Query.select().where("SPACE_KEY IS NULL", new Object[0]).order("NAME ASC");
            return ContentArchivingConfiguration.fromAo((ContentArchivingConfigurationAo[])this.ao.find(ContentArchivingConfigurationAo.class, query));
        });
    }

    public ContentArchivingConfiguration findGlobalConfiguration(int configurationId) {
        return (ContentArchivingConfiguration)this.ao.executeInTransaction(() -> {
            ContentArchivingConfigurationAo configAo = (ContentArchivingConfigurationAo)this.ao.get(ContentArchivingConfigurationAo.class, (Object)configurationId);
            if (configAo == null) {
                throw new IllegalArgumentException(String.format("Global configuration #%d not found", configurationId));
            }
            ContentArchivingConfiguration config = ContentArchivingConfiguration.fromAo(configAo);
            if (!config.isGlobal()) {
                throw new IllegalArgumentException(String.format("Configuration #%d is not global", configurationId));
            }
            return config;
        });
    }

    public void applyGlobalConfigurationToSpaces(int globalConfigurationId, List<String> spaceKeys) {
        this.ao.executeInTransaction(() -> {
            for (String spaceKey : spaceKeys) {
                ContentArchivingConfigurationAo configAo = this.findSpaceScopedConfigurationAo(spaceKey);
                if (configAo == null) {
                    configAo = (ContentArchivingConfigurationAo)this.ao.create(ContentArchivingConfigurationAo.class, ContentArchivingConfigurationManager.createDbParams(ContentArchivingConfiguration.createDefault(spaceKey)));
                }
                configAo.setGlobalConfigurationId(globalConfigurationId);
                configAo.save();
            }
            return null;
        });
    }

    public void deleteGlobalConfiguration(int configurationId) {
        for (ContentArchivingConfiguration config : this.findAllConfigurations()) {
            if (!config.isSpaceScoped() || !config.isOverriddenBy(configurationId)) continue;
            log.warn(String.format("Global configuration #%d cannot be deleted as it is used by <%s>", configurationId, config.getSpaceKey()));
            return;
        }
        this.ao.executeInTransaction(() -> {
            ContentArchivingConfigurationAo configAo = (ContentArchivingConfigurationAo)this.ao.get(ContentArchivingConfigurationAo.class, (Object)configurationId);
            if (configAo != null) {
                if (ContentArchivingConfiguration.fromAo(configAo).isSpaceScoped()) {
                    log.warn(String.format("Configuration #%d cannot be deleted as it is not global", configurationId));
                    return null;
                }
                this.ao.delete(new RawEntity[]{configAo});
            } else {
                log.warn(String.format("Configuration #%d cannot be deleted as it does not exists", configurationId));
            }
            return null;
        });
    }

    public void purgeDeletedSpaceConfigurations() {
        for (ContentArchivingConfiguration config : this.findAllConfigurations()) {
            String spaceKey;
            boolean spaceStillExists;
            if (!config.isSpaceScoped() || (spaceStillExists = this.spaceManager.getSpace(spaceKey = config.getSpaceKey()) != null)) continue;
            log.debug(String.format("Purging the configuration of the non-existing <%s>", spaceKey));
            this.ao.executeInTransaction(() -> {
                this.ao.deleteWithSQL(ContentArchivingConfigurationAo.class, "SPACE_KEY = ?", new Object[]{spaceKey});
                return null;
            });
        }
    }

    public ContentArchivingConfiguration findResolvedConfiguration(String spaceKey) {
        log.trace(String.format("Loading resolved configuration for <%s>", spaceKey));
        ContentArchivingConfiguration config = this.findSpaceScopedConfiguration(spaceKey);
        if (config.hasOverridingGlobalConfiguration()) {
            int globalConfigId = config.getGlobalConfigurationId();
            log.trace(String.format("Loading the overriding global configuration #%d for <%s>", globalConfigId, spaceKey));
            config = this.findGlobalConfiguration(globalConfigId);
        }
        return config;
    }

    public ContentArchivingConfiguration findSpaceScopedConfiguration(String spaceKey) {
        return (ContentArchivingConfiguration)this.ao.executeInTransaction(() -> {
            ContentArchivingConfigurationAo contentArchivingConfigurationAo = this.findSpaceScopedConfigurationAo(spaceKey);
            return contentArchivingConfigurationAo != null ? ContentArchivingConfiguration.fromAo(contentArchivingConfigurationAo) : ContentArchivingConfiguration.createDefault(spaceKey);
        });
    }

    public int saveConfiguration(ContentArchivingConfiguration config) {
        config.sanitize();
        return (Integer)this.ao.executeInTransaction(() -> {
            ContentArchivingConfigurationAo configAo = null;
            if (config.getId() != null) {
                configAo = (ContentArchivingConfigurationAo)this.ao.get(ContentArchivingConfigurationAo.class, (Object)config.getId());
            } else if (StringUtils.isNotBlank((CharSequence)config.getSpaceKey())) {
                configAo = this.findSpaceScopedConfigurationAo(config.getSpaceKey());
            }
            if (configAo == null) {
                if (config.isGlobal()) {
                    log.debug("Creating global archiving configuration");
                } else {
                    log.debug(String.format("Creating archiving configuration for space <%s>", config.getSpaceKey()));
                }
                configAo = (ContentArchivingConfigurationAo)this.ao.create(ContentArchivingConfigurationAo.class, ContentArchivingConfigurationManager.createDbParams(config));
            } else {
                if (config.isGlobal()) {
                    log.debug(String.format("Updating global archiving configuration #%d", config.getId()));
                } else {
                    log.debug(String.format("Updating archiving configuration for space <%s>", config.getSpaceKey()));
                }
                ContentArchivingConfigurationManager.updateAoFields(configAo, config);
                configAo.save();
            }
            return configAo.getID();
        });
    }

    private ContentArchivingConfigurationAo findSpaceScopedConfigurationAo(String spaceKey) {
        Query query = Query.select().where("SPACE_KEY = ?", new Object[]{spaceKey});
        ContentArchivingConfigurationAo[] contentArchivingConfigurationAos = (ContentArchivingConfigurationAo[])this.ao.find(ContentArchivingConfigurationAo.class, query);
        int numberOfAos = contentArchivingConfigurationAos.length;
        if (numberOfAos > 1) {
            throw new IllegalStateException(String.format("%d archiving configurations found for space <%s> (should be 0 or 1!)", numberOfAos, spaceKey));
        }
        return numberOfAos > 0 ? contentArchivingConfigurationAos[0] : null;
    }

    private static DBParam[] createDbParams(ContentArchivingConfiguration config) {
        return Arrays.asList(new DBParam("SPACE_KEY", (Object)config.getSpaceKey()), new DBParam("GLOBAL_CONFIG_ID", (Object)config.getGlobalConfigurationId()), new DBParam("NAME", (Object)config.getName()), new DBParam("GLOBAL_RUNS_ENABLED", (Object)config.isGlobalRunsEnabled()), new DBParam("PAGE_VIEW_TRK_BY_AGE_ENABLED", (Object)config.isPageViewTrackingByAgeEnabled()), new DBParam("PAGE_VIEW_ALERT_AGE", (Object)config.getPageViewAlertAge()), new DBParam("NOTIFY_AUTHOR_ON_PAGE_VIEW", (Object)config.isNotifyAuthorOnPageView()), new DBParam("NOTIFY_LAST_MDFR_ON_PAGE_VIEW", (Object)config.isNotifyLastModifierOnPageView()), new DBParam("NOTIFY_OWNERS_ON_PAGE_VIEW", (Object)config.isNotifyOwnersOnPageView()), new DBParam("NOTIFY_SPACE_ADMN_ON_PAGE_VIEW", (Object)config.isNotifySpaceAdminsOnPageView()), new DBParam("NOTIFY_SPACE_CRTR_ON_PAGE_VIEW", (Object)config.isNotifySpaceCreatorOnPageView()), new DBParam("NOTIFY_SUPERVISOR_ON_PAGE_VIEW", (Object)config.isNotifySupervisorsOnPageView()), new DBParam("SUPERVISOR_ON_PAGE_VIEW", (Object)config.getSupervisorsOnPageView()), new DBParam("PAGE_EXP_TRK_BY_AGE_ENABLED", (Object)config.isPageExpirationTrackingByAgeEnabled()), new DBParam("PAGE_EXP_ALERT_AGE", (Object)config.getPageExpirationAlertAge()), new DBParam("PAGE_EXP_TRK_BY_LABEL_ENABLED", (Object)config.isPageExpirationTrackingByLabelEnabled()), new DBParam("NOTIFY_AUTHOR_ON_PAGE_EXP", (Object)config.isNotifyAuthorOnPageExpiration()), new DBParam("NOTIFY_LAST_MDFR_ON_PAGE_EXP", (Object)config.isNotifyLastModifierOnPageExpiration()), new DBParam("NOTIFY_OWNERS_ON_PAGE_EXP", (Object)config.isNotifyOwnersOnPageExpiration()), new DBParam("NOTIFY_SPACE_ADMN_ON_PAGE_EXP", (Object)config.isNotifySpaceAdminsOnPageExpiration()), new DBParam("NOTIFY_SPACE_CRTR_ON_PAGE_EXP", (Object)config.isNotifySpaceCreatorOnPageExpiration()), new DBParam("NOTIFY_SUPERVISOR_ON_PAGE_EXP", (Object)config.isNotifySupervisorsOnPageExpiration()), new DBParam("SUPERVISOR_ON_PAGE_EXP", (Object)config.getSupervisorsOnPageExpiration()), new DBParam("PAGE_ARCH_BY_VIEW_AGE_ENABLED", (Object)config.isPageArchivingByViewAgeEnabled()), new DBParam("PAGE_ARCH_VIEW_AGE", (Object)config.getPageArchivingViewAge()), new DBParam("PAGE_ARCH_OP_AND", (Object)config.isPageArchivingOperatorAnd()), new DBParam("PAGE_ARCH_BY_EXP_AGE_ENABLED", (Object)config.isPageArchivingByAgeEnabled()), new DBParam("PAGE_ARCH_EXP_AGE", (Object)config.getPageArchivingAge()), new DBParam("PAGE_ARCH_BY_LABEL_ENABLED", (Object)config.isPageArchivingByLabelEnabled()), new DBParam("NOTIFY_AUTHOR_ON_PAGE_ARCH", (Object)config.isNotifyAuthorOnPageArchiving()), new DBParam("NOTIFY_LAST_MDFR_ON_PAGE_ARCH", (Object)config.isNotifyLastModifierOnPageArchiving()), new DBParam("NOTIFY_OWNERS_ON_PAGE_ARCH", (Object)config.isNotifyOwnersOnPageArchiving()), new DBParam("NOTIFY_SPACE_ADMN_ON_PAGE_ARCH", (Object)config.isNotifySpaceAdminsOnPageArchiving()), new DBParam("NOTIFY_SPACE_CRTR_ON_PAGE_ARCH", (Object)config.isNotifySpaceCreatorOnPageArchiving()), new DBParam("NOTIFY_SUPERVISOR_ON_PAGE_ARCH", (Object)config.isNotifySupervisorsOnPageArchiving()), new DBParam("SUPERVISOR_ON_PAGE_ARCH", (Object)config.getSupervisorsOnPageArchiving()), new DBParam("ARCH_STRATEGY_TYPE", (Object)config.getArchivingStrategyType()), new DBParam("ARCH_ACTOR", (Object)config.getPageArchivingActor()), new DBParam("ARCH_SPACE_HIDDEN", (Object)config.isArchiveSpaceHidden()), new DBParam("ARCH_REASON_REQUIRED", (Object)config.isArchivingReasonRequired())).toArray(new DBParam[0]);
    }

    private static void updateAoFields(ContentArchivingConfigurationAo configAo, ContentArchivingConfiguration config) {
        configAo.setSpaceKey(config.getSpaceKey());
        configAo.setGlobalConfigurationId(config.getGlobalConfigurationId());
        configAo.setName(config.getName());
        configAo.setGlobalRunsEnabled(config.isGlobalRunsEnabled());
        configAo.setPageViewTrackingByAgeEnabled(config.isPageViewTrackingByAgeEnabled());
        configAo.setPageViewAlertAge(config.getPageViewAlertAge());
        configAo.setNotifyAuthorOnPageView(config.isNotifyAuthorOnPageView());
        configAo.setNotifyLastModifierOnPageView(config.isNotifyLastModifierOnPageView());
        configAo.setNotifyOwnersOnPageView(config.isNotifyOwnersOnPageView());
        configAo.setNotifySpaceAdminsOnPageView(config.isNotifySpaceAdminsOnPageView());
        configAo.setNotifySpaceCreatorOnPageView(config.isNotifySpaceCreatorOnPageView());
        configAo.setNotifySupervisorsOnPageView(config.isNotifySupervisorsOnPageView());
        configAo.setSupervisorsOnPageView(config.getSupervisorsOnPageView());
        configAo.setPageExpirationTrackingByAgeEnabled(config.isPageExpirationTrackingByAgeEnabled());
        configAo.setPageExpirationAlertAge(config.getPageExpirationAlertAge());
        configAo.setPageExpirationTrackingByLabelEnabled(config.isPageExpirationTrackingByLabelEnabled());
        configAo.setNotifyAuthorOnPageExpiration(config.isNotifyAuthorOnPageExpiration());
        configAo.setNotifyLastModifierOnPageExpiration(config.isNotifyLastModifierOnPageExpiration());
        configAo.setNotifyOwnersOnPageExpiration(config.isNotifyOwnersOnPageExpiration());
        configAo.setNotifySpaceAdminsOnPageExpiration(config.isNotifySpaceAdminsOnPageExpiration());
        configAo.setNotifySpaceCreatorOnPageExpiration(config.isNotifySpaceCreatorOnPageExpiration());
        configAo.setNotifySupervisorsOnPageExpiration(config.isNotifySupervisorsOnPageExpiration());
        configAo.setSupervisorsOnPageExpiration(config.getSupervisorsOnPageExpiration());
        configAo.setPageArchivingByViewAgeEnabled(config.isPageArchivingByViewAgeEnabled());
        configAo.setPageArchivingViewAge(config.getPageArchivingViewAge());
        configAo.setPageArchivingOperatorAnd(config.isPageArchivingOperatorAnd());
        configAo.setPageArchivingByAgeEnabled(config.isPageArchivingByAgeEnabled());
        configAo.setPageArchivingAge(config.getPageArchivingAge());
        configAo.setPageArchivingByLabelEnabled(config.isPageArchivingByLabelEnabled());
        configAo.setNotifyAuthorOnPageArchiving(config.isNotifyAuthorOnPageArchiving());
        configAo.setNotifyLastModifierOnPageArchiving(config.isNotifyLastModifierOnPageArchiving());
        configAo.setNotifyOwnersOnPageArchiving(config.isNotifyOwnersOnPageArchiving());
        configAo.setNotifySpaceAdminsOnPageArchiving(config.isNotifySpaceAdminsOnPageArchiving());
        configAo.setNotifySpaceCreatorOnPageArchiving(config.isNotifySpaceCreatorOnPageArchiving());
        configAo.setNotifySupervisorsOnPageArchiving(config.isNotifySupervisorsOnPageArchiving());
        configAo.setSupervisorsOnPageArchiving(config.getSupervisorsOnPageArchiving());
        configAo.setArchivingStrategyType(config.getArchivingStrategyType());
        configAo.setPageArchivingActor(config.getPageArchivingActor());
        configAo.setArchiveSpaceHidden(config.isArchiveSpaceHidden());
        configAo.setArchivingReasonRequired(config.isArchivingReasonRequired());
    }
}

