/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.eventindex;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.midori.confluence.plugin.archiving.model.ContentView;
import com.midori.confluence.plugin.archiving.model.ao.ContentViewEventAo;
import com.midori.confluence.plugin.archiving.service.eventindex.AbstractContentEventTracker;
import java.util.Date;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentViewTracker
extends AbstractContentEventTracker<ContentView> {
    private static Logger log = LoggerFactory.getLogger(ContentViewTracker.class);

    public ContentViewTracker(ActiveObjects ao, CacheManager cacheManager, TransactionTemplate transactionTemplate) {
        super(ao, cacheManager, transactionTemplate);
    }

    @Override
    protected String getEventName() {
        return "view";
    }

    @Override
    protected Class<? extends RawEntity> getActiveObjectsClass() {
        return ContentViewEventAo.class;
    }

    @Override
    protected ContentView fromAo(RawEntity rawEntity) {
        return ContentView.fromAo((ContentViewEventAo)rawEntity);
    }

    @Override
    protected ContentView fromSerializedFormat(String serialized) {
        return new ContentView(serialized);
    }

    @Override
    protected String getOriginatorNameDbField() {
        return "VIEWER_NAME";
    }

    @Override
    protected String getDateDbField() {
        return "VIEW_DATE";
    }

    public void onContentEvent(String userName, ContentEntityObject ceo) {
        this.enjournal(ceo.getId(), ContentView.newGeneric(userName, new Date()));
    }

    @Override
    protected Logger getLogger() {
        return log;
    }
}

