/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model.type;

public enum PageUpdateEventType {
    EXPLICITLY_EXPIRED("X", "marked as expired"),
    EDITED("E", "edited"),
    ATTACHMENT_ADDED("A", "attachment added"),
    CHILD_UPDATED("C", "child updated");

    private String code;
    private String text;

    private PageUpdateEventType(String code, String text) {
        this.code = code;
        this.text = text;
    }

    public String getCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    public static PageUpdateEventType fromCode(String code) {
        for (PageUpdateEventType type : PageUpdateEventType.values()) {
            if (!type.getCode().equals(code)) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("Unknown page event type code <%s>", code));
    }
}

