/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model.base;

import com.midori.confluence.plugin.archiving.model.base.SpaceAndPageCountingStats;
import java.util.HashMap;
import java.util.Map;

public class DefaultSpaceAndPageCountingStats
implements SpaceAndPageCountingStats {
    private Map<String, Integer> spaceKeyToPageCount = new HashMap<String, Integer>();

    public void addPagesForSpace(String spaceKey, int pages) {
        this.spaceKeyToPageCount.compute(spaceKey, (key, oldValue) -> (oldValue != null ? oldValue : 0) + pages);
    }

    @Override
    public int getSpaceCount() {
        return (int)this.spaceKeyToPageCount.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).count();
    }

    @Override
    public int getPageCount() {
        return this.spaceKeyToPageCount.values().stream().mapToInt(i -> i).sum();
    }

    @Override
    public int getPageCountBySpace(String spaceKey) {
        return this.spaceKeyToPageCount.getOrDefault(spaceKey, 0);
    }

    public String toString() {
        return this.spaceKeyToPageCount.toString();
    }
}

