/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model;

import com.google.common.base.Objects;
import com.midori.confluence.plugin.archiving.model.ao.ContentUpdateEventAo;
import com.midori.confluence.plugin.archiving.model.base.ContentEvent;
import com.midori.confluence.plugin.archiving.model.type.PageUpdateEventType;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ContentUpdate
extends ContentEvent {
    private PageUpdateEventType type;

    public static ContentUpdate fromAo(ContentUpdateEventAo ao) {
        if (ao == null) {
            throw new IllegalArgumentException("ContentUpdateEventAo provided must not be null");
        }
        return new ContentUpdate(ao.getID(), ao.getPageId(), ao.getUpdaterName(), ao.getUpdateDate(), PageUpdateEventType.fromCode(ao.getType()));
    }

    public static ContentUpdate newMarkedAsExpired(String labelerName, Date expirationDate) {
        return ContentUpdate.newGeneric(labelerName, expirationDate, PageUpdateEventType.EXPLICITLY_EXPIRED);
    }

    public static ContentUpdate newPageEdited(String editorName, Date editDate) {
        return ContentUpdate.newGeneric(editorName, editDate, PageUpdateEventType.EDITED);
    }

    public static ContentUpdate newAttachmentAdded(String attachmentAdderName, Date attachmentAddedDate) {
        return ContentUpdate.newGeneric(attachmentAdderName, attachmentAddedDate, PageUpdateEventType.ATTACHMENT_ADDED);
    }

    public static ContentUpdate newChildUpdated(ContentUpdate childUpdate) {
        return ContentUpdate.newGeneric(childUpdate.getUpdaterName(), childUpdate.getUpdateDate(), PageUpdateEventType.CHILD_UPDATED);
    }

    public static ContentUpdate newGeneric(String updaterName, Date updateDate, PageUpdateEventType type) {
        return new ContentUpdate(updaterName, updateDate, type);
    }

    public ContentUpdate() {
    }

    @Override
    public ContentEvent anonymized() {
        return new ContentUpdate(this.id, this.pageId, "undisclosed user", this.date, this.type);
    }

    private ContentUpdate(int id, long pageId, String updaterName, Date updateDate, PageUpdateEventType type) {
        this.id = id;
        this.pageId = pageId;
        this.originatorName = updaterName;
        this.date = new Date(updateDate.getTime());
        this.type = type;
    }

    private ContentUpdate(String updaterName, Date updateDate, PageUpdateEventType type) {
        this.originatorName = updaterName;
        this.date = updateDate != null ? new Date(updateDate.getTime()) : null;
        this.type = type;
    }

    public ContentUpdate(String serialized) {
        super(StringUtils.substringBeforeLast((String)serialized, (String)"|+*+|"));
        this.type = PageUpdateEventType.fromCode(StringUtils.substringAfterLast((String)serialized, (String)"|+*+|"));
    }

    @Override
    public String serialize() {
        return super.serialize() + "|+*+|" + this.type.getCode();
    }

    public String getUpdaterName() {
        return this.getOriginatorName();
    }

    public Date getUpdateDate() {
        return this.getDate();
    }

    public PageUpdateEventType getType() {
        return this.type;
    }

    public String getUpdateAction() {
        return this.type.getText();
    }

    public boolean isExplicitlyExpired() {
        return this.type == PageUpdateEventType.EXPLICITLY_EXPIRED;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(new Object[]{super.hashCode(), this.type});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentUpdate other = (ContentUpdate)obj;
        return Objects.equal(this.id, other.id) && Objects.equal(this.pageId, other.pageId) && Objects.equal(this.originatorName, other.originatorName) && Objects.equal(this.date, other.date) && Objects.equal((Object)this.type, (Object)other.type);
    }
}

