/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.midori.confluence.plugin.archiving.model.base.AbstractContentLifecycleStats;
import com.midori.confluence.plugin.archiving.model.base.SpaceAndPageCountingStats;
import java.util.HashMap;
import java.util.Map;

public class ContentExpirationStats
extends AbstractContentLifecycleStats
implements SpaceAndPageCountingStats {
    private static final long serialVersionUID = 8497141845019393176L;
    private Map<String, Integer> spaceKeyToExpiredPageCount = new HashMap<String, Integer>();

    public Map<String, Integer> getSpaceKeyToExpiredPageCount() {
        return this.spaceKeyToExpiredPageCount;
    }

    public void addExpiredPagesForSpace(String spaceKey, int expiredPages) {
        this.spaceKeyToExpiredPageCount.compute(spaceKey, (key, oldValue) -> (oldValue != null ? oldValue : 0) + expiredPages);
    }

    public int getExpiredPagesBySpace(String spaceKey) {
        return this.spaceKeyToExpiredPageCount.getOrDefault(spaceKey, 0);
    }

    @JsonIgnore
    public int getExpiredPages() {
        return this.spaceKeyToExpiredPageCount.values().stream().mapToInt(i -> i).sum();
    }

    @Override
    @JsonIgnore
    public int getSpaceCount() {
        return (int)this.spaceKeyToExpiredPageCount.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).count();
    }

    @Override
    @JsonIgnore
    public int getPageCount() {
        return this.getExpiredPages();
    }

    @Override
    public int getPageCountBySpace(String spaceKey) {
        return this.getExpiredPagesBySpace(spaceKey);
    }
}

