/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.midori.confluence.plugin.archiving.model.base.AbstractContentLifecycleStats;
import java.util.Collection;

public class ContentArchivingStats
extends AbstractContentLifecycleStats {
    private static final long serialVersionUID = 832065962381502957L;
    private int parentsCreated = 0;
    private int parentsSynched = 0;
    private int pagesCreated = 0;
    private int pagesSynched = 0;
    private int pagesSkipped = 0;
    private int pagesTrashed = 0;

    public static ContentArchivingStats empty() {
        return new ContentArchivingStats();
    }

    public ContentArchivingStats() {
    }

    public ContentArchivingStats(int spaces, int parentsCreated, int parentsSynched, int pagesCreated, int pagesSynched, int pagesSkipped, int pagesTrashed, Collection<String> errors) {
        this.setSpaces(spaces);
        this.setErrors(errors);
        this.parentsCreated = parentsCreated;
        this.parentsSynched = parentsSynched;
        this.pagesCreated = pagesCreated;
        this.pagesSynched = pagesSynched;
        this.pagesSkipped = pagesSkipped;
        this.pagesTrashed = pagesTrashed;
    }

    public int getParentsCreated() {
        return this.parentsCreated;
    }

    public int getParentsSynched() {
        return this.parentsSynched;
    }

    public int getPagesCreated() {
        return this.pagesCreated;
    }

    public int getPagesSynched() {
        return this.pagesSynched;
    }

    @JsonIgnore
    public int getPagesCreatedOrSynched() {
        return this.pagesCreated + this.pagesSynched;
    }

    public int getPagesSkipped() {
        return this.pagesSkipped;
    }

    public int getPagesTrashed() {
        return this.pagesTrashed;
    }

    public ContentArchivingStats merge(ContentArchivingStats other) {
        super.merge(other);
        this.parentsCreated += other.parentsCreated;
        this.parentsSynched += other.parentsSynched;
        this.pagesCreated += other.pagesCreated;
        this.pagesSynched += other.pagesSynched;
        this.pagesSkipped += other.pagesSkipped;
        this.pagesTrashed += other.pagesTrashed;
        return this;
    }
}

