;(function($) {
	const PROGRESS_BAR_EXISTS_CHECK_PERIOD = 1000;
	const PROGRESS_BAR_COMPLETED_CHECK_PERIOD = 300;
	const PROGRESS_BAR_SELECTOR = "#status #taskProgressBar";
	const PERCENTAGE_VALUE_SELECTOR = "#percentComplete";

	const taskId = AJS.Meta.get("taskId");
	const baseUrl = AJS.Meta.get("base-url");
	const spaceKey = AJS.Meta.get("space-key");

	const taskCompletedUrl = baseUrl + (spaceKey ? "" : "/admin/plugins") +
		"/archiving/long-running-task-completed.action?taskId=" + taskId + (spaceKey ? ("&key=" + spaceKey) : "");

	if (taskId) {
		// long running task screen detected
		waitForProgressBarToAppear();
	}

	function waitForProgressBarToAppear() {
		const intervalId = setInterval(() => {
			if ($(PROGRESS_BAR_SELECTOR).length > 0) {
				clearInterval(intervalId);
				// progress bar appeared, wait for it to complete
				waitForProgressBarToComplete();
			}
		}, PROGRESS_BAR_EXISTS_CHECK_PERIOD);
	}

	function waitForProgressBarToComplete() {
		const intervalId = setInterval(() => {
			if ($(PERCENTAGE_VALUE_SELECTOR).text().indexOf("100") >= 0) {
				clearInterval(intervalId);
				const resultsButton = $("<a>", {
					"class": "aui-button aui-button-primary hidden",
					"href": taskCompletedUrl
				}).text("Go to results");
				resultsButton.insertAfter($("#status")).fadeIn(() => {
					// since Confluence 7, fadeIn() does not work on an element with "hidden" class so we remove it manually
					resultsButton.removeClass("hidden");
				});
				$("#taskGreenBar").css("background", "#14892c"); // "AUI green"
			}
		}, PROGRESS_BAR_COMPLETED_CHECK_PERIOD);
	}
})(jQuery);