/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web.rest;

import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.user.User;
import com.midori.confluence.plugin.archiving.web.rest.base.CrowdEntityPickerResource;
import com.midori.confluence.plugin.archiving.web.rest.model.UserDescriptor;
import java.util.Arrays;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/user-picker")
@Produces(value={"application/json"})
public class UserPickerResource
extends CrowdEntityPickerResource<UserDescriptor, ConfluenceUser> {
    @Inject
    public UserPickerResource(CrowdService crowdService) {
        super(crowdService);
    }

    @Override
    @GET
    @Path(value="/options")
    public Response getOptionsByTerm(@QueryParam(value="term") String term) {
        return super.getOptionsByTerm(term);
    }

    @Override
    protected String getEntityNamePlural() {
        return "users";
    }

    @Override
    protected Query<String> buildTermMatchingQuery(String term) throws ServiceException {
        BooleanRestriction nameMatchingRestriction = Combine.anyOf(Arrays.asList(Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)term), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)term), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)term)));
        PropertyRestriction activeRestriction = Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true);
        return QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{nameMatchingRestriction, activeRestriction}), (int)0, (int)10);
    }

    @Override
    protected ConfluenceUser findEntityByName(String name) {
        return FindUserHelper.getUserByUsername((String)name);
    }

    @Override
    protected UserDescriptor entityToRestModel(ConfluenceUser confluenceUser) {
        return new UserDescriptor((User)confluenceUser);
    }
}

