/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web.base;

import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompatManager;
import com.atlassian.confluence.schedule.managers.ScheduledJobManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xwork.FlashScope;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.midori.confluence.plugin.archiving.service.ContentArchivingManager;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleLabelHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecyclePermissionHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleStatusHelper;
import com.midori.confluence.plugin.archiving.service.support.PluginHelper;
import com.midori.confluence.plugin.archiving.service.support.SpaceHelper;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskManager;
import com.midori.confluence.plugin.archiving.service.task.base.ArchivingLongRunningTask;
import com.midori.confluence.plugin.archiving.web.support.RelativeTimeHelper;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public abstract class AbstractArchivingAction
extends AbstractSpaceAction
implements SpaceAware {
    protected static final String FLASH_ERROR_MESSAGE_KEY = "carch.errorMessage";
    protected ContentArchivingManager contentArchivingManager;
    protected ContentLifecycleActorHelper contentLifecycleActorHelper;
    protected ContentLifecycleLabelHelper contentLifecycleLabelHelper;
    protected ContentLifecycleStatusHelper contentLifecycleStatusHelper;
    protected ContentLifecyclePermissionHelper contentLifecyclePermissionHelper;
    protected ContentLifecycleLongRunningTaskManager contentLifecycleLongRunningTaskManager;
    protected PluginHelper pluginHelper;
    private PluginSettingsFactory pluginSettingsFactory;
    protected RelativeTimeHelper relativeTimeHelper;
    protected ScheduledJobManager scheduledJobManager;
    protected ServletActionContextCompatManager servletActionContextCompatManager;
    protected SpaceHelper spaceHelper;
    private String atl_token = null;
    protected String key;
    protected Space archiveSpace;

    public void setContentArchivingManager(ContentArchivingManager contentArchivingManager) {
        this.contentArchivingManager = contentArchivingManager;
    }

    public void setContentLifecycleActorHelper(ContentLifecycleActorHelper contentLifecycleActorHelper) {
        this.contentLifecycleActorHelper = contentLifecycleActorHelper;
    }

    public void setContentLifecycleLabelHelper(ContentLifecycleLabelHelper contentLifecycleLabelHelper) {
        this.contentLifecycleLabelHelper = contentLifecycleLabelHelper;
    }

    public void setContentLifecycleStatusHelper(ContentLifecycleStatusHelper contentLifecycleStatusHelper) {
        this.contentLifecycleStatusHelper = contentLifecycleStatusHelper;
    }

    public ContentLifecyclePermissionHelper getContentLifecyclePermissionHelper() {
        return this.contentLifecyclePermissionHelper;
    }

    public void setContentLifecyclePermissionHelper(ContentLifecyclePermissionHelper contentLifecyclePermissionHelper) {
        this.contentLifecyclePermissionHelper = contentLifecyclePermissionHelper;
    }

    public void setLongRunningTaskTracker(ContentLifecycleLongRunningTaskManager contentLifecycleLongRunningTaskManager) {
        this.contentLifecycleLongRunningTaskManager = contentLifecycleLongRunningTaskManager;
    }

    public void setMidoriPluginHelper(PluginHelper pluginHelper) {
        this.pluginHelper = pluginHelper;
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void setRelativeTimeHelper(RelativeTimeHelper relativeTimeHelper) {
        this.relativeTimeHelper = relativeTimeHelper;
    }

    public void setScheduledJobManager(ScheduledJobManager jobManager) {
        this.scheduledJobManager = jobManager;
    }

    public void setServletActionContextCompatManager(ServletActionContextCompatManager servletActionContextCompatManager) {
        this.servletActionContextCompatManager = servletActionContextCompatManager;
    }

    public void setSpaceHelper(SpaceHelper spaceHelper) {
        this.spaceHelper = spaceHelper;
    }

    @StrutsParameter
    public void setAtl_token(String atl_token) {
        this.atl_token = atl_token;
    }

    protected boolean isSessionExpired() {
        if (this.atl_token == null) {
            FlashScope.put((String)FLASH_ERROR_MESSAGE_KEY, (Object)"You changes have not been saved, because your Confluence session has expired in the meanwhile.");
            return true;
        }
        return false;
    }

    public boolean isPermitted() {
        if (this.isGlobal()) {
            return this.contentLifecyclePermissionHelper.canAdministerConfluence();
        }
        return this.contentLifecyclePermissionHelper.canViewSpaceAdministration(this.getSpace());
    }

    protected boolean isDangerousSpaceScopedActionPermitted() {
        return this.contentLifecyclePermissionHelper.canAdministerSpace(this.getSpace());
    }

    public boolean isSpaceRequired() {
        return !this.isGlobal();
    }

    public boolean isViewPermissionRequired() {
        return false;
    }

    public boolean isLicensed() {
        return this.contentLifecycleStatusHelper.isDisposable();
    }

    public boolean isDatacenter() {
        return this.contentLifecycleStatusHelper.isComposite();
    }

    public String getErrorMessage() {
        Object errorMessageObject = FlashScope.get((String)FLASH_ERROR_MESSAGE_KEY);
        return errorMessageObject != null ? errorMessageObject.toString() : null;
    }

    public String getKey() {
        return this.key;
    }

    @StrutsParameter
    public void setKey(String key) {
        this.key = this.spaceHelper.getCanonicalSpaceKey(key);
    }

    public boolean isGlobal() {
        return StringUtils.isBlank((CharSequence)this.key);
    }

    public boolean isBlacklisted() {
        return !this.isGlobal() && ContentLifecycleLabelHelper.isBlacklistedSpace(this.space);
    }

    public Space getArchiveSpace() {
        return this.archiveSpace;
    }

    public boolean archivingActorCandidatesExist() {
        Set<ConfluenceUser> actorCandidates = this.contentLifecycleActorHelper.findArchivingActorCandidates();
        return !actorCandidates.isEmpty();
    }

    public ArchivingLongRunningTask getCurrentlyRunningTask() {
        return this.contentLifecycleLongRunningTaskManager.getCurrentlyRunningTask().orElse(null);
    }

    protected void reloadArchiveSpace() {
        String archiveSpaceKey = SpaceHelper.getArchiveSpaceKeyBySpaceKey(this.key);
        this.archiveSpace = this.spaceManager.getSpace(archiveSpaceKey);
    }

    public String getBaseUrl() {
        String baseUrl = this.getGlobalSettings().getBaseUrl();
        return baseUrl + (baseUrl.endsWith("/") ? "" : "/");
    }

    public String getPluginVersion() {
        return this.pluginHelper.getPluginVersion();
    }

    public String getExpectedModelVersion() {
        return "3";
    }

    public String getActualModelVersion() {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        Object versionObject = globalSettings.get("AO_1991C6_#");
        String version = versionObject != null ? (String)StringUtils.defaultIfEmpty((CharSequence)versionObject.toString(), (CharSequence)"0") : "UNKNOWN";
        return version;
    }

    public boolean isModelVersionConsistent() {
        return this.getExpectedModelVersion().equals(this.getActualModelVersion());
    }
}

