/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.atlassian.confluence.core.Beanable;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.util.DateUtils;
import com.google.common.collect.Multimap;
import com.midori.confluence.plugin.archiving.model.ContentArchivingEvent;
import com.midori.confluence.plugin.archiving.model.type.ArchivingEventType;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingEventManager;
import com.midori.confluence.plugin.archiving.util.PageByNameComparator;
import com.midori.confluence.plugin.archiving.web.base.AbstractNonBlacklistedArchivingAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class ViewArchivingEventStreamAction
extends AbstractNonBlacklistedArchivingAction
implements Beanable {
    private static final int PAGE_SIZE = 30;
    public static final SimpleDateFormat FULL_DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String ALL_TYPES_WILDCARD = "*";
    private PageManager pageManager;
    private ContentArchivingEventManager contentArchivingEventManager;
    private Set<ArchivingEventType> type;
    private Integer before;
    private Integer eventId;
    private List<String> eventDescriptions = new ArrayList<String>(30);
    private long earliestEventId;
    private boolean hasMore;
    private String eventTitle;
    private String eventDetails;
    private String eventFormattedDate;

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setContentArchivingEventManager(ContentArchivingEventManager contentArchivingEventManager) {
        this.contentArchivingEventManager = contentArchivingEventManager;
    }

    public String getType() {
        if (this.type.isEmpty()) {
            return ALL_TYPES_WILDCARD;
        }
        ArrayList<String> codes = new ArrayList<String>();
        for (ArchivingEventType eventType : this.type) {
            codes.add(eventType.getCode());
        }
        Collections.sort(codes);
        return StringUtils.join(codes, (String)"");
    }

    @StrutsParameter
    public void setType(String type) {
        if (StringUtils.isBlank((CharSequence)type) || ALL_TYPES_WILDCARD.equals(type)) {
            this.type = Collections.emptySet();
        } else if (!type.isEmpty()) {
            this.type = new HashSet<ArchivingEventType>();
            for (char code : type.toCharArray()) {
                this.type.add(ArchivingEventType.fromCode(String.valueOf(code)));
            }
        } else {
            this.type = Collections.singleton(ArchivingEventType.fromCode(type));
        }
    }

    @StrutsParameter
    public void setBefore(int before) {
        this.before = before == 0 ? null : Integer.valueOf(before);
    }

    @StrutsParameter
    public void setEventId(Integer eventId) {
        this.eventId = eventId;
    }

    public String execute() {
        return "success";
    }

    public String page() {
        List<ContentArchivingEvent> events = this.contentArchivingEventManager.findEvents(this.type, Optional.ofNullable(this.space), Optional.ofNullable(this.before), 30);
        int nonLimitedEventCount = this.contentArchivingEventManager.countEvents(this.type, Optional.ofNullable(this.space), Optional.ofNullable(this.before));
        this.hasMore = nonLimitedEventCount > 30;
        Map<Date, Multimap<String, ContentArchivingEvent>> groupedEvents = ContentArchivingEventManager.groupEventsByDateAndSpaceKey(events);
        for (Date date : groupedEvents.keySet()) {
            Multimap<String, ContentArchivingEvent> eventsOfDate = groupedEvents.get(date);
            for (String spaceKey : eventsOfDate.keySet()) {
                Collection<ContentArchivingEvent> eventsOfDateAndSpace = eventsOfDate.get(spaceKey);
                ContentArchivingEvent firstEvent = ModelUtils.firstElement(eventsOfDateAndSpace);
                StringBuilder buffer = new StringBuilder();
                buffer.append(String.format("<span timestamp=\"%d\">", firstEvent.getDate().getTime()));
                buffer.append(String.format("<span class=\"space\">%s</span> &mdash; ", firstEvent.getSpaceKey()));
                int currentEvent = 0;
                for (ContentArchivingEvent event : eventsOfDateAndSpace) {
                    long count;
                    if (currentEvent++ > 0) {
                        buffer.append(", ");
                    }
                    if ((count = event.getTotalPageCount()) > 0L) {
                        buffer.append(String.format("<a href=\"#\" data-event-id=\"%s\" data-event-type=\"%s\">%d</a> %s ", event.getId(), event.getType().getCode(), count, count == 1L ? "page" : "pages"));
                    }
                    buffer.append(event.getAction());
                    this.earliestEventId = event.getId();
                }
                buffer.append(this.byFullUserName(firstEvent));
                buffer.append(String.format(" <small title=\"%s\">%s</small></span>", FULL_DATEFORMAT.format(firstEvent.getDate()), this.relativeTimeHelper.getRelativeTime(firstEvent.getDate())));
                this.eventDescriptions.add(buffer.toString());
            }
        }
        return "success";
    }

    public String viewEventDetails() {
        ContentArchivingEvent event = this.contentArchivingEventManager.findEventById(this.eventId).orElse(null);
        String action = event.getAction();
        if (action != null) {
            Set<Long> pageIds = event.getPageIds();
            StringBuilder buffer = new StringBuilder();
            buffer.append(String.format("%s pages %s", event.getTotalPageCount(), action));
            buffer.append(this.byFullUserName(event));
            this.eventTitle = buffer.toString();
            buffer = new StringBuilder();
            buffer.append("<table>");
            for (Page page : this.getSortedPages(pageIds)) {
                buffer.append(String.format("<tr><td><span class=\"aui-icon aui-icon-small icon-page content-type-page\">Page:</span>&nbsp;<a href=\"%s%s\">%s</a></td></tr>", this.getContextPath(), page.getUrlPath(), page.getTitle()));
            }
            if (event.getRemainingPageCount() > 0) {
                buffer.append(String.format("<tr><td class=\"andmore\">and %d more pages</td></tr>", event.getRemainingPageCount()));
            }
            buffer.append("</table>");
            this.eventDetails = buffer.toString();
            this.eventFormattedDate = StringUtils.substringBefore((String)DateUtils.formatDateISO8601((Date)event.getDate()), (String)",");
        }
        return "success";
    }

    private String byFullUserName(ContentArchivingEvent event) {
        ConfluenceUser user;
        if (event.getUser() != null && (user = this.getUserByName(event.getUser())) != null) {
            return String.format(" by %s", user.getFullName());
        }
        return "";
    }

    public Object getBean() {
        HashMap<String, Object> bean = new HashMap<String, Object>(3);
        if (this.eventDetails == null) {
            bean.put("eventDescriptions", this.eventDescriptions);
            bean.put("earliestEventId", this.earliestEventId);
            bean.put("hasMore", this.hasMore);
        } else {
            bean.put("eventTitle", this.eventTitle);
            bean.put("eventDetails", this.eventDetails);
            bean.put("eventFormattedDate", this.eventFormattedDate);
        }
        return bean;
    }

    public Set<Page> getSortedPages(Collection<Long> pageIds) {
        TreeSet<Page> pages = new TreeSet<Page>(new PageByNameComparator());
        for (long pageId : pageIds) {
            Page page = this.pageManager.getPage(pageId);
            if (page == null) continue;
            pages.add(page);
        }
        return pages;
    }

    @Deprecated
    String getContextPath() {
        return this.servletActionContextCompatManager.getRequest().getContextPath();
    }
}

