/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.atlassian.confluence.spaces.Space;
import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.service.persistence.GlobalSettingsManager_;
import com.midori.confluence.plugin.archiving.web.base.AbstractArchivingAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageArchivingConfigurationsAction
extends AbstractArchivingAction {
    private static final Logger log = LoggerFactory.getLogger(ManageArchivingConfigurationsAction.class);
    protected ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private GlobalSettingsManager_ globalSettingsManager;
    private int id;
    private Map<Integer, ContentArchivingConfiguration> archivingConfigurations;
    private Map<Integer, SortedSet<String>> configurationToSpaceMapping;
    private Map<Integer, SortedSet<String>> configurationToSpaceMappingIncludingBlacklisted;
    private Integer defaultId;

    public void setContentArchivingConfigurationManager(ContentArchivingConfigurationManager contentArchivingConfigurationManager) {
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
    }

    public void setGlobalSettingsManager_(GlobalSettingsManager_ globalSettingsManager) {
        this.globalSettingsManager = globalSettingsManager;
    }

    @StrutsParameter
    public void setId(int id) {
        this.id = id;
    }

    public Map<Integer, ContentArchivingConfiguration> getArchivingConfigurations() {
        return this.archivingConfigurations;
    }

    public Map<Integer, SortedSet<String>> getConfigurationToSpaceMapping() {
        return this.configurationToSpaceMapping;
    }

    public Map<Integer, SortedSet<String>> getConfigurationToSpaceMappingIncludingBlacklisted() {
        return this.configurationToSpaceMappingIncludingBlacklisted;
    }

    public Integer getDefaultId() {
        return this.defaultId;
    }

    public String execute() {
        this.archivingConfigurations = ModelUtils.getIdentityMap(this.contentArchivingConfigurationManager.findGlobalConfigurations());
        this.configurationToSpaceMappingIncludingBlacklisted = ManageArchivingConfigurationsAction.sortSpaces(this.contentArchivingConfigurationManager.getGlobalConfigurationToSpaceMapping());
        this.configurationToSpaceMapping = this.removeBlacklistedSpacesFromConfigurationToSpaceMapping(this.configurationToSpaceMappingIncludingBlacklisted);
        this.defaultId = this.globalSettingsManager.getGlobalSettings().getDefaultGlobalConfigurationId();
        return "success";
    }

    public String deleteConfiguration() {
        Map<Integer, SortedSet<String>> configurationToSpaceMappingIncludingBlacklisted = ManageArchivingConfigurationsAction.sortSpaces(this.contentArchivingConfigurationManager.getGlobalConfigurationToSpaceMapping());
        if (!configurationToSpaceMappingIncludingBlacklisted.get(this.id).isEmpty()) {
            log.warn(String.format("Archiving configuration #%d cannot be deleted as it is used by spaces", this.id));
            return "success";
        }
        Integer defaultGlobalConfigurationId = this.globalSettingsManager.getGlobalSettings().getDefaultGlobalConfigurationId();
        if (defaultGlobalConfigurationId != null && this.id == defaultGlobalConfigurationId) {
            log.warn(String.format("Archiving configuration #%d cannot be deleted as it is the default one", this.id));
            return "success";
        }
        this.contentArchivingConfigurationManager.deleteGlobalConfiguration(this.id);
        return "success";
    }

    private static Map<Integer, SortedSet<String>> sortSpaces(Map<Integer, Set<String>> configurationToSpaceMapping) {
        HashMap<Integer, SortedSet<String>> sortedConfigurationToSpaceMapping = new HashMap<Integer, SortedSet<String>>();
        for (Map.Entry<Integer, Set<String>> entry : configurationToSpaceMapping.entrySet()) {
            sortedConfigurationToSpaceMapping.put(entry.getKey(), new TreeSet(entry.getValue()));
        }
        return sortedConfigurationToSpaceMapping;
    }

    private Map<Integer, SortedSet<String>> removeBlacklistedSpacesFromConfigurationToSpaceMapping(Map<Integer, SortedSet<String>> configurationToSpaceMappingIncludingBlacklisted) {
        Set blacklistedSpaceKeys = this.spaceHelper.findBlacklistedSpaces().stream().map(Space::getKey).collect(Collectors.toSet());
        return configurationToSpaceMappingIncludingBlacklisted.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            SortedSet spaceKeys = (SortedSet)entry.getValue();
            return spaceKeys.stream().filter(spaceKey -> !blacklistedSpaceKeys.contains(spaceKey)).collect(Collectors.toCollection(TreeSet::new));
        }));
    }
}

