/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.type.ContentArchivingStrategyType;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import com.midori.confluence.plugin.archiving.web.base.AbstractArchivingAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class ConfigureArchivingAction
extends AbstractArchivingAction {
    private ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private ContentLifecycleActorHelper contentLifecycleActorHelper;
    private Integer id;
    private ContentArchivingConfiguration resolvedConfiguration = null;
    private ContentArchivingConfiguration configuration = ContentArchivingConfiguration.createDefault();
    private Map<Integer, ContentArchivingConfiguration> globalConfigurations;

    public void setContentArchivingConfigurationManager(ContentArchivingConfigurationManager contentArchivingConfigurationManager) {
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
    }

    @Override
    public void setContentLifecycleActorHelper(ContentLifecycleActorHelper contentLifecycleActorHelper) {
        this.contentLifecycleActorHelper = contentLifecycleActorHelper;
    }

    public ContentArchivingConfiguration getResolvedConfiguration() {
        return this.resolvedConfiguration;
    }

    public ContentArchivingConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<Integer, ContentArchivingConfiguration> getGlobalConfigurations() {
        return this.globalConfigurations;
    }

    public List<ContentArchivingStrategyType> getArchivingStrategyTypes() {
        return Arrays.asList(ContentArchivingStrategyType.values());
    }

    public Set<String> getPageArchivingActorCandidates() {
        return this.contentLifecycleActorHelper.findArchivingActorCandidateNames();
    }

    public Integer getId() {
        return this.id;
    }

    @StrutsParameter
    public void setId(Integer id) {
        this.id = id;
        this.configuration.setId(id);
    }

    @StrutsParameter
    public void setGlobalConfigurationId(Integer globalConfigurationId) {
        this.configuration.setGlobalConfigurationId(globalConfigurationId);
    }

    @StrutsParameter
    public void setName(String name) {
        this.configuration.setName(StringUtils.trimToNull((String)name));
    }

    @StrutsParameter
    public void setBaseBehaviour(String behaviour) {
        this.configuration.setGlobalRunsEnabled(StringUtils.contains((CharSequence)behaviour, (CharSequence)"globalRunsEnabled"));
    }

    @StrutsParameter
    public void setPageViewTrackingBehaviour(String behaviour) {
        this.configuration.setPageViewTrackingByAgeEnabled(StringUtils.contains((CharSequence)behaviour, (CharSequence)"pageViewTrackingByAgeEnabled"));
        this.configuration.setNotifyAuthorOnPageView(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifyAuthorOnPageView"));
        this.configuration.setNotifyLastModifierOnPageView(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifyLastModifierOnPageView"));
        this.configuration.setNotifyOwnersOnPageView(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifyOwnersOnPageView"));
        this.configuration.setNotifySpaceAdminsOnPageView(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifySpaceAdminsOnPageView"));
        this.configuration.setNotifySpaceCreatorOnPageView(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifySpaceCreatorOnPageView"));
        this.configuration.setNotifySupervisorsOnPageView(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifySupervisorsOnPageView"));
    }

    @StrutsParameter
    public void setPageViewAlertAge(long pageViewAlertAge) {
        this.configuration.setPageViewAlertAge(pageViewAlertAge);
    }

    @StrutsParameter
    public void setSupervisorsOnPageView(String supervisorsOnPageView) {
        this.configuration.setSupervisorsOnPageView(ConfigureArchivingAction.sanitizeUserNamesCsv(supervisorsOnPageView));
    }

    @StrutsParameter
    public void setPageExpirationTrackingBehaviour(String behaviour) {
        this.configuration.setPageExpirationTrackingByAgeEnabled(StringUtils.contains((CharSequence)behaviour, (CharSequence)"pageExpirationTrackingByAgeEnabled"));
        this.configuration.setPageExpirationTrackingByLabelEnabled(StringUtils.contains((CharSequence)behaviour, (CharSequence)"pageExpirationTrackingByLabelEnabled"));
        this.configuration.setNotifyAuthorOnPageExpiration(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifyAuthorOnPageExpiration"));
        this.configuration.setNotifyLastModifierOnPageExpiration(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifyLastModifierOnPageExpiration"));
        this.configuration.setNotifyOwnersOnPageExpiration(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifyOwnersOnPageExpiration"));
        this.configuration.setNotifySpaceAdminsOnPageExpiration(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifySpaceAdminsOnPageExpiration"));
        this.configuration.setNotifySpaceCreatorOnPageExpiration(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifySpaceCreatorOnPageExpiration"));
        this.configuration.setNotifySupervisorsOnPageExpiration(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifySupervisorsOnPageExpiration"));
    }

    @StrutsParameter
    public void setPageExpirationAlertAge(long pageExpirationAlertAge) {
        this.configuration.setPageExpirationAlertAge(pageExpirationAlertAge);
    }

    @StrutsParameter
    public void setSupervisorsOnPageExpiration(String supervisorsOnPageExpiration) {
        this.configuration.setSupervisorsOnPageExpiration(ConfigureArchivingAction.sanitizeUserNamesCsv(supervisorsOnPageExpiration));
    }

    @StrutsParameter
    public void setPageArchivingBehaviour(String behaviour) {
        this.configuration.setPageArchivingByViewAgeEnabled(StringUtils.contains((CharSequence)behaviour, (CharSequence)"pageArchivingByViewAgeEnabled"));
        this.configuration.setPageArchivingOperatorAnd(StringUtils.contains((CharSequence)behaviour, (CharSequence)"pageArchivingOperatorAnd_and"));
        this.configuration.setPageArchivingByAgeEnabled(StringUtils.contains((CharSequence)behaviour, (CharSequence)"pageArchivingByAgeEnabled"));
        this.configuration.setPageArchivingByLabelEnabled(StringUtils.contains((CharSequence)behaviour, (CharSequence)"pageArchivingByLabelEnabled"));
        this.configuration.setNotifyAuthorOnPageArchiving(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifyAuthorOnPageArchiving"));
        this.configuration.setNotifyLastModifierOnPageArchiving(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifyLastModifierOnPageArchiving"));
        this.configuration.setNotifyOwnersOnPageArchiving(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifyOwnersOnPageArchiving"));
        this.configuration.setNotifySpaceAdminsOnPageArchiving(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifySpaceAdminsOnPageArchiving"));
        this.configuration.setNotifySpaceCreatorOnPageArchiving(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifySpaceCreatorOnPageArchiving"));
        this.configuration.setNotifySupervisorsOnPageArchiving(StringUtils.contains((CharSequence)behaviour, (CharSequence)"notifySupervisorsOnPageArchiving"));
        this.configuration.setArchiveSpaceHidden(StringUtils.contains((CharSequence)behaviour, (CharSequence)"archiveSpaceHidden"));
        this.configuration.setArchivingReasonRequired(StringUtils.contains((CharSequence)behaviour, (CharSequence)"archivingReasonRequired"));
    }

    @StrutsParameter
    public void setPageArchivingViewAge(long pageArchivingViewAge) {
        this.configuration.setPageArchivingViewAge(pageArchivingViewAge);
    }

    @StrutsParameter
    public void setPageArchivingAge(long pageArchivingAge) {
        this.configuration.setPageArchivingAge(pageArchivingAge);
    }

    @StrutsParameter
    public void setSupervisorsOnPageArchiving(String supervisorsOnPageArchiving) {
        this.configuration.setSupervisorsOnPageArchiving(ConfigureArchivingAction.sanitizeUserNamesCsv(supervisorsOnPageArchiving));
    }

    @StrutsParameter
    public void setArchivingStrategyType(String archivingStrategyType) {
        this.configuration.setArchivingStrategyType(ContentArchivingStrategyType.valueOf(archivingStrategyType));
    }

    @StrutsParameter
    public void setPageArchivingActor(String pageArchivingActor) {
        this.configuration.setPageArchivingActor(StringUtils.trimToNull((String)pageArchivingActor));
    }

    public String view() {
        this.resolvedConfiguration = this.contentArchivingConfigurationManager.findResolvedConfiguration(this.key);
        return "view";
    }

    public String update() {
        if (this.isGlobal()) {
            this.configuration = this.id != null ? this.contentArchivingConfigurationManager.findGlobalConfiguration(this.id) : ContentArchivingConfiguration.createDefault();
        } else if (this.isDangerousSpaceScopedActionPermitted()) {
            this.configuration = this.contentArchivingConfigurationManager.findSpaceScopedConfiguration(this.key);
        } else {
            return "error";
        }
        this.globalConfigurations = this.isGlobal() ? null : ModelUtils.getIdentityMap(this.contentArchivingConfigurationManager.findGlobalConfigurations());
        this.reloadArchiveSpace();
        return "input";
    }

    public String save() {
        if (this.isSessionExpired() || !this.isGlobal() && !this.isDangerousSpaceScopedActionPermitted()) {
            return "error";
        }
        if (!this.isGlobal()) {
            this.configuration.setSpaceKey(this.key);
        }
        this.contentArchivingConfigurationManager.saveConfiguration(this.configuration);
        this.contentArchivingConfigurationManager.purgeDeletedSpaceConfigurations();
        return "success";
    }

    private static String sanitizeUserNamesCsv(String userNamesCsv) {
        if (StringUtils.isBlank((CharSequence)userNamesCsv)) {
            return null;
        }
        String[] userNames = userNamesCsv.split(",");
        TreeSet<String> trimmedUserNames = new TreeSet<String>();
        for (String userName : userNames) {
            String trimmedUserName = StringUtils.trimToNull((String)userName);
            if (trimmedUserName == null) continue;
            trimmedUserNames.add(trimmedUserName);
        }
        return StringUtils.join(trimmedUserNames, (String)",");
    }
}

