/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.tool;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.spaces.Space;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.midori.confluence.plugin.archiving.model.ContentQualityStats;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;

public class ContentQualityStatsTool {
    private Map<Label, Collection<Space>> spacesBySpaceCategories;
    private Map<String, ContentQualityStats> statsBySpaces;

    public ContentQualityStatsTool(Map<Label, Collection<Space>> spacesBySpaceCategories, Map<String, ContentQualityStats> statsBySpaces) {
        this.spacesBySpaceCategories = spacesBySpaceCategories;
        this.statsBySpaces = statsBySpaces;
    }

    public int getSpaceCount() {
        return this.getSpaces().size();
    }

    public Set<Label> getSpaceCategories() {
        return this.spacesBySpaceCategories.keySet();
    }

    public Collection<Space> getSpacesBySpaceCategory(Label spaceCategory) {
        return this.spacesBySpaceCategories.get(spaceCategory);
    }

    private Set<Space> getSpaces() {
        return !MapUtils.isEmpty(this.spacesBySpaceCategories) ? Sets.newHashSet(Iterables.concat(this.spacesBySpaceCategories.values())) : Collections.emptySet();
    }

    public Date getTimestamp() {
        Date creationDate = new Date();
        for (ContentQualityStats spaceStats : this.statsBySpaces.values()) {
            if (spaceStats == null || !spaceStats.getDate().before(creationDate)) continue;
            creationDate = spaceStats.getDate();
        }
        return creationDate;
    }

    public boolean hasValidStats() {
        for (ContentQualityStats contentQualityStats : this.statsBySpaces.values()) {
            if (contentQualityStats == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasValidCompleteStats() {
        for (Space space : this.getSpaces()) {
            if (this.hasValidSpaceStats(space)) continue;
            return false;
        }
        return true;
    }

    public boolean hasValidSpaceStats(Space space) {
        return this.statsBySpaces.get(space.getKey()) != null;
    }

    public int getQualityPercentageTotal() {
        return ContentQualityStatsTool.qualityPercentage(this.getFreshPagePercentageTotal(), this.getViewedPagePercentageTotal());
    }

    public int getFreshPageCountTotal() {
        int freshPages = 0;
        for (Space space : this.getSpaces()) {
            freshPages += this.getFreshPageCountBySpace(space);
        }
        return freshPages;
    }

    public int getFreshPagePercentageTotal() {
        return ContentQualityStatsTool.safePercentage(this.getFreshPageCountTotal(), this.getPageCountTotal(), 100);
    }

    public int getExpiredPageCountTotal() {
        int expiredPages = 0;
        for (Space space : this.getSpaces()) {
            expiredPages += this.getExpiredPageCountBySpace(space);
        }
        return expiredPages;
    }

    public int getExpiredPagePercentageTotal() {
        return 100 - this.getFreshPagePercentageTotal();
    }

    public int getViewedPageCountTotal() {
        return this.getPageCountTotal() - this.getNotViewedPageCountTotal();
    }

    public int getViewedPagePercentageTotal() {
        return 100 - this.getNotViewedPagePercentageTotal();
    }

    public int getNotViewedPageCountTotal() {
        int notViewedPages = 0;
        for (Space space : this.getSpaces()) {
            notViewedPages += this.getNotViewedPageCountBySpace(space);
        }
        return notViewedPages;
    }

    public int getNotViewedPagePercentageTotal() {
        return ContentQualityStatsTool.safePercentage(this.getNotViewedPageCountTotal(), this.getPageCountTotal(), 0);
    }

    public int getPageCountTotal() {
        return this.getFreshPageCountTotal() + this.getExpiredPageCountTotal();
    }

    public int getPagePercentageTotal() {
        return ContentQualityStatsTool.safePercentage(this.getPageCountTotal(), this.getCombinedPageCountTotal(), 100);
    }

    public int getArchivedPageCountTotal() {
        int archivedPages = 0;
        for (Space space : this.getSpaces()) {
            archivedPages += this.getArchivedPageCountBySpace(space);
        }
        return archivedPages;
    }

    public int getArchivedPagePercentageTotal() {
        return 100 - this.getPagePercentageTotal();
    }

    public int getCombinedPageCountTotal() {
        return this.getPageCountTotal() + this.getArchivedPageCountTotal();
    }

    public int getQualityPercentageBySpaceCategory(Label spaceCategory) {
        return ContentQualityStatsTool.qualityPercentage(this.getFreshPagePercentageBySpaceCategory(spaceCategory), this.getViewedPagePercentageBySpaceCategory(spaceCategory));
    }

    public int getFreshPageCountBySpaceCategory(Label spaceCategory) {
        int freshPages = 0;
        for (Space space : this.spacesBySpaceCategories.get(spaceCategory)) {
            freshPages += this.getFreshPageCountBySpace(space);
        }
        return freshPages;
    }

    public int getFreshPagePercentageBySpaceCategory(Label spaceCategory) {
        return ContentQualityStatsTool.safePercentage(this.getFreshPageCountBySpaceCategory(spaceCategory), this.getPageCountBySpaceCategory(spaceCategory), 100);
    }

    public int getExpiredPageCountBySpaceCategory(Label spaceCategory) {
        int expiredPages = 0;
        for (Space space : this.spacesBySpaceCategories.get(spaceCategory)) {
            expiredPages += this.getExpiredPageCountBySpace(space);
        }
        return expiredPages;
    }

    public int getExpiredPagePercentageBySpaceCategory(Label spaceCategory) {
        return 100 - this.getFreshPagePercentageBySpaceCategory(spaceCategory);
    }

    public int getViewedPageCountBySpaceCategory(Label spaceCategory) {
        return this.getPageCountBySpaceCategory(spaceCategory) - this.getNotViewedPageCountBySpaceCategory(spaceCategory);
    }

    public int getViewedPagePercentageBySpaceCategory(Label spaceCategory) {
        return 100 - this.getNotViewedPagePercentageBySpaceCategory(spaceCategory);
    }

    public int getNotViewedPageCountBySpaceCategory(Label spaceCategory) {
        int notViewedPages = 0;
        for (Space space : this.spacesBySpaceCategories.get(spaceCategory)) {
            notViewedPages += this.getNotViewedPageCountBySpace(space);
        }
        return notViewedPages;
    }

    public int getNotViewedPagePercentageBySpaceCategory(Label spaceCategory) {
        return ContentQualityStatsTool.safePercentage(this.getNotViewedPageCountBySpaceCategory(spaceCategory), this.getPageCountBySpaceCategory(spaceCategory), 0);
    }

    public int getPageCountBySpaceCategory(Label spaceCategory) {
        return this.getFreshPageCountBySpaceCategory(spaceCategory) + this.getExpiredPageCountBySpaceCategory(spaceCategory);
    }

    public int getPagePercentageBySpaceCategory(Label spaceCategory) {
        return ContentQualityStatsTool.safePercentage(this.getPageCountBySpaceCategory(spaceCategory), this.getCombinedPageCountBySpaceCategory(spaceCategory), 100);
    }

    public int getArchivedPageCountBySpaceCategory(Label spaceCategory) {
        int archivedPages = 0;
        for (Space space : this.spacesBySpaceCategories.get(spaceCategory)) {
            archivedPages += this.getArchivedPageCountBySpace(space);
        }
        return archivedPages;
    }

    public int getArchivedPagePercentageBySpaceCategory(Label spaceCategory) {
        return 100 - this.getPagePercentageBySpaceCategory(spaceCategory);
    }

    public int getCombinedPageCountBySpaceCategory(Label spaceCategory) {
        return this.getPageCountBySpaceCategory(spaceCategory) + this.getArchivedPageCountBySpaceCategory(spaceCategory);
    }

    public int getQualityPercentageBySpace(Space space) {
        return ContentQualityStatsTool.qualityPercentage(this.getFreshPagePercentageBySpace(space), this.getViewedPagePercentageBySpace(space));
    }

    public int getFreshPageCountBySpace(Space space) {
        ContentQualityStats spaceStats = this.statsBySpaces.get(space.getKey());
        return spaceStats != null ? spaceStats.getFreshPages() : 0;
    }

    public int getFreshPagePercentageBySpace(Space space) {
        return ContentQualityStatsTool.safePercentage(this.getFreshPageCountBySpace(space), this.getPageCountBySpace(space), 100);
    }

    public int getExpiredPageCountBySpace(Space space) {
        ContentQualityStats spaceStats = this.statsBySpaces.get(space.getKey());
        return spaceStats != null ? spaceStats.getExpiredPages() : 0;
    }

    public int getExpiredPagePercentageBySpace(Space space) {
        return 100 - this.getFreshPagePercentageBySpace(space);
    }

    public int getViewedPageCountBySpace(Space space) {
        return this.getPageCountBySpace(space) - this.getNotViewedPageCountBySpace(space);
    }

    public int getViewedPagePercentageBySpace(Space space) {
        return 100 - this.getNotViewedPagePercentageBySpace(space);
    }

    public int getNotViewedPageCountBySpace(Space space) {
        ContentQualityStats spaceStats = this.statsBySpaces.get(space.getKey());
        return spaceStats != null ? spaceStats.getNotViewedPages() : 0;
    }

    public int getNotViewedPagePercentageBySpace(Space space) {
        return ContentQualityStatsTool.safePercentage(this.getNotViewedPageCountBySpace(space), this.getPageCountBySpace(space), 0);
    }

    public int getPageCountBySpace(Space space) {
        return this.getFreshPageCountBySpace(space) + this.getExpiredPageCountBySpace(space);
    }

    public int getPagePercentageBySpace(Space space) {
        return ContentQualityStatsTool.safePercentage(this.getPageCountBySpace(space), this.getCombinedPageCountBySpace(space), 100);
    }

    public int getArchivedPageCountBySpace(Space space) {
        ContentQualityStats spaceStats = this.statsBySpaces.get(space.getKey());
        return spaceStats != null ? spaceStats.getArchivedPages() : 0;
    }

    public int getArchivedPagePercentageBySpace(Space space) {
        return 100 - this.getPagePercentageBySpace(space);
    }

    public int getCombinedPageCountBySpace(Space space) {
        return this.getPageCountBySpace(space) + this.getArchivedPageCountBySpace(space);
    }

    private static int qualityPercentage(int freshPercentage, int viewedPercentage) {
        return (freshPercentage + viewedPercentage) / 2;
    }

    private static int safePercentage(int part, int total, int fallback) {
        return total > 0 ? 100 * part / total : fallback;
    }
}

