/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.task.base;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.midori.confluence.plugin.archiving.service.ContentArchivingManager;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleStatusHelper;
import com.midori.confluence.plugin.archiving.service.support.PluginHelper;
import com.midori.confluence.plugin.archiving.service.support.SpaceHelper;
import com.midori.confluence.plugin.archiving.service.support.SqlHelper;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskManager;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskResultManager;
import com.midori.confluence.plugin.archiving.service.task.base.AbstractArchivingLongRunningTask;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPageCountingLongRunningTask
extends AbstractArchivingLongRunningTask {
    private static Logger log = LoggerFactory.getLogger(AbstractPageCountingLongRunningTask.class);

    public AbstractPageCountingLongRunningTask(PageManager pageManager, SpaceManager spaceManager, TransactionTemplate transactionTemplate, ContentLifecycleLongRunningTaskManager contentLifecycleLongRunningTaskManager, ContentArchivingManager contentArchivingManager, ContentLifecycleActorHelper contentLifecycleActorHelper, ContentLifecycleStatusHelper contentLifecycleStatusHelper, ContentLifecycleLongRunningTaskResultManager contentLifecycleLongRunningTaskResultManager, PluginHelper pluginHelper, SpaceHelper spaceHelper, SqlHelper sqlHelper, Optional<Space> space, String nodeName) {
        super(pageManager, spaceManager, transactionTemplate, contentLifecycleLongRunningTaskManager, contentArchivingManager, contentLifecycleActorHelper, contentLifecycleStatusHelper, contentLifecycleLongRunningTaskResultManager, pluginHelper, spaceHelper, sqlHelper, space, nodeName);
    }

    @Override
    protected void execute() {
        List spaces = (List)this.transactionTemplate.execute(this::getSpacesToExecuteOn);
        int totalNumberOfPages = this.countPages(spaces);
        this.executeInternal(spaces, totalNumberOfPages);
    }

    protected List<Space> getSpacesToExecuteOn() {
        return this.isSpaceScoped() ? Collections.singletonList((Space)this.space.get()) : this.spaceHelper.findNonBlacklistedGlobalFreshSpaces();
    }

    private int countPages(List<Space> spaces) {
        log.trace(String.format("Counting pages in %d spaces", spaces.size()));
        int pages = 0;
        for (Space spaceToCount : spaces) {
            pages += this.countPages(spaceToCount);
        }
        log.trace(String.format("Found %d pages in %d spaces", pages, spaces.size()));
        return pages;
    }

    protected int countPages(Space space) {
        String query = "SELECT COUNT(*) FROM CONTENT WHERE CONTENTTYPE='PAGE' AND CONTENT_STATUS='current' AND SPACEID=" + space.getId() + " AND PREVVER IS NULL";
        return this.sqlHelper.executeCountQuery(query);
    }

    protected abstract void executeInternal(List<Space> var1, int var2);
}

